/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.internal;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;

public class Location {
    @Nullable
    final Editor editor;
    @Nullable
    final KtFile ktFile;
    final long modificationStamp;
    final int startOffset;
    final int endOffset;

    private Location(@Nullable Editor editor2, Project project2) {
        this.editor = editor2;
        if (editor2 != null) {
            PsiFile psiFile2;
            this.modificationStamp = editor2.getDocument().getModificationStamp();
            this.startOffset = editor2.getSelectionModel().getSelectionStart();
            this.endOffset = editor2.getSelectionModel().getSelectionEnd();
            VirtualFile vFile = ((EditorEx)editor2).getVirtualFile();
            this.ktFile = vFile == null ? null : ((psiFile2 = PsiManager.getInstance((Project)project2).findFile(vFile)) instanceof KtFile ? (KtFile)psiFile2 : null);
        } else {
            this.modificationStamp = 0L;
            this.startOffset = 0;
            this.endOffset = 0;
            this.ktFile = null;
        }
    }

    public static Location fromEditor(Editor editor2, Project project2) {
        return new Location(editor2, project2);
    }

    @Nullable
    public KtFile getKFile() {
        return this.ktFile;
    }

    @Nullable
    public Editor getEditor() {
        return this.editor;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location location2 = (Location)o;
        if (this.modificationStamp != location2.modificationStamp) {
            return false;
        }
        if (this.endOffset != location2.endOffset) {
            return false;
        }
        if (this.startOffset != location2.startOffset) {
            return false;
        }
        if (this.editor != null ? !this.editor.equals(location2.editor) : location2.editor != null) {
            return false;
        }
        return !(this.ktFile != null ? !this.ktFile.equals(location2.ktFile) : location2.ktFile != null);
    }

    public int hashCode() {
        int result2 = this.editor != null ? this.editor.hashCode() : 0;
        result2 = 31 * result2 + (this.ktFile != null ? this.ktFile.hashCode() : 0);
        result2 = 31 * result2 + (int)(this.modificationStamp ^ this.modificationStamp >>> 32);
        result2 = 31 * result2 + this.startOffset;
        result2 = 31 * result2 + this.endOffset;
        return result2;
    }
}

