/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.KotlinUniversalQuickFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinCrossLanguageQuickFixAction;
import org.jetbrains.kotlin.idea.quickfix.PsiElementSuitabilityChecker;
import org.jetbrains.kotlin.idea.quickfix.PsiElementSuitabilityCheckers;
import org.jetbrains.kotlin.idea.quickfix.QuickFixesPsiBasedFactory;
import org.jetbrains.kotlin.idea.quickfix.RemoveModifierFixBase;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u0018\u0019B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002H\u0004J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0016\u0010\u0005\u001a\u00020\u00068\u0004X\u0085\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinCrossLanguageQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "Lorg/jetbrains/kotlin/idea/inspections/KotlinUniversalQuickFix;", "element", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)V", "getModifier", "()Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "getFamilyName", "", "getText", "invokeImpl", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invokeOnElement", "isAvailableImpl", "", "Companion", "Factory", "kotlin.fir.frontend-independent"})
public class AddModifierFix
extends KotlinCrossLanguageQuickFixAction<KtModifierListOwner>
implements KotlinUniversalQuickFix {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final KtModifierKeywordToken modifier;
    @NotNull
    private static final QuickFixesPsiBasedFactory<PsiElement> addAbstractModifier;
    @NotNull
    private static final QuickFixesPsiBasedFactory<PsiElement> addAbstractToContainingClass;
    @NotNull
    private static final QuickFixesPsiBasedFactory<PsiElement> addOpenToContainingClass;
    @NotNull
    private static final QuickFixesPsiBasedFactory<PsiElement> addFinalToProperty;
    @NotNull
    private static final QuickFixesPsiBasedFactory<PsiElement> addInnerModifier;
    @NotNull
    private static final QuickFixesPsiBasedFactory<PsiElement> addOverrideModifier;
    @NotNull
    private static final Set<KtModifierKeywordToken> modifiersWithWarning;
    private static final Set<KtModifierKeywordToken> modalityModifiers;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public String getText() {
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)this.getElement();
        if (ktModifierListOwner == null) {
            return "";
        }
        KtModifierListOwner element3 = ktModifierListOwner;
        if (modalityModifiers.contains(this.modifier) || KtTokens.VISIBILITY_MODIFIERS.contains((IElementType)this.modifier) || Intrinsics.areEqual((Object)this.modifier, (Object)KtTokens.CONST_KEYWORD)) {
            Object[] objectArray = new Object[2];
            objectArray[0] = RemoveModifierFixBase.Companion.getElementName(element3);
            String string = this.modifier.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"modifier.value");
            objectArray[1] = string;
            return KotlinBundle.message("fix.add.modifier.text", objectArray);
        }
        Object[] objectArray = new Object[1];
        String string = this.modifier.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"modifier.value");
        objectArray[0] = string;
        return KotlinBundle.message("fix.add.modifier.text.generic", objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message("fix.add.modifier.family", new Object[0]);
    }

    protected final void invokeOnElement(@Nullable KtModifierListOwner element3) {
        block3: {
            KtModifierListOwner ktModifierListOwner = element3;
            if (ktModifierListOwner != null) {
                ktModifierListOwner.addModifier(this.modifier);
            }
            if (!Intrinsics.areEqual((Object)this.modifier, (Object)KtTokens.ABSTRACT_KEYWORD) || !(element3 instanceof KtProperty) && !(element3 instanceof KtNamedFunction)) break block3;
            KtClass ktClass2 = KtPsiUtilKt.containingClass((KtElement)((KtElement)element3));
            if (ktClass2 != null) {
                KtClass ktClass3;
                KtClass $this$run = ktClass3 = ktClass2;
                boolean bl = false;
                if (!$this$run.hasModifier(KtTokens.ABSTRACT_KEYWORD) && !$this$run.hasModifier(KtTokens.SEALED_KEYWORD)) {
                    $this$run.addModifier(KtTokens.ABSTRACT_KEYWORD);
                }
            }
        }
    }

    @Override
    protected void invokeImpl(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        KtModifierListOwner originalElement = (KtModifierListOwner)this.getElement();
        this.invokeOnElement(originalElement);
    }

    @Override
    protected boolean isAvailableImpl(@NotNull Project project2, @Nullable Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.getElement() != null;
    }

    @NotNull
    protected final KtModifierKeywordToken getModifier() {
        return this.modifier;
    }

    public AddModifierFix(@NotNull KtModifierListOwner element3, @NotNull KtModifierKeywordToken modifier) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
        super((PsiElement)element3);
        this.modifier = modifier;
    }

    static {
        Companion = new Companion(null);
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"KtTokens.ABSTRACT_KEYWORD");
        addAbstractModifier = Companion.createFactory(ktModifierKeywordToken);
        KtModifierKeywordToken ktModifierKeywordToken2 = KtTokens.ABSTRACT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken2, (String)"KtTokens.ABSTRACT_KEYWORD");
        addAbstractToContainingClass = Companion.createFactory(ktModifierKeywordToken2, KtClassOrObject.class);
        KtModifierKeywordToken ktModifierKeywordToken3 = KtTokens.OPEN_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken3, (String)"KtTokens.OPEN_KEYWORD");
        addOpenToContainingClass = Companion.createFactory(ktModifierKeywordToken3, KtClassOrObject.class);
        KtModifierKeywordToken ktModifierKeywordToken4 = KtTokens.FINAL_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken4, (String)"KtTokens.FINAL_KEYWORD");
        addFinalToProperty = Companion.createFactory(ktModifierKeywordToken4, KtProperty.class);
        KtModifierKeywordToken ktModifierKeywordToken5 = KtTokens.INNER_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken5, (String)"KtTokens.INNER_KEYWORD");
        addInnerModifier = Companion.createFactory(ktModifierKeywordToken5);
        KtModifierKeywordToken ktModifierKeywordToken6 = KtTokens.OVERRIDE_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken6, (String)"KtTokens.OVERRIDE_KEYWORD");
        addOverrideModifier = Companion.createFactory(ktModifierKeywordToken6);
        modifiersWithWarning = SetsKt.setOf((Object[])new KtModifierKeywordToken[]{KtTokens.ABSTRACT_KEYWORD, KtTokens.FINAL_KEYWORD});
        modalityModifiers = SetsKt.plus(modifiersWithWarning, (Object)KtTokens.OPEN_KEYWORD);
    }

    @Override
    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        KotlinUniversalQuickFix.DefaultImpls.applyFix(this, project2, descriptor2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J.\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\"\b\b\u0001\u0010\u0001*\u00020\t2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00010\u000bH\u0016J\u001f\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\bH&\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix$Factory;", "T", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix;", "", "createFactory", "Lorg/jetbrains/kotlin/idea/quickfix/QuickFixesPsiBasedFactory;", "Lcom/intellij/psi/PsiElement;", "modifier", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "modifierOwnerClass", "Ljava/lang/Class;", "createIfApplicable", "modifierListOwner", "(Lorg/jetbrains/kotlin/psi/KtModifierListOwner;Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;)Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix;", "createModifierFix", "element", "kotlin.fir.frontend-independent"})
    public static interface Factory<T extends AddModifierFix> {
        @NotNull
        public QuickFixesPsiBasedFactory<PsiElement> createFactory(@NotNull KtModifierKeywordToken var1);

        @NotNull
        public <T extends KtModifierListOwner> QuickFixesPsiBasedFactory<PsiElement> createFactory(@NotNull KtModifierKeywordToken var1, @NotNull Class<T> var2);

        @Nullable
        public T createIfApplicable(@NotNull KtModifierListOwner var1, @NotNull KtModifierKeywordToken var2);

        @NotNull
        public T createModifierFix(@NotNull KtModifierListOwner var1, @NotNull KtModifierKeywordToken var2);

        @Metadata(mv={1, 5, 1}, k=3)
        public static final class DefaultImpls {
            @NotNull
            public static <T extends AddModifierFix> QuickFixesPsiBasedFactory<PsiElement> createFactory(@NotNull Factory<T> $this, @NotNull KtModifierKeywordToken modifier) {
                Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
                return $this.createFactory(modifier, KtModifierListOwner.class);
            }

            @NotNull
            public static <T_I1 extends AddModifierFix, T extends KtModifierListOwner> QuickFixesPsiBasedFactory<PsiElement> createFactory(@NotNull Factory<T_I1> $this, @NotNull KtModifierKeywordToken modifier, @NotNull Class<T> modifierOwnerClass) {
                Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
                Intrinsics.checkNotNullParameter(modifierOwnerClass, (String)"modifierOwnerClass");
                PsiElementSuitabilityChecker<PsiElement> suitabilityChecker$iv = PsiElementSuitabilityCheckers.INSTANCE.getALWAYS_SUITABLE();
                boolean $i$f$quickFixesPsiBasedFactory = false;
                return new QuickFixesPsiBasedFactory<PsiElement>(suitabilityChecker$iv, Reflection.getOrCreateKotlinClass(PsiElement.class), suitabilityChecker$iv, $this, modifierOwnerClass, modifier){
                    final /* synthetic */ PsiElementSuitabilityChecker $suitabilityChecker;
                    final /* synthetic */ Factory this$0;
                    final /* synthetic */ Class $modifierOwnerClass$inlined;
                    final /* synthetic */ KtModifierKeywordToken $modifier$inlined;
                    {
                        this.$suitabilityChecker = $captured_local_variable$1;
                        this.this$0 = factory2;
                        this.$modifierOwnerClass$inlined = clazz;
                        this.$modifier$inlined = ktModifierKeywordToken;
                        super($super_call_param$2, $super_call_param$3);
                    }

                    @NotNull
                    protected List<IntentionAction> doCreateQuickFix(@NotNull PsiElement psiElement2) {
                        List list2;
                        Intrinsics.checkNotNullParameter((Object)psiElement2, (String)"psiElement");
                        PsiElement e = psiElement2;
                        boolean bl = false;
                        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)e, (Class)this.$modifierOwnerClass$inlined, (boolean)false);
                        if (ktModifierListOwner == null) {
                            list2 = CollectionsKt.emptyList();
                        } else {
                            Intrinsics.checkNotNullExpressionValue((Object)ktModifierListOwner, (String)"PsiTreeUtil.getParentOfT\u2026iBasedFactory emptyList()");
                            KtModifierListOwner modifierListOwner = ktModifierListOwner;
                            list2 = CollectionsKt.listOfNotNull(this.this$0.createIfApplicable(modifierListOwner, this.$modifier$inlined));
                        }
                        return list2;
                    }
                };
            }

            @Nullable
            public static <T extends AddModifierFix> T createIfApplicable(@NotNull Factory<T> $this, @NotNull KtModifierListOwner modifierListOwner, @NotNull KtModifierKeywordToken modifier) {
                Intrinsics.checkNotNullParameter((Object)modifierListOwner, (String)"modifierListOwner");
                Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
                KtModifierKeywordToken ktModifierKeywordToken = modifier;
                if (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.ABSTRACT_KEYWORD) || Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.OPEN_KEYWORD)) {
                    if (modifierListOwner instanceof KtObjectDeclaration) {
                        return null;
                    }
                    if (modifierListOwner instanceof KtEnumEntry) {
                        return null;
                    }
                    if (modifierListOwner instanceof KtDeclaration && !(modifierListOwner instanceof KtClass)) {
                        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)modifierListOwner));
                        if (ktClassOrObject == null) {
                            return null;
                        }
                        KtClassOrObject parentClassOrObject = ktClassOrObject;
                        if (parentClassOrObject instanceof KtObjectDeclaration) {
                            return null;
                        }
                        if (parentClassOrObject instanceof KtEnumEntry) {
                            return null;
                        }
                    }
                    if (Intrinsics.areEqual((Object)modifier, (Object)KtTokens.ABSTRACT_KEYWORD) && modifierListOwner instanceof KtClass && modifierListOwner.hasModifier(KtTokens.INLINE_KEYWORD)) {
                        return null;
                    }
                } else if (Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtTokens.INNER_KEYWORD)) {
                    if (modifierListOwner instanceof KtObjectDeclaration) {
                        return null;
                    }
                    if (modifierListOwner instanceof KtClass && (((KtClass)modifierListOwner).isInterface() || ((KtClass)modifierListOwner).isSealed() || ((KtClass)modifierListOwner).isEnum() || ((KtClass)modifierListOwner).isData() || ((KtClass)modifierListOwner).isAnnotation())) {
                        return null;
                    }
                }
                return $this.createModifierFix(modifierListOwner, modifier);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0015H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u001c\u0010\u0013\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00150\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix$Companion;", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix$Factory;", "Lorg/jetbrains/kotlin/idea/quickfix/AddModifierFix;", "()V", "addAbstractModifier", "Lorg/jetbrains/kotlin/idea/quickfix/QuickFixesPsiBasedFactory;", "Lcom/intellij/psi/PsiElement;", "getAddAbstractModifier", "()Lorg/jetbrains/kotlin/idea/quickfix/QuickFixesPsiBasedFactory;", "addAbstractToContainingClass", "getAddAbstractToContainingClass", "addFinalToProperty", "getAddFinalToProperty", "addInnerModifier", "getAddInnerModifier", "addOpenToContainingClass", "getAddOpenToContainingClass", "addOverrideModifier", "getAddOverrideModifier", "modalityModifiers", "", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "kotlin.jvm.PlatformType", "modifiersWithWarning", "getModifiersWithWarning", "()Ljava/util/Set;", "createModifierFix", "element", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "modifier", "kotlin.fir.frontend-independent"})
    public static final class Companion
    implements Factory<AddModifierFix> {
        @NotNull
        public final QuickFixesPsiBasedFactory<PsiElement> getAddAbstractModifier() {
            return addAbstractModifier;
        }

        @NotNull
        public final QuickFixesPsiBasedFactory<PsiElement> getAddAbstractToContainingClass() {
            return addAbstractToContainingClass;
        }

        @NotNull
        public final QuickFixesPsiBasedFactory<PsiElement> getAddOpenToContainingClass() {
            return addOpenToContainingClass;
        }

        @NotNull
        public final QuickFixesPsiBasedFactory<PsiElement> getAddFinalToProperty() {
            return addFinalToProperty;
        }

        @NotNull
        public final QuickFixesPsiBasedFactory<PsiElement> getAddInnerModifier() {
            return addInnerModifier;
        }

        @NotNull
        public final QuickFixesPsiBasedFactory<PsiElement> getAddOverrideModifier() {
            return addOverrideModifier;
        }

        @NotNull
        public final Set<KtModifierKeywordToken> getModifiersWithWarning() {
            return modifiersWithWarning;
        }

        @Override
        @NotNull
        public AddModifierFix createModifierFix(@NotNull KtModifierListOwner element3, @NotNull KtModifierKeywordToken modifier) {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            return new AddModifierFix(element3, modifier);
        }

        private Companion() {
        }

        @Override
        @NotNull
        public QuickFixesPsiBasedFactory<PsiElement> createFactory(@NotNull KtModifierKeywordToken modifier) {
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            return Factory.DefaultImpls.createFactory(this, modifier);
        }

        @Override
        @NotNull
        public <T extends KtModifierListOwner> QuickFixesPsiBasedFactory<PsiElement> createFactory(@NotNull KtModifierKeywordToken modifier, @NotNull Class<T> modifierOwnerClass) {
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            Intrinsics.checkNotNullParameter(modifierOwnerClass, (String)"modifierOwnerClass");
            return Factory.DefaultImpls.createFactory(this, modifier, modifierOwnerClass);
        }

        @Override
        @Nullable
        public AddModifierFix createIfApplicable(@NotNull KtModifierListOwner modifierListOwner, @NotNull KtModifierKeywordToken modifier) {
            Intrinsics.checkNotNullParameter((Object)modifierListOwner, (String)"modifierListOwner");
            Intrinsics.checkNotNullParameter((Object)modifier, (String)"modifier");
            return Factory.DefaultImpls.createIfApplicable(this, modifierListOwner, modifier);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

