/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.eclipse.aether.version.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinJVMRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.LibraryJarDescriptor;
import org.jetbrains.kotlin.idea.versions.OutdatedKotlinRuntimeCheckerKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a\u0016\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\u000e"}, d2={"askUpdateRuntime", "", "module", "Lcom/intellij/openapi/module/Module;", "requiredVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "project", "Lcom/intellij/openapi/project/Project;", "librariesToUpdate", "", "Lcom/intellij/openapi/roots/libraries/Library;", "checkUpdateRuntime", "toMavenArtifactVersion", "", "kotlin.jvm"})
public final class EnableUnsupportedFeatureFixKt {
    /*
     * WARNING - void declaration
     */
    public static final boolean checkUpdateRuntime(@NotNull Project project2, @NotNull ApiVersion requiredVersion) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)requiredVersion, (String)"requiredVersion");
        Iterable $this$filter$iv = ProjectStructureUtilKt.allModules(project2);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Module module2 = (Module)element$iv$iv;
            boolean bl = false;
            Module module3 = module2;
            Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"module");
            IdeKotlinVersion ideKotlinVersion = KotlinVersionInfoProviderKt.getRuntimeLibraryVersion(module3);
            Object parsedModuleRuntimeVersion = ideKotlinVersion != null ? ideKotlinVersion.getApiVersion() : null;
            if (!(parsedModuleRuntimeVersion != null && parsedModuleRuntimeVersion.compareTo(requiredVersion) < 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List modulesWithOutdatedRuntime = (List)destination$iv$iv;
        $this$filter$iv = modulesWithOutdatedRuntime;
        if (!$this$filter$iv.isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            $this$filter$iv = modulesWithOutdatedRuntime;
            ApiVersion apiVersion2 = requiredVersion;
            Project project3 = project2;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Library library2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Module it = (Module)element$iv$iv;
                boolean bl2 = false;
                Module module4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)module4, (String)"it");
                if (OutdatedKotlinRuntimeCheckerKt.findKotlinRuntimeLibrary$default(module4, null, 2, null) == null) continue;
                Library it$iv$iv = library2;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list2 = (List)destination$iv$iv;
            if (!EnableUnsupportedFeatureFixKt.askUpdateRuntime(project3, apiVersion2, list2)) {
                return false;
            }
        }
        return true;
    }

    public static final boolean askUpdateRuntime(@NotNull Project project2, @NotNull ApiVersion requiredVersion, @NotNull List<? extends Library> librariesToUpdate) {
        int rc;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)requiredVersion, (String)"requiredVersion");
        Intrinsics.checkNotNullParameter(librariesToUpdate, (String)"librariesToUpdate");
        boolean $i$f$isUnitTestMode = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode() && (rc = Messages.showOkCancelDialog((Project)project2, (String)KotlinJvmBundle.message("this.language.feature.requires.version.0.or.later.of.the.kotlin.runtime.library.would.you.like.to.update.the.runtime.library.in.your.project", requiredVersion), (String)KotlinJvmBundle.message("update.runtime.library", new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
            return false;
        }
        String string = EnableUnsupportedFeatureFixKt.toMavenArtifactVersion(requiredVersion, project2);
        if (string == null) {
            boolean bl = false;
            Messages.showErrorDialog((String)KotlinJvmBundle.message("cant.fetch.available.maven.versions", new Object[0]), (String)KotlinJvmBundle.message("cant.fetch.available.maven.versions.title", new Object[0]));
            return false;
        }
        String upToMavenVersion = string;
        KotlinJVMRuntimeLibraryUtilKt.updateLibraries(project2, upToMavenVersion, (Collection<? extends Library>)librariesToUpdate);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String toMavenArtifactVersion(@NotNull ApiVersion $this$toMavenArtifactVersion, @NotNull Project project2) {
        void mavenVersion;
        Intrinsics.checkNotNullParameter((Object)$this$toMavenArtifactVersion, (String)"$this$toMavenArtifactVersion");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ApiVersion apiVersion2 = $this$toMavenArtifactVersion;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        new Task.Modal(apiVersion2, (Ref.ObjectRef)mavenVersion, project2, project2, KotlinJvmBundle.message("fetching.available.maven.versions.title", new Object[0]), true){
            final /* synthetic */ ApiVersion $apiVersion;
            final /* synthetic */ Ref.ObjectRef $mavenVersion;
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                Version version2;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                RepositoryLibraryProperties repositoryLibraryProperties = LibraryJarDescriptor.RUNTIME_JDK8_JAR.getRepositoryLibraryProperties();
                List list2 = new ArtifactRepositoryManager(JarRepositoryManager.getLocalRepositoryPath()).getAvailableVersions(repositoryLibraryProperties.getGroupId(), repositoryLibraryProperties.getArtifactId(), "[" + this.$apiVersion.getVersionString() + ",)", ArtifactKind.ARTIFACT);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ArtifactRepositoryManage\u2026nd.ARTIFACT\n            )");
                Version version3 = version2 = (Version)CollectionsKt.firstOrNull((List)list2);
                this.$mavenVersion.element = version3 != null ? version3.toString() : null;
            }
            {
                this.$apiVersion = $captured_local_variable$0;
                this.$mavenVersion = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        }.queue();
        return (String)mavenVersion.element;
    }

    public static final boolean askUpdateRuntime(@NotNull Module module2, @NotNull ApiVersion requiredVersion) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)requiredVersion, (String)"requiredVersion");
        Library library2 = OutdatedKotlinRuntimeCheckerKt.findKotlinRuntimeLibrary$default(module2, null, 2, null);
        if (library2 == null) {
            return true;
        }
        Library library3 = library2;
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        return EnableUnsupportedFeatureFixKt.askUpdateRuntime(project2, requiredVersion, CollectionsKt.listOf((Object)library3));
    }
}

