/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.AddExclExclCallFixKt;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/SmartCastImpossibleExclExclFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
public final class SmartCastImpossibleExclExclFixFactory
extends KotlinSingleIntentionActionFactory {
    @NotNull
    public static final SmartCastImpossibleExclExclFixFactory INSTANCE;

    @Override
    @Nullable
    protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        if (diagnostic.getFactory() != Errors.SMARTCAST_IMPOSSIBLE) {
            return null;
        }
        PsiElement psiElement2 = diagnostic.getPsiElement();
        if (!(psiElement2 instanceof KtExpression)) {
            psiElement2 = null;
        }
        KtExpression ktExpression = (KtExpression)psiElement2;
        if (ktExpression == null) {
            return null;
        }
        KtExpression element3 = ktExpression;
        BindingContext analyze2 = ResolutionUtils.analyze((KtElement)element3, BodyResolveMode.PARTIAL);
        KotlinType type2 = analyze2.getType(element3);
        if (type2 == null || !TypeUtils.isNullableType((KotlinType)type2)) {
            return null;
        }
        DiagnosticWithParameters3 diagnosticWithParameters = (DiagnosticWithParameters3)Errors.SMARTCAST_IMPOSSIBLE.cast((UnboundDiagnostic)diagnostic);
        Object object = diagnosticWithParameters.getA();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"diagnosticWithParameters.a");
        KotlinType expectedType = (KotlinType)object;
        if (TypeUtils.isNullableType((KotlinType)expectedType)) {
            return null;
        }
        KotlinType kotlinType = TypeUtils.makeNullable((KotlinType)expectedType);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"TypeUtils.makeNullable(expectedType)");
        KotlinType nullableExpectedType = kotlinType;
        if (!TypeUtilsKt.isSubtypeOf((KotlinType)type2, (KotlinType)nullableExpectedType)) {
            return null;
        }
        return AddExclExclCallFixKt.getAddExclExclCallFix$default((PsiElement)element3, false, 2, null);
    }

    private SmartCastImpossibleExclExclFixFactory() {
    }

    static {
        SmartCastImpossibleExclExclFixFactory smartCastImpossibleExclExclFixFactory;
        INSTANCE = smartCastImpossibleExclExclFixFactory = new SmartCastImpossibleExclExclFixFactory();
    }
}

