/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.FrontendIndependentPsiUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinRenameDispatcherHandler;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinVariableInplaceRenameHandler;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\"\u0010\u000b\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\f\u0010\u000f\u001a\u00020\u0006*\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/KotlinMemberInplaceRenameHandler;", "Lcom/intellij/refactoring/rename/inplace/MemberInplaceRenameHandler;", "()V", "createMemberRenamer", "Lcom/intellij/refactoring/rename/inplace/MemberInplaceRenamer;", "element", "Lcom/intellij/psi/PsiElement;", "elementToRename", "Lcom/intellij/psi/PsiNameIdentifierOwner;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "file", "Lcom/intellij/psi/PsiFile;", "substitute", "RenamerImpl", "kotlin.idea"})
public final class KotlinMemberInplaceRenameHandler
extends MemberInplaceRenameHandler {
    private final PsiElement substitute(PsiElement $this$substitute) {
        if ($this$substitute instanceof KtPrimaryConstructor) {
            return (PsiElement)((KtPrimaryConstructor)$this$substitute).getContainingClassOrObject();
        }
        return $this$substitute;
    }

    @NotNull
    protected MemberInplaceRenamer createMemberRenamer(@NotNull PsiElement element3, @NotNull PsiNameIdentifierOwner elementToRename, @NotNull Editor editor2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        PsiElement psiElement2 = this.substitute((PsiElement)elementToRename);
        if (psiElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiNameIdentifierOwner");
        }
        PsiNameIdentifierOwner currentElementToRename = (PsiNameIdentifierOwner)psiElement2;
        PsiElement nameIdentifier = currentElementToRename.getNameIdentifier();
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        int offset2 = caretModel.getOffset();
        PsiFile editorPsiFile = PsiDocumentManager.getInstance((Project)element3.getProject()).getPsiFile(editor2.getDocument());
        if (nameIdentifier != null && Intrinsics.areEqual((Object)editorPsiFile, (Object)elementToRename.getContainingFile()) && elementToRename instanceof KtPrimaryConstructor && !nameIdentifier.getTextRange().contains(offset2) && ((KtPrimaryConstructor)elementToRename).getTextRange().contains(offset2)) {
            editor2.getCaretModel().moveToOffset(nameIdentifier.getTextOffset());
        }
        if ((object = nameIdentifier) == null || (object = object.getText()) == null) {
            object = "";
        }
        Object currentName = object;
        return new RenamerImpl((PsiNamedElement)currentElementToRename, element3, editor2, (String)currentName, (String)currentName);
    }

    protected boolean isAvailable(@Nullable PsiElement element3, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        EditorSettings editorSettings = editor2.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"editor.settings");
        if (!editorSettings.isVariableInplaceRenameEnabled()) {
            return false;
        }
        PsiElement psiElement2 = element3;
        PsiElement psiElement3 = psiElement2 != null ? this.substitute(psiElement2) : null;
        if (!(psiElement3 instanceof KtNamedDeclaration)) {
            psiElement3 = null;
        }
        KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)psiElement3;
        if (ktNamedDeclaration == null) {
            return false;
        }
        KtNamedDeclaration currentElement = ktNamedDeclaration;
        return currentElement.getNameIdentifier() != null && !KotlinVariableInplaceRenameHandler.Companion.isInplaceRenameAvailable((PsiElement)currentElement);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\tH\u0014J\u001c\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\u001c\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0014\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/KotlinMemberInplaceRenameHandler$RenamerImpl;", "Lcom/intellij/refactoring/rename/inplace/MemberInplaceRenamer;", "elementToRename", "Lcom/intellij/psi/PsiNamedElement;", "substitutedElement", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "currentName", "", "oldName", "(Lcom/intellij/psi/PsiNamedElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;Ljava/lang/String;)V", "acceptReference", "", "reference", "Lcom/intellij/psi/PsiReference;", "createInplaceRenamerToRestart", "Lcom/intellij/refactoring/rename/inplace/VariableInplaceRenamer;", "variable", "initialName", "isIdentifier", "newName", "language", "Lcom/intellij/lang/Language;", "startsOnTheSameElement", "handler", "Lcom/intellij/refactoring/RefactoringActionHandler;", "element", "kotlin.idea"})
    private static final class RenamerImpl
    extends MemberInplaceRenamer {
        protected boolean isIdentifier(@Nullable String newName2, @Nullable Language language2) {
            if (Intrinsics.areEqual((Object)newName2, (Object)"")) {
                PsiNamedElement psiNamedElement = this.getVariable();
                if (!(psiNamedElement instanceof KtObjectDeclaration)) {
                    psiNamedElement = null;
                }
                KtObjectDeclaration ktObjectDeclaration = (KtObjectDeclaration)psiNamedElement;
                if (ktObjectDeclaration != null) {
                    if (ktObjectDeclaration.isCompanion()) {
                        return true;
                    }
                }
            }
            return super.isIdentifier(newName2, language2);
        }

        protected boolean acceptReference(@NotNull PsiReference reference2) {
            Intrinsics.checkNotNullParameter((Object)reference2, (String)"reference");
            PsiElement psiElement2 = reference2.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"reference.element");
            PsiElement refElement2 = psiElement2;
            TextRange textRange = reference2.getRangeInElement();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"reference.rangeInElement");
            TextRange textRange2 = textRange;
            String string = refElement2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"refElement.text");
            String string2 = string;
            int n = textRange2.getStartOffset();
            int n2 = textRange2.getEndOffset();
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String referenceText = FrontendIndependentPsiUtilsKt.unquote(string3);
            PsiNamedElement psiNamedElement = this.myElementToRename;
            Intrinsics.checkNotNullExpressionValue((Object)psiNamedElement, (String)"myElementToRename");
            return Intrinsics.areEqual((Object)referenceText, (Object)psiNamedElement.getName());
        }

        protected boolean startsOnTheSameElement(@Nullable RefactoringActionHandler handler, @Nullable PsiElement element3) {
            return Intrinsics.areEqual((Object)this.getVariable(), (Object)element3) && (handler instanceof MemberInplaceRenameHandler || handler instanceof KotlinRenameDispatcherHandler);
        }

        @NotNull
        protected VariableInplaceRenamer createInplaceRenamerToRestart(@NotNull PsiNamedElement variable2, @NotNull Editor editor2, @NotNull String initialName2) {
            Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)initialName2, (String)"initialName");
            PsiElement psiElement2 = this.getSubstituted();
            String string = this.myOldName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myOldName");
            return (VariableInplaceRenamer)new RenamerImpl(variable2, psiElement2, editor2, initialName2, string);
        }

        public RenamerImpl(@NotNull PsiNamedElement elementToRename, @Nullable PsiElement substitutedElement, @NotNull Editor editor2, @NotNull String currentName, @NotNull String oldName) {
            Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)currentName, (String)"currentName");
            Intrinsics.checkNotNullParameter((Object)oldName, (String)"oldName");
            super(elementToRename, substitutedElement, editor2, currentName, oldName);
        }
    }
}

