/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.search.refIndex;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentMapBuilder;
import com.intellij.util.io.externalizer.StringCollectionExternalizer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.function.IntFunction;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.search.refIndex.ClassOneToManyStorage;
import org.jetbrains.kotlin.name.FqName;

@IntellijInternalApi
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u001f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0002J\u001f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00120\u000e2\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0011H\u0086\u0002J\u001c\u0010\u0013\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\tR;\u0010\u0005\u001a/\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \b*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\t0\t0\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/search/refIndex/ClassOneToManyStorage;", "", "storagePath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "storage", "Lcom/intellij/util/io/PersistentHashMap;", "", "kotlin.jvm.PlatformType", "", "Lorg/jetbrains/annotations/NotNull;", "closeAndClean", "", "get", "Lkotlin/sequences/Sequence;", "key", "deep", "", "Lorg/jetbrains/kotlin/name/FqName;", "put", "values", "Companion", "kotlin.refIndex"})
public final class ClassOneToManyStorage {
    private final PersistentHashMap<String, Collection<String>> storage;
    private static final StringCollectionExternalizer<Collection<String>> externalizer;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final void closeAndClean() {
        this.storage.closeAndClean();
    }

    public final void put(@NotNull String key, @NotNull Collection<String> values2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        this.storage.put((Object)key, values2);
    }

    @NotNull
    public final Sequence<FqName> get(@NotNull FqName key, boolean deep) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = key.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"key.asString()");
        return SequencesKt.map(this.get(string, deep), (Function1)get.1.INSTANCE);
    }

    @NotNull
    public final Sequence<String> get(@NotNull String key, boolean deep) {
        Collection values2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Collection collection = (Collection)this.storage.get((Object)key);
        if (collection == null || (collection = CollectionsKt.asSequence((Iterable)collection)) == null) {
            collection = values2 = SequencesKt.emptySequence();
        }
        if (!deep) {
            return values2;
        }
        return UtilKt.generateRecursiveSequence((Sequence)values2, (Function1)((Function1)new Function1<String, Sequence<? extends String>>(this){
            final /* synthetic */ ClassOneToManyStorage this$0;

            @NotNull
            public final Sequence<String> invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Collection collection = (Collection)ClassOneToManyStorage.access$getStorage$p(this.this$0).get((Object)it);
                if (collection == null || (collection = CollectionsKt.asSequence((Iterable)collection)) == null) {
                    collection = SequencesKt.emptySequence();
                }
                return collection;
            }
            {
                this.this$0 = classOneToManyStorage;
                super(1);
            }
        }));
    }

    public ClassOneToManyStorage(@NotNull Path storagePath) {
        Intrinsics.checkNotNullParameter((Object)storagePath, (String)"storagePath");
        String storageName = PathsKt.getName((Path)storagePath);
        Path path2 = storagePath.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"storagePath.parent");
        Collection $this$ifNotEmpty$iv = PathsKt.listDirectoryEntries((Path)path2, (String)(storageName + "*"));
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$ifNotEmpty = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            Iterable $this$forEach$iv = $this$ifNotEmpty;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path it = (Path)element$iv;
                boolean bl2 = false;
                Path path3 = it;
                Files.deleteIfExists(path3);
            }
            LOG.warn("'" + storageName + "' was deleted");
        }
        PersistentHashMap persistentHashMap = PersistentMapBuilder.newBuilder((Path)storagePath, (KeyDescriptor)((KeyDescriptor)EnumeratorStringDescriptor.INSTANCE), (DataExternalizer)((DataExternalizer)externalizer)).build();
        Intrinsics.checkNotNullExpressionValue((Object)persistentHashMap, (String)"PersistentMapBuilder.new\u2026ternalizer,\n    ).build()");
        this.storage = persistentHashMap;
    }

    static {
        Companion = new Companion(null);
        Object object = Companion.externalizer.1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new IntFunction(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ Object apply(int p0) {
                    return this.function.invoke((Object)p0);
                }
            };
        }
        externalizer = new StringCollectionExternalizer((IntFunction)object);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ClassOneToManyStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ PersistentHashMap access$getStorage$p(ClassOneToManyStorage $this) {
        return $this.storage;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/search/refIndex/ClassOneToManyStorage$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "externalizer", "Lcom/intellij/util/io/externalizer/StringCollectionExternalizer;", "", "", "kotlin.refIndex"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

