/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.stubindex;

import com.intellij.find.ngrams.TrigramIndex;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.util.indexing.GlobalIndexFilter;
import com.intellij.util.indexing.IndexId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007H\u0016J*\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/stubindex/KotlinNonSourceRootIndexFilter;", "Lcom/intellij/util/indexing/GlobalIndexFilter;", "()V", "enabled", "", "affectsIndex", "indexId", "Lcom/intellij/util/indexing/IndexId;", "getVersion", "", "isExcludedFromIndex", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.core"})
public final class KotlinNonSourceRootIndexFilter
implements GlobalIndexFilter {
    private final boolean enabled = !Registry.is((String)"kotlin.index.non.source.roots");

    public boolean isExcludedFromIndex(@NotNull VirtualFile virtualFile2, @NotNull IndexId<?, ?> indexId) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(indexId, (String)"indexId");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isExcludedFromIndex(@NotNull VirtualFile virtualFile2, @NotNull IndexId<?, ?> indexId, @Nullable Project project2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter(indexId, (String)"indexId");
        if (project2 == null) return false;
        if (!this.affectsIndex(indexId)) return false;
        if (!Intrinsics.areEqual((Object)virtualFile2.getExtension(), (Object)"kt")) return false;
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        if (!projectRootManager.getFileIndex().getOrderEntriesForFile(virtualFile2).isEmpty()) return false;
        if (ProjectFileIndex.getInstance((Project)project2).isInLibrary(virtualFile2)) return false;
        return true;
    }

    public int getVersion() {
        return 0;
    }

    public boolean affectsIndex(@NotNull IndexId<?, ?> indexId) {
        Intrinsics.checkNotNullParameter(indexId, (String)"indexId");
        return this.enabled && indexId != TrigramIndex.INDEX_ID && indexId != FilenameIndex.NAME;
    }
}

