/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.googlecode.jatl;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import org.gradle.internal.impldep.com.googlecode.jatl.Indenter;
import org.gradle.internal.impldep.com.googlecode.jatl.InternalStrSubstitutor;
import org.gradle.internal.impldep.com.googlecode.jatl.InternalValidationUtils;
import org.gradle.internal.impldep.com.googlecode.jatl.MarkupBuilderWriter;
import org.gradle.internal.impldep.com.googlecode.jatl.MarkupUtils;
import org.gradle.internal.impldep.com.googlecode.jatl.MarkupWriter;
import org.gradle.internal.impldep.com.googlecode.jatl.SimpleIndenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MarkupBuilder<T> {
    private Stack<Tag> tagStack = new Stack();
    private Writer writer;
    private Map<String, String> attributes = this.createMap();
    private Map<String, Object> bindings = new HashMap<String, Object>();
    private MarkupBuilder<?> previousBuilder = null;
    private int depth = 0;
    private String namespacePrefix = null;
    private Indenter previousIndenter = indentOn;
    private Indenter indenter = indentOn;
    private static final String q = "\"";
    protected static Indenter indentOn = new SimpleIndenter("\n", "\t", "\n", "\t");
    protected static Indenter indentOff = new SimpleIndenter(null, null, null, null);
    protected static Indenter indentSameLine = new SimpleIndenter("\n", "\t", null, null);

    public MarkupBuilder(Writer writer) {
        InternalValidationUtils.notNull(writer, "writer");
        this.writer = writer;
    }

    public MarkupBuilder(MarkupBuilder<?> builder) {
        this(builder, true);
    }

    protected MarkupBuilder() {
    }

    public MarkupBuilder(MarkupBuilder<?> builder, boolean nested) {
        if (nested) {
            super.writeCurrentTag();
        }
        if (nested && !builder.tagStack.isEmpty()) {
            Tag t = builder.tagStack.peek();
            this.depth = 1 + t.depth + builder.depth;
        } else {
            this.depth = builder.depth;
        }
        this.writer = builder.writer;
        builder.writer = null;
        if (nested) {
            this.previousBuilder = builder;
            this.bindings = new HashMap<String, Object>(builder.bindings);
        } else {
            this.tagStack = builder.tagStack;
            this.bindings = builder.bindings;
            this.attributes = builder.attributes;
        }
    }

    protected abstract T getSelf();

    public final T ns() {
        if (this.tagStack.isEmpty()) {
            return this.ns(null);
        }
        return this.ns(this.tagStack.peek().prefix);
    }

    public final T ns(String prefix) {
        this.namespacePrefix = prefix;
        return this.getSelf();
    }

    public final void setWriter(Writer writer) {
        InternalValidationUtils.isTrue(this.writer == null, "Writer is already set.");
        InternalValidationUtils.notNull(writer, "writer");
        this.writer = writer;
    }

    public final void setDepth(int depth) {
        this.depth = depth;
    }

    public T indent(Indenter indenter) {
        if (indenter == null) {
            this.indenter = this.previousIndenter;
        } else {
            this.previousIndenter = this.indenter;
            this.indenter = indenter;
        }
        return this.getSelf();
    }

    private final Map<String, String> getAttributes() {
        return this.attributes;
    }

    public final T text(String text) {
        if (text != null) {
            this.writeCurrentTag();
            this.write(this.escapeElementMarkup(this.expand(text)));
        }
        return this.getSelf();
    }

    public final T raw(String text) {
        return this.raw(text, false);
    }

    public final T raw(String text, boolean expand) {
        if (text != null) {
            this.writeCurrentTag();
            text = expand ? this.expand(text) : text;
            this.write(text);
        }
        return this.getSelf();
    }

    public final T bind(String name, Object value) {
        InternalValidationUtils.notEmpty(name, "name");
        Object v = value != null && value instanceof String ? this.expand(value.toString()) : value;
        this.bindings.put(name, v);
        return this.getSelf();
    }

    public final T unbind(String name) {
        if (this.bindings.containsKey(name)) {
            this.bindings.remove(name);
        }
        return this.getSelf();
    }

    public final T bind(Collection<Map.Entry<String, Object>> nvps) {
        for (Map.Entry<String, Object> nvp : nvps) {
            this.bind(nvp.getKey(), nvp.getValue());
        }
        return this.getSelf();
    }

    public final T start(String tag) {
        return this.start(tag, TagClosingPolicy.NORMAL);
    }

    public final T start(String tag, TagClosingPolicy policy) {
        this.writeCurrentTag();
        Tag t = new Tag(tag);
        t.closePolicy = policy;
        t.depth = this.tagStack.size();
        t.prefix = this.namespacePrefix;
        this.tagStack.push(t);
        return this.getSelf();
    }

    public final T attr(String ... attrs) {
        InternalValidationUtils.isTrue(attrs.length % 2 == 0, "attributes should be multiple of 2 (name=value)");
        if (this.tagStack.isEmpty() || this.tagStack.peek().start) {
            throw new IllegalStateException("There are no open tags to add attributes too. Markup attributes should only be added immediatly after starting a tag.");
        }
        this.checkWriter();
        int n = 0;
        for (int v = 1; v < attrs.length; v += 2) {
            this.getAttributes().put(attrs[n], attrs[v]);
            n += 2;
        }
        return this.getSelf();
    }

    public final T xmlns(String uri) {
        return this.xmlns(uri, null);
    }

    public final T xmlns(String uri, String prefix) {
        if (InternalValidationUtils.isBlank(uri)) {
            return this.getSelf();
        }
        String n = InternalValidationUtils.isBlank(prefix) ? "xmlns" : prefix + ":xmlns";
        return this.attr(n, uri);
    }

    public final T end(int i) {
        while (i-- > 0 && !this.tagStack.isEmpty()) {
            this.end();
        }
        return this.getSelf();
    }

    public final T end() {
        this.checkWriter();
        Tag t = this.tagStack.peek();
        this.writeStartTag(t);
        this.writeEndTag(t);
        this.tagStack.pop();
        this.attributes.clear();
        return this.getSelf();
    }

    public final T endAll() {
        while (!this.tagStack.isEmpty()) {
            this.end();
        }
        return this.getSelf();
    }

    public final void done() {
        this.endAll();
        if (this.previousBuilder != null) {
            InternalValidationUtils.isTrue(this.previousBuilder.writer == null, "The previous builder has its writer set. It should not.");
            this.previousBuilder.writer = this.writer;
        }
        this.writer = null;
    }

    public final T write(MarkupWriter ... writers) {
        this.checkWriter();
        int depth = 1 + (this.tagStack.isEmpty() ? 0 : this.tagStack.peek().depth);
        this.writeCurrentTag();
        InternalValidationUtils.notNull(writers, "writers");
        for (MarkupWriter w : writers) {
            if (w != null && w instanceof MarkupBuilderWriter) {
                ((MarkupBuilderWriter)w).write(this.writer, this.depth + depth);
                continue;
            }
            if (w == null) continue;
            w.write(this.writer);
        }
        return this.getSelf();
    }

    private void writeCurrentTag() {
        this.checkWriter();
        if (!this.tagStack.isEmpty()) {
            Tag current = this.tagStack.peek();
            if (current.empty && !current.end) {
                current.empty = current.closePolicy.isAlwaysSelfClosing();
                this.writeStartTag(current);
                if (current.closePolicy.isAlwaysSelfClosing()) {
                    this.end();
                }
            }
        }
        this.attributes.clear();
    }

    private void writeStartTag(Tag t) {
        if (!t.end && !t.start) {
            this.writeIndent(t, Indenter.TagIndentSpot.BEFORE_START_TAG);
            this.writeTag(t.getQualifiedName(), t.isSelfClosing());
            this.writeIndent(t, Indenter.TagIndentSpot.AFTER_START_TAG);
            if (t.isSelfClosing()) {
                this.writeIndent(t, Indenter.TagIndentSpot.AFTER_END_TAG);
            }
            t.end = t.isSelfClosing();
            t.start = true;
        }
    }

    private void writeTag(String tag, boolean close) {
        Map<String, String> attrs = this.getAttributes();
        this.write("<" + tag);
        if (attrs != null && !attrs.isEmpty()) {
            this.write(" ");
            this.writeAttributes(attrs);
        }
        if (close) {
            this.write("/>");
        } else {
            this.write(">");
        }
    }

    private void writeEndTag(Tag t) {
        if (!t.end) {
            this.writeIndent(t, Indenter.TagIndentSpot.BEFORE_END_TAG);
            this.write("</" + t.getQualifiedName() + ">");
            t.end = true;
            this.writeIndent(t, Indenter.TagIndentSpot.AFTER_END_TAG);
        }
    }

    private void writeAttributes(Map<String, String> attrs) {
        if (attrs == null) {
            return;
        }
        boolean space = false;
        for (Map.Entry<String, String> attr : attrs.entrySet()) {
            String key = attr.getKey();
            String value = attr.getValue();
            if (space) {
                this.write(" ");
            } else {
                space = true;
            }
            this.writeAttr(key, value);
        }
    }

    private void writeAttr(String name, String value) {
        if (value != null && name != null) {
            this.write(this.expand(name + "=" + this.q(value)));
        }
    }

    private String q(String raw) {
        return q + this.escapeAttributeMarkup(this.expand(raw)) + q;
    }

    private String expand(String text) {
        InternalStrSubstitutor s = new InternalStrSubstitutor(this.bindings);
        return s.replace(text);
    }

    private void write(String raw) {
        this.checkWriter();
        try {
            this.writer.write(raw);
        }
        catch (IOException e) {
            throw new RuntimeException("Writer for Builder failed:", e);
        }
    }

    private void checkWriter() {
        InternalValidationUtils.notNull(this.writer, "The writer has not been seet or is in use by another builder.");
    }

    private Map<String, String> createMap() {
        return new LinkedHashMap<String, String>();
    }

    protected String escapeMarkup(String raw) {
        return MarkupUtils.escapeElementEntities(raw);
    }

    protected String escapeElementMarkup(String raw) {
        return this.escapeMarkup(raw);
    }

    protected String escapeAttributeMarkup(String raw) {
        return MarkupUtils.escapeAttributeEntities(raw);
    }

    private void writeIndent(Tag t, Indenter.TagIndentSpot spot) {
        try {
            this.indenter.indentTag(this.writer, t.depth, this.depth, spot, t.name, t.closePolicy, t.empty);
        }
        catch (IOException e) {
            throw new RuntimeException("Builder Indenting failed:", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TagClosingPolicy {
        NORMAL,
        SELF,
        PAIR;


        public final boolean isAlwaysSelfClosing() {
            return this == SELF;
        }

        public final boolean isSelfClosing() {
            return this == SELF || this == NORMAL;
        }

        public final boolean isPairClosing() {
            return this == PAIR || this == NORMAL;
        }
    }

    private static class Tag {
        public int depth = 0;
        public String name;
        public String prefix;
        public boolean empty = true;
        public boolean start = false;
        public boolean end = false;
        public TagClosingPolicy closePolicy = TagClosingPolicy.NORMAL;

        public Tag(String name) {
            this.name = name;
        }

        public String getQualifiedName() {
            return InternalValidationUtils.isBlank(this.prefix) || this.name.contains(":") ? this.name : this.prefix + ":" + this.name;
        }

        public boolean isSelfClosing() {
            return this.empty && this.closePolicy.isSelfClosing();
        }
    }
}

