/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.ivy.util.url;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.gradle.internal.impldep.org.apache.ivy.util.Credentials;
import org.gradle.internal.impldep.org.apache.ivy.util.Message;
import org.gradle.internal.impldep.org.apache.ivy.util.url.CredentialsStore;

public final class IvyAuthenticator
extends Authenticator {
    private Authenticator original;
    private static boolean securityWarningLogged = false;

    private IvyAuthenticator(Authenticator original) {
        this.original = original;
    }

    public static void install() {
        block5: {
            Authenticator original = null;
            try {
                Field f = Authenticator.class.getDeclaredField("theAuthenticator");
                f.setAccessible(true);
                original = (Authenticator)f.get(null);
            }
            catch (Throwable t) {
                Message.debug("Error occurred while getting the original authenticator: " + t.getMessage());
            }
            if (!(original instanceof IvyAuthenticator)) {
                try {
                    Authenticator.setDefault(new IvyAuthenticator(original));
                }
                catch (SecurityException e) {
                    if (securityWarningLogged) break block5;
                    securityWarningLogged = true;
                    Message.warn("Not enough permissions to set the IvyAuthenticator. HTTP(S) authentication will be disabled!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication result = null;
        if (this.isProxyAuthentication()) {
            String proxyUser = System.getProperty("http.proxyUser");
            if (proxyUser != null && proxyUser.trim().length() > 0) {
                String proxyPass = System.getProperty("http.proxyPassword", "");
                Message.debug("authenicating to proxy server with username [" + proxyUser + "]");
                result = new PasswordAuthentication(proxyUser, proxyPass.toCharArray());
            }
        } else {
            Credentials c = CredentialsStore.INSTANCE.getCredentials(this.getRequestingPrompt(), this.getRequestingHost());
            Message.debug("authentication: k='" + Credentials.buildKey(this.getRequestingPrompt(), this.getRequestingHost()) + "' c='" + c + "'");
            if (c != null) {
                String password = c.getPasswd() == null ? "" : c.getPasswd();
                result = new PasswordAuthentication(c.getUserName(), password.toCharArray());
            }
        }
        if (result == null && this.original != null) {
            Authenticator.setDefault(this.original);
            try {
                result = Authenticator.requestPasswordAuthentication(this.getRequestingHost(), this.getRequestingSite(), this.getRequestingPort(), this.getRequestingProtocol(), this.getRequestingPrompt(), this.getRequestingScheme());
            }
            finally {
                Authenticator.setDefault(this);
            }
        }
        return result;
    }

    private boolean isProxyAuthentication() {
        try {
            Method m = Authenticator.class.getDeclaredMethod("getRequestorType", null);
            Object result = m.invoke((Object)this, null);
            return "PROXY".equals(String.valueOf(result));
        }
        catch (NoSuchMethodException e) {
        }
        catch (Throwable t) {
            Message.debug("Error occurred while checking if the authentication request is for the proxy server: " + t.getMessage());
        }
        StackTraceElement[] stackTrace = new Exception().getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            if ("getHttpProxyAuthentication".equals(stackTrace[i].getMethodName())) {
                return true;
            }
            if (!"getServerAuthentication".equals(stackTrace[i].getMethodName())) continue;
            return false;
        }
        String proxyHost = System.getProperty("http.proxyHost");
        return this.getRequestingHost().equals(proxyHost);
    }
}

