/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce;

import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.gradle.internal.impldep.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPException;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.PGPUtil;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.gradle.internal.impldep.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcePBEDataDecryptorFactoryBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private PGPDigestCalculatorProvider calculatorProvider;

    public JcePBEDataDecryptorFactoryBuilder() {
        this.calculatorProvider = null;
    }

    public JcePBEDataDecryptorFactoryBuilder(PGPDigestCalculatorProvider pGPDigestCalculatorProvider) {
        this.calculatorProvider = pGPDigestCalculatorProvider;
    }

    public JcePBEDataDecryptorFactoryBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePBEDataDecryptorFactoryBuilder setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        return this;
    }

    public PBEDataDecryptorFactory build(char[] cArray) {
        if (this.calculatorProvider == null) {
            try {
                this.calculatorProvider = new JcaPGPDigestCalculatorProviderBuilder(this.helper).build();
            }
            catch (PGPException pGPException) {
                throw new IllegalStateException("digest calculator provider cannot be built with current helper: " + pGPException.getMessage());
            }
        }
        return new PBEDataDecryptorFactory(cArray, this.calculatorProvider){

            public byte[] recoverSessionData(int n, byte[] byArray, byte[] byArray2) throws PGPException {
                try {
                    if (byArray2 != null && byArray2.length > 0) {
                        String string = PGPUtil.getSymmetricCipherName(n);
                        Cipher cipher = JcePBEDataDecryptorFactoryBuilder.this.helper.createCipher(string + "/CFB/NoPadding");
                        cipher.init(2, (Key)new SecretKeySpec(byArray, string), new IvParameterSpec(new byte[cipher.getBlockSize()]));
                        return cipher.doFinal(byArray2);
                    }
                    byte[] byArray3 = new byte[byArray.length + 1];
                    byArray3[0] = (byte)n;
                    System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
                    return byArray3;
                }
                catch (Exception exception) {
                    throw new PGPException("Exception recovering session info", exception);
                }
            }

            public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
                return JcePBEDataDecryptorFactoryBuilder.this.helper.createDataDecryptor(bl, n, byArray);
            }
        };
    }
}

