/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.revwalk.filter;

import java.io.IOException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.MissingObjectException;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.StopWalkException;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevCommit;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.RevWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.revwalk.filter.NotRevFilter;

public abstract class RevFilter {
    public static final RevFilter ALL = new AllFilter();
    public static final RevFilter NONE = new NoneFilter();
    public static final RevFilter ONLY_MERGES = new OnlyMergesFilter();
    public static final RevFilter NO_MERGES = new NoMergesFilter();
    public static final RevFilter MERGE_BASE = new MergeBaseFilter();

    public RevFilter negate() {
        return NotRevFilter.create(this);
    }

    public boolean requiresCommitBody() {
        return true;
    }

    public abstract boolean include(RevWalk var1, RevCommit var2) throws StopWalkException, MissingObjectException, IncorrectObjectTypeException, IOException;

    public abstract RevFilter clone();

    public String toString() {
        String n = this.getClass().getName();
        int lastDot = n.lastIndexOf(46);
        if (lastDot >= 0) {
            n = n.substring(lastDot + 1);
        }
        return n.replace('$', '.');
    }

    private static final class AllFilter
    extends RevFilter {
        private AllFilter() {
        }

        @Override
        public boolean include(RevWalk walker, RevCommit c) {
            return true;
        }

        @Override
        public RevFilter clone() {
            return this;
        }

        @Override
        public boolean requiresCommitBody() {
            return false;
        }

        @Override
        public String toString() {
            return "ALL";
        }
    }

    private static final class MergeBaseFilter
    extends RevFilter {
        private MergeBaseFilter() {
        }

        @Override
        public boolean include(RevWalk walker, RevCommit c) {
            throw new UnsupportedOperationException(JGitText.get().cannotBeCombined);
        }

        @Override
        public RevFilter clone() {
            return this;
        }

        @Override
        public boolean requiresCommitBody() {
            return false;
        }

        @Override
        public String toString() {
            return "MERGE_BASE";
        }
    }

    private static final class NoMergesFilter
    extends RevFilter {
        private NoMergesFilter() {
        }

        @Override
        public boolean include(RevWalk walker, RevCommit c) {
            return c.getParentCount() < 2;
        }

        @Override
        public RevFilter clone() {
            return this;
        }

        @Override
        public boolean requiresCommitBody() {
            return false;
        }

        @Override
        public String toString() {
            return "NO_MERGES";
        }
    }

    private static final class NoneFilter
    extends RevFilter {
        private NoneFilter() {
        }

        @Override
        public boolean include(RevWalk walker, RevCommit c) {
            return false;
        }

        @Override
        public RevFilter clone() {
            return this;
        }

        @Override
        public boolean requiresCommitBody() {
            return false;
        }

        @Override
        public String toString() {
            return "NONE";
        }
    }

    private static final class OnlyMergesFilter
    extends RevFilter {
        private OnlyMergesFilter() {
        }

        @Override
        public boolean include(RevWalk walker, RevCommit c) {
            return c.getParentCount() >= 2;
        }

        @Override
        public RevFilter clone() {
            return this;
        }

        @Override
        public boolean requiresCommitBody() {
            return false;
        }

        @Override
        public String toString() {
            return "ONLY_MERGES";
        }
    }
}

