/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.Stack;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleScript;
import org.gradle.util.GUtil;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.GradleManager;
import org.jetbrains.plugins.gradle.execution.build.CachedModuleDataFinder;
import org.jetbrains.plugins.gradle.model.data.GradleProjectBuildScriptData;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleLog;

public final class GradleUtil {
    private static final String LAST_USED_GRADLE_HOME_KEY = "last.used.gradle.home";

    private GradleUtil() {
    }

    @NotNull
    public static FileChooserDescriptor getGradleProjectFileChooserDescriptor() {
        FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, true, false, false, false, false).withFileFilter(file -> file.isCaseSensitive() ? StringUtil.endsWith((CharSequence)file.getName(), (CharSequence)".gradle") || StringUtil.endsWith((CharSequence)file.getName(), (CharSequence)".gradle.kts") : StringUtil.endsWithIgnoreCase((String)file.getName(), (String)".gradle") || StringUtil.endsWithIgnoreCase((String)file.getName(), (String)".gradle.kts"));
        if (fileChooserDescriptor == null) {
            GradleUtil.$$$reportNull$$$0(0);
        }
        return fileChooserDescriptor;
    }

    @NotNull
    public static FileChooserDescriptor getGradleHomeFileChooserDescriptor() {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
        if (fileChooserDescriptor == null) {
            GradleUtil.$$$reportNull$$$0(1);
        }
        return fileChooserDescriptor;
    }

    public static boolean isGradleDefaultWrapperFilesExist(@Nullable String gradleProjectPath) {
        return GradleUtil.getWrapperConfiguration(gradleProjectPath) != null;
    }

    @Nullable
    public static WrapperConfiguration getWrapperConfiguration(@Nullable String gradleProjectPath) {
        Path wrapperPropertiesFile = GradleUtil.findDefaultWrapperPropertiesFile(gradleProjectPath);
        if (wrapperPropertiesFile == null) {
            return null;
        }
        WrapperConfiguration wrapperConfiguration2 = new WrapperConfiguration();
        try {
            String zipStoreBase;
            String zipStorePath;
            String distPathBase;
            Properties props = GUtil.loadProperties((InputStream)Files.newInputStream(wrapperPropertiesFile, new OpenOption[0]));
            String distributionUrl = props.getProperty("distributionUrl");
            if (StringUtil.isEmpty((String)distributionUrl)) {
                throw new ExternalSystemException("Wrapper 'distributionUrl' property does not exist!");
            }
            wrapperConfiguration2.setDistribution(GradleUtil.prepareDistributionUri(distributionUrl, wrapperPropertiesFile));
            String distributionPath = props.getProperty("distributionPath");
            if (!StringUtil.isEmpty((String)distributionPath)) {
                wrapperConfiguration2.setDistributionPath(distributionPath);
            }
            if (!StringUtil.isEmpty((String)(distPathBase = props.getProperty("distributionBase")))) {
                wrapperConfiguration2.setDistributionBase(distPathBase);
            }
            if (!StringUtil.isEmpty((String)(zipStorePath = props.getProperty("zipStorePath")))) {
                wrapperConfiguration2.setZipPath(zipStorePath);
            }
            if (!StringUtil.isEmpty((String)(zipStoreBase = props.getProperty("zipStoreBase")))) {
                wrapperConfiguration2.setZipBase(zipStoreBase);
            }
            return wrapperConfiguration2;
        }
        catch (Exception e) {
            GradleLog.LOG.warn(String.format("I/O exception on reading gradle wrapper properties file at '%s'", wrapperPropertiesFile.toAbsolutePath()), (Throwable)e);
            return null;
        }
    }

    private static URI prepareDistributionUri(String distributionUrl, Path propertiesFile) throws URISyntaxException {
        URI source = new URI(distributionUrl);
        return source.getScheme() != null ? source : propertiesFile.resolveSibling(source.getSchemeSpecificPart()).toUri();
    }

    @NotNull
    public static String getConfigPath(@NotNull GradleProject subProject, @NotNull String rootProjectPath) {
        block9: {
            String string2;
            if (subProject == null) {
                GradleUtil.$$$reportNull$$$0(2);
            }
            if (rootProjectPath == null) {
                GradleUtil.$$$reportNull$$$0(3);
            }
            try {
                File file;
                GradleScript script = subProject.getBuildScript();
                if (script == null || (file = script.getSourceFile()) == null) break block9;
                if (!file.isDirectory()) {
                    file = file.getParentFile();
                }
                string2 = ExternalSystemApiUtil.toCanonicalPath((String)file.getPath());
            }
            catch (Exception script) {
                // empty catch block
            }
            if (string2 == null) {
                GradleUtil.$$$reportNull$$$0(4);
            }
            return string2;
        }
        File rootProjectParent = new File(rootProjectPath);
        StringBuilder buffer = new StringBuilder(FileUtil.toCanonicalPath((String)rootProjectParent.getAbsolutePath()));
        Stack stack = new Stack();
        for (GradleProject p = subProject; p != null; p = p.getParent()) {
            stack.push((Object)p.getName());
        }
        stack.pop();
        while (!stack.isEmpty()) {
            buffer.append('/').append((String)stack.pop());
        }
        String string3 = buffer.toString();
        if (string3 == null) {
            GradleUtil.$$$reportNull$$$0(5);
        }
        return string3;
    }

    @NotNull
    public static String getLastUsedGradleHome() {
        String string2 = PropertiesComponent.getInstance().getValue(LAST_USED_GRADLE_HOME_KEY, "");
        if (string2 == null) {
            GradleUtil.$$$reportNull$$$0(6);
        }
        return string2;
    }

    public static void storeLastUsedGradleHome(@Nullable String gradleHomePath) {
        PropertiesComponent.getInstance().setValue(LAST_USED_GRADLE_HOME_KEY, gradleHomePath, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Path findDefaultWrapperPropertiesFile(@Nullable String gradleProjectPath) {
        Path gradleDir;
        if (gradleProjectPath == null) {
            return null;
        }
        Path file = Path.of(gradleProjectPath, new String[0]);
        Path path2 = gradleDir = Files.isRegularFile(file, new LinkOption[0]) ? file.resolveSibling("gradle") : file.resolve("gradle");
        if (!Files.isDirectory(gradleDir, new LinkOption[0])) {
            return null;
        }
        Path wrapperDir = gradleDir.resolve("wrapper");
        if (!Files.isDirectory(wrapperDir, new LinkOption[0])) {
            return null;
        }
        try (Stream<Path> pathsStream = Files.list(wrapperDir);){
            List candidates = pathsStream.filter(path -> FileUtilRt.extensionEquals((String)path.getFileName().toString(), (String)"properties") && Files.isRegularFile(path, new LinkOption[0])).collect(Collectors.toList());
            if (candidates.isEmpty()) {
                GradleLog.LOG.warn("No *.properties file is found at the gradle wrapper directory " + wrapperDir);
                Path path3 = null;
                return path3;
            }
            if (candidates.size() != 1) {
                GradleLog.LOG.warn(String.format("%d *.properties files instead of one have been found at the wrapper directory (%s): %s", candidates.size(), wrapperDir, StringUtil.join(candidates, (String)", ")));
                Path path4 = null;
                return path4;
            }
            Path path5 = (Path)candidates.get(0);
            return path5;
        }
        catch (IOException e) {
            GradleLog.LOG.warn("Couldn't list gradle wrapper directory " + wrapperDir, (Throwable)e);
            return null;
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    public static String determineRootProject(@NotNull String subProjectPath) {
        Path subProject;
        block7: {
            if (subProjectPath == null) {
                GradleUtil.$$$reportNull$$$0(7);
            }
            Path candidate = subProject = Paths.get(subProjectPath, new String[0]);
            while (true) {
                block8: {
                    if (candidate == null || candidate == candidate.getParent()) break block7;
                    if (!GradleUtil.containsGradleSettingsFile(candidate)) break block8;
                    String string2 = candidate.toString();
                    if (string2 == null) {
                        GradleUtil.$$$reportNull$$$0(8);
                    }
                    return string2;
                }
                candidate = candidate.getParent();
                continue;
                break;
            }
            catch (IOException e) {
                GradleLog.LOG.warn("Failed to determine root Gradle project directory for [" + subProjectPath + "]", (Throwable)e);
            }
        }
        String string3 = Files.isDirectory(subProject, new LinkOption[0]) ? subProjectPath : subProject.getParent().toString();
        if (string3 == null) {
            GradleUtil.$$$reportNull$$$0(9);
        }
        return string3;
    }

    private static boolean containsGradleSettingsFile(Path directory) throws IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return false;
        }
        try (Stream<Path> stream = Files.walk(directory, 1, new FileVisitOption[0]);){
            boolean bl = stream.map(Path::getFileName).filter(Objects::nonNull).map(Path::toString).anyMatch(name2 -> name2.startsWith("settings.gradle"));
            return bl;
        }
    }

    @ApiStatus.Experimental
    @Nullable
    public static DataNode<ModuleData> findGradleModuleData(@NotNull Module module) {
        String projectPath;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(10);
        }
        if ((projectPath = ExternalSystemApiUtil.getExternalProjectPath((Module)module)) == null) {
            return null;
        }
        Project project = module.getProject();
        return GradleUtil.findGradleModuleData(project, projectPath);
    }

    @ApiStatus.Experimental
    @Nullable
    public static DataNode<ModuleData> findGradleModuleData(@NotNull Project project, @NotNull String projectPath) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(11);
        }
        if (projectPath == null) {
            GradleUtil.$$$reportNull$$$0(12);
        }
        return ExternalSystemApiUtil.findModuleNode((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)projectPath);
    }

    @Nullable
    public static Module findGradleModule(@NotNull Project project, @NotNull String projectPath) {
        DataNode moduleNode;
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(13);
        }
        if (projectPath == null) {
            GradleUtil.$$$reportNull$$$0(14);
        }
        if ((moduleNode = ExternalSystemApiUtil.findModuleNode((Project)project, (ProjectSystemId)GradleConstants.SYSTEM_ID, (String)projectPath)) == null) {
            return null;
        }
        return GradleUtil.findGradleModule(project, (ModuleData)moduleNode.getData());
    }

    @Nullable
    public static Module findGradleModule(@NotNull Project project, @NotNull ProjectData projectData) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(15);
        }
        if (projectData == null) {
            GradleUtil.$$$reportNull$$$0(16);
        }
        return GradleUtil.findGradleModule(project, projectData.getLinkedExternalProjectPath());
    }

    @Nullable
    public static Module findGradleModule(@NotNull Project project, @NotNull ModuleData moduleData) {
        if (project == null) {
            GradleUtil.$$$reportNull$$$0(17);
        }
        if (moduleData == null) {
            GradleUtil.$$$reportNull$$$0(18);
        }
        IdeModelsProviderImpl modelsProvider = new IdeModelsProviderImpl(project);
        return modelsProvider.findIdeModule(moduleData);
    }

    @NotNull
    public static GradleVersion getGradleVersion(Project project, PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null) {
            String filePath = virtualFile.getPath();
            return GradleUtil.getGradleVersion(project, filePath);
        }
        GradleVersion gradleVersion2 = GradleVersion.current();
        if (gradleVersion2 == null) {
            GradleUtil.$$$reportNull$$$0(19);
        }
        return gradleVersion2;
    }

    @NotNull
    public static GradleVersion getGradleVersion(Project project, String filePath) {
        GradleSettings settings2;
        GradleProjectSettings projectSettings;
        GradleManager gradleManager;
        String externalProjectPath2;
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)GradleConstants.SYSTEM_ID);
        if (manager instanceof GradleManager && (externalProjectPath2 = (gradleManager = (GradleManager)manager).getAffectedExternalProjectPath(filePath, project)) != null && (projectSettings = (GradleProjectSettings)(settings2 = GradleSettings.getInstance(project)).getLinkedProjectSettings(externalProjectPath2)) != null) {
            GradleVersion gradleVersion2 = projectSettings.resolveGradleVersion();
            if (gradleVersion2 == null) {
                GradleUtil.$$$reportNull$$$0(20);
            }
            return gradleVersion2;
        }
        GradleVersion gradleVersion3 = GradleVersion.current();
        if (gradleVersion3 == null) {
            GradleUtil.$$$reportNull$$$0(21);
        }
        return gradleVersion3;
    }

    public static boolean isSupportedImplementationScope(@NotNull GradleVersion gradleVersion2) {
        if (gradleVersion2 == null) {
            GradleUtil.$$$reportNull$$$0(22);
        }
        return gradleVersion2.getBaseVersion().compareTo(GradleVersion.version((String)"3.4")) >= 0;
    }

    @Nullable
    public static VirtualFile getGradleBuildScriptSource(@NotNull Module module) {
        DataNode<? extends ModuleData> moduleData;
        if (module == null) {
            GradleUtil.$$$reportNull$$$0(23);
        }
        if ((moduleData = CachedModuleDataFinder.getInstance(module.getProject()).findModuleData(module)) == null) {
            return null;
        }
        DataNode dataNode = ExternalSystemApiUtil.find(moduleData, GradleProjectBuildScriptData.KEY);
        if (dataNode == null) {
            return null;
        }
        File data = ((GradleProjectBuildScriptData)dataNode.getData()).getBuildScriptSource();
        if (data == null) {
            return null;
        }
        return VfsUtil.findFileByIoFile((File)data, (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/util/GradleUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subProject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProjectPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subProjectPath";
                break;
            }
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectData";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleData";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleProjectFileChooserDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleHomeFileChooserDescriptor";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/util/GradleUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastUsedGradleHome";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "determineRootProject";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConfigPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "determineRootProject";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findGradleModuleData";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findGradleModule";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedImplementationScope";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getGradleBuildScriptSource";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 23: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

