/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.devkit.workspaceModel;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.devkit.workspaceModel.DevKitWorkspaceModelBundle;
import com.intellij.devkit.workspaceModel.RegenerateWorkspaceModelFix;
import com.intellij.devkit.workspaceModel.WorkspaceImplObsoleteInspectionKt;
import com.intellij.devkit.workspaceModel.WorkspaceKtClassExtentionsKt;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.workspaceModel.storage.CodeGeneratorVersions;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.stubindex.KotlinClassShortNameIndex;
import org.jetbrains.kotlin.parsing.ParseUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtVisitorVoid;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0017\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/devkit/workspaceModel/WorkspaceImplObsoleteInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "calculateTargetApiVersion", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)Ljava/lang/Integer;", "intellij.devkit.workspaceModel"})
public final class WorkspaceImplObsoleteInspection
extends LocalInspectionTool {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new KtVisitorVoid(this, holder){
            final /* synthetic */ WorkspaceImplObsoleteInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitClass(@NotNull KtClass klass) {
                Integer apiVersion;
                Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
                if (!WorkspaceKtClassExtentionsKt.isWorkspaceEntity(klass)) {
                    return;
                }
                Project project = klass.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"klass.project");
                Integer targetApiVersion = WorkspaceImplObsoleteInspection.access$calculateTargetApiVersion(this.this$0, project);
                if (targetApiVersion == null) {
                    WorkspaceImplObsoleteInspectionKt.access$getLOG$p().info("Can't evaluate target API version");
                    return;
                }
                if (Intrinsics.areEqual((Object)klass.getName(), (Object)"Builder")) {
                    return;
                }
                String string = klass.getName() + "Impl";
                Project project2 = klass.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"klass.project");
                GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)klass.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(klass.project)");
                Collection foundImplClasses = KotlinClassShortNameIndex.INSTANCE.get(string, project2, globalSearchScope);
                if (foundImplClasses.isEmpty()) {
                    return;
                }
                KtClassOrObject implClass = (KtClassOrObject)CollectionsKt.first((Iterable)foundImplClasses);
                KtClassOrObject ktClassOrObject = implClass;
                if (!(ktClassOrObject instanceof KtClass)) {
                    ktClassOrObject = null;
                }
                KtClass ktClass = (KtClass)ktClassOrObject;
                Integer n = apiVersion = ktClass != null ? WorkspaceKtClassExtentionsKt.getApiVersion(ktClass) : null;
                if (Intrinsics.areEqual((Object)apiVersion, (Object)targetApiVersion)) {
                    return;
                }
                PsiElement psiElement = klass.getNameIdentifier();
                Intrinsics.checkNotNull((Object)psiElement);
                String string2 = DevKitWorkspaceModelBundle.INSTANCE.message("inspection.workspace.msg.obsolete.implementation", new Object[0]);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                PsiElement psiElement2 = klass.getNameIdentifier();
                Intrinsics.checkNotNull((Object)psiElement2);
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"klass.nameIdentifier!!");
                localQuickFixArray[0] = (LocalQuickFix)new RegenerateWorkspaceModelFix(psiElement2);
                this.$holder.registerProblem(psiElement, string2, localQuickFixArray);
            }
            {
                this.this$0 = this$0;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    private final Integer calculateTargetApiVersion(Project project) {
        KtConstantExpression propertyExpression;
        Object element$iv;
        Object $this$first$iv;
        String fieldName;
        block6: {
            String generatorVersions;
            String string = generatorVersions = Reflection.getOrCreateKotlinClass(CodeGeneratorVersions.class).getSimpleName();
            Intrinsics.checkNotNull((Object)string);
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
            Collection foundClasses = KotlinClassShortNameIndex.INSTANCE.get(string, project, globalSearchScope);
            if (foundClasses.isEmpty()) {
                String string2 = "Can't find " + generatorVersions;
                throw new IllegalStateException(string2.toString());
            }
            KtClassOrObject ktClassOrObject = (KtClassOrObject)CollectionsKt.first((Iterable)foundClasses);
            fieldName = "API_VERSION";
            $this$first$iv = ktClassOrObject.getDeclarations();
            boolean $i$f$first = false;
            Iterator iterator = $this$first$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                KtDeclaration it = (KtDeclaration)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)fieldName)) continue;
                break block6;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        KtDeclaration ktDeclaration = (KtDeclaration)element$iv;
        if (!(ktDeclaration instanceof KtProperty)) {
            $this$first$iv = "Unexpected declaration type for field " + fieldName;
            throw new IllegalStateException($this$first$iv.toString());
        }
        KtExpression ktExpression = ((KtProperty)ktDeclaration).getInitializer();
        if (!(ktExpression instanceof KtConstantExpression)) {
            ktExpression = null;
        }
        if ((propertyExpression = (KtConstantExpression)ktExpression) == null) {
            String $i$f$first = "Property value should be int constant";
            throw new IllegalStateException($i$f$first.toString());
        }
        ASTNode aSTNode = propertyExpression.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"propertyExpression.node");
        IElementType iElementType = aSTNode.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"propertyExpression.node.elementType");
        IElementType elementType = iElementType;
        if (Intrinsics.areEqual((Object)elementType, (Object)KtNodeTypes.INTEGER_CONSTANT)) {
            String string = propertyExpression.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"propertyExpression.text");
            Number number = ParseUtilsKt.parseNumericLiteral((String)string, (IElementType)elementType);
            return number != null ? Integer.valueOf(number.intValue()) : null;
        }
        return null;
    }

    public static final /* synthetic */ Integer access$calculateTargetApiVersion(WorkspaceImplObsoleteInspection $this, Project project) {
        return $this.calculateTargetApiVersion(project);
    }
}

