/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.generator;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.jetbrains.idea.devkit.dom.generator.Emitter;
import org.jetbrains.idea.devkit.dom.generator.FieldDesc;
import org.jetbrains.idea.devkit.dom.generator.FileManager;
import org.jetbrains.idea.devkit.dom.generator.ModelDesc;
import org.jetbrains.idea.devkit.dom.generator.NamespaceDesc;
import org.jetbrains.idea.devkit.dom.generator.TypeDesc;
import org.jetbrains.idea.devkit.dom.generator.Util;

public class JetBrainsEmitter
implements Emitter {
    static final boolean NOT_COMPARE_MODE = true;
    static final boolean JB_OFF = false;
    static final boolean REPLACE_TYPES_WITH_INTERFACES = true;
    private String AUTHOR = null;
    private boolean myUseQualifiedClassNames = false;

    @Override
    public void emit(FileManager fileManager, ModelDesc model, File outputRoot) {
        NamespaceDesc nsdDef = model.nsdMap.get("");
        TreeSet<String> simpleTypes = new TreeSet<String>();
        for (TypeDesc td : model.jtMap.values()) {
            this.generateClass(fileManager, td, model, outputRoot, simpleTypes);
        }
        this.generateSuper(fileManager, nsdDef, model, outputRoot);
        this.generateHelper(fileManager, nsdDef, model, outputRoot);
        Util.log("SimpleTypes log:");
        for (String s : simpleTypes) {
            Util.log("  " + s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void generateClass(FileManager fileManager, TypeDesc td, ModelDesc model, File outDir, Set<String> simpleTypes) {
        Map<String, NamespaceDesc> nsdMap;
        Map<String, TypeDesc> jtMap = model.jtMap;
        NamespaceDesc nsd = nsdMap.get((nsdMap = model.nsdMap).containsKey(td.xsNamespace) ? td.xsNamespace : "");
        String typeName = td.name;
        String typeQName = model.getNSDPrefix(td) + typeName;
        String pkgName = typeQName.lastIndexOf(46) > -1 ? typeQName.substring(0, typeQName.lastIndexOf(46)) : "";
        String stringClass = this.getStringClassName();
        File outFile = fileManager.getOutputFile(new File(outDir, JetBrainsEmitter.toJavaFileName(typeQName)));
        PrintWriter out = null;
        try {
            void var19_46;
            int n;
            TreeSet<Object> externalClasses = new TreeSet<Object>();
            if (td.type != TypeDesc.TypeEnum.ENUM) {
                if (nsd.imports != null) {
                    TypeDesc[] st = new StringTokenizer(nsd.imports, ";");
                    while (st.hasMoreTokens()) {
                        externalClasses.add(st.nextToken());
                    }
                }
                if (!model.getNSDPrefix("", nsd.superClass, false).equals(model.getNSDPrefix(td))) {
                    externalClasses.add(model.getNSDPrefix("", nsd.superClass, false) + nsd.superClass.substring(nsd.superClass.lastIndexOf(".") + 1));
                }
                if (td.supers != null) {
                    for (TypeDesc typeDesc : td.supers) {
                        String pkg2;
                        String pkg1 = model.getNSDPrefix(typeDesc);
                        if (pkg1.equals(pkg2 = model.getNSDPrefix(td))) continue;
                        externalClasses.add(model.getNSDPrefix(typeDesc) + typeDesc.name);
                    }
                }
                for (FieldDesc fd : td.fdMap.values()) {
                    String pkgNameFD;
                    if (fd.simpleTypesString != null && fd.simpleTypesString.contains(":fully-qualified-classType;")) {
                        externalClasses.add("com.intellij.psi.PsiClass");
                    }
                    if (fd.contentQualifiedName != null && fd.contentQualifiedName.indexOf(46) > 0 && !(pkgNameFD = fd.contentQualifiedName.substring(0, fd.contentQualifiedName.lastIndexOf(46))).equals(pkgName)) {
                        externalClasses.add(fd.contentQualifiedName);
                    }
                    if (fd.clType < 0) {
                        externalClasses.add("java.util.List");
                    }
                    externalClasses.add("org.jetbrains.annotations.NotNull");
                    externalClasses.add("com.intellij.util.xml.*");
                }
            }
            Util.log("Generating type: " + typeName + "..");
            out = new PrintWriter(new FileWriter(outFile));
            out.println("// Generated on " + new Date());
            out.println("// DTD/Schema  :    " + nsd.name);
            out.println("");
            if (pkgName != null && pkgName.length() > 0) {
                out.println("package " + pkgName + ";");
            }
            out.println();
            if (td.type != TypeDesc.TypeEnum.ENUM) {
                boolean javaLang = false;
                boolean external = false;
                for (String string : externalClasses) {
                    if (string.startsWith("java.")) {
                        javaLang = true;
                        continue;
                    }
                    external = true;
                    out.println("import " + string + ";");
                }
                if (javaLang) {
                    if (external) {
                        out.println();
                    }
                    for (String string : externalClasses) {
                        if (!string.startsWith("java.")) continue;
                        out.println("import " + string + ";");
                    }
                }
                out.println();
            }
            if (td.type == TypeDesc.TypeEnum.ENUM) {
                boolean text2 = false;
                for (Map.Entry<String, FieldDesc> e : td.fdMap.entrySet()) {
                    if (e.getKey().equals(e.getValue().name)) continue;
                    text2 = true;
                    break;
                }
                out.println("/**");
                out.println(" * " + td.xsNamespace + ":" + td.xsName + " enumeration.");
                if (this.AUTHOR != null) {
                    out.println(" * " + this.AUTHOR);
                }
                JetBrainsEmitter.printDocumentation(out, td.documentation, " * ");
                out.println(" */");
                out.print("public enum " + typeName + (text2 ? " implements com.intellij.util.xml.NamedEnum" : ""));
                out.print(" {");
                boolean first = true;
                for (Map.Entry<String, FieldDesc> entry : td.fdMap.entrySet()) {
                    String val = entry.getKey();
                    FieldDesc id = entry.getValue();
                    if (first) {
                        first = false;
                        out.println("");
                    } else {
                        out.println(",");
                    }
                    if (text2) {
                        out.print("\t" + id.name + " (\"" + val + "\")");
                        continue;
                    }
                    out.print("\t" + id.name);
                }
                if (text2) {
                    out.println(";");
                    out.println();
                    out.println("\tprivate final " + stringClass + " value;");
                    out.println("\tprivate " + typeName + "(" + stringClass + " value) { this.value = value; }");
                    out.println("\tpublic " + stringClass + " getValue() { return value; }");
                }
                out.println();
                out.println("}");
                return;
            }
            out.println("/**");
            if (td.type == TypeDesc.TypeEnum.GROUP_INTERFACE) {
                out.println(" * " + td.xsNamespace + ":" + td.xsName + " model group interface.");
            } else {
                out.println(" * " + td.xsNamespace + ":" + td.xsName + " interface.");
            }
            JetBrainsEmitter.printDocumentation(out, td.documentation, " * ");
            if (this.AUTHOR != null) {
                out.println(" * " + this.AUTHOR);
            }
            out.println(" */");
            out.print("public interface " + typeName);
            if (nsd.superClass != null || td.supers != null && td.supers.length > 1) {
                boolean comma = false;
                if (td.type != TypeDesc.TypeEnum.GROUP_INTERFACE && nsd.superClass != null) {
                    out.print(" extends " + nsd.superClass.substring(nsd.superClass.lastIndexOf(".") + 1));
                    comma = true;
                }
                if (td.supers != null && td.supers.length > 0) {
                    void var19_44;
                    if (!comma) {
                        out.print(" extends ");
                    }
                    TypeDesc[] typeDescArray = td.supers;
                    n = typeDescArray.length;
                    boolean bl = false;
                    while (var19_44 < n) {
                        TypeDesc aSuper = typeDescArray[var19_44];
                        if (comma) {
                            out.print(", ");
                        } else {
                            comma = true;
                        }
                        out.print(aSuper.name);
                        ++var19_44;
                    }
                }
            }
            out.println(" {");
            FieldDesc[] fields2 = td.fdMap.values().toArray(new FieldDesc[0]);
            if (fields2.length == 0) {
                Util.logwarn("no fields in: " + td.xsName);
            }
            Arrays.sort(fields2, Comparator.comparingInt(o -> o.realIndex));
            out.println("");
            FieldDesc[] fieldDescArray = fields2;
            n = fieldDescArray.length;
            boolean bl = false;
            while (var19_46 < n) {
                boolean isList;
                FieldDesc field = fieldDescArray[var19_46];
                String tagName = field.tagName;
                Object type2 = this.myUseQualifiedClassNames ? pkgName + "." + field.type : field.type;
                Object elementType = this.myUseQualifiedClassNames ? pkgName + "." + field.elementType : field.elementType;
                String name = field.name;
                String paramName = JetBrainsEmitter.toJavaIdName(field.clType > 0 ? name : field.elementName);
                Object javaDocTagName = field.clType < 0 ? tagName + " children" : (tagName != null ? tagName + " child" : "simple content");
                boolean isAttr = field.clType == 4;
                boolean bl2 = isList = field.clType < 0;
                if (name.equals("class")) {
                    name = "clazz";
                }
                boolean nameChanged = field.tagName != null && !name.equals(isList ? Util.pluralize(Util.toJavaFieldName(field.tagName)) : Util.toJavaFieldName(field.tagName));
                Object newType = field.clType < 0 ? elementType : type2;
                String converterString = null;
                if (field.simpleTypesString != null) {
                    if (field.simpleTypesString.contains(":fully-qualified-classType;")) {
                        newType = "PsiClass";
                    } else if (!(field.simpleTypesString.contains(":ejb-linkType;") || field.simpleTypesString.contains(":ejb-ref-nameType;") || field.simpleTypesString.contains(":pathType;") || field.simpleTypesString.contains(":java-identifierType;") || field.simpleTypesString.contains(":QName;"))) {
                        if (field.simpleTypesString.contains(":integer;")) {
                            newType = "Integer";
                        } else if (field.simpleTypesString.contains(":int;")) {
                            newType = "Integer";
                        } else if (field.simpleTypesString.contains(":byte;")) {
                            newType = "Byte";
                        } else if (field.simpleTypesString.contains(":short;")) {
                            newType = "Short";
                        } else if (field.simpleTypesString.contains(":long;")) {
                            newType = "Long";
                        } else if (field.simpleTypesString.contains(":float;")) {
                            newType = "Float";
                        } else if (field.simpleTypesString.contains(":double;")) {
                            newType = "Double";
                        } else if (field.simpleTypesString.contains(":boolean;")) {
                            newType = "Boolean";
                        }
                    }
                    int idx = 0;
                    while (idx != -1) {
                        simpleTypes.add(field.simpleTypesString.substring(idx));
                        if ((idx = field.simpleTypesString.indexOf(59, idx) + 1) != 0) continue;
                    }
                }
                switch (Math.abs(field.clType)) {
                    case 4: {
                        newType = "GenericAttributeValue<" + (String)newType + ">";
                        break;
                    }
                    case 2: {
                        newType = "GenericDomValue<Boolean>";
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 1: {
                        newType = "GenericDomValue<" + (String)newType + ">";
                        break;
                    }
                    case 3: {
                        TypeDesc ftd = jtMap.get(field.contentQualifiedName);
                        if (ftd == null || ftd.type != TypeDesc.TypeEnum.ENUM) break;
                        newType = "GenericDomValue<" + ftd.name + ">";
                        break;
                    }
                }
                if (newType != null && isList) {
                    elementType = newType;
                } else if (newType != null) {
                    type2 = newType;
                }
                if (isList) {
                    type2 = "java.util.List<" + (String)elementType + ">";
                }
                StringBuffer sbAnnotations = new StringBuffer();
                if (field.clType != 6) {
                    if (isAttr && nameChanged) {
                        sbAnnotations.append("\t@Attribute (\"").append(tagName).append("\")");
                    } else if (isList) {
                        if (nameChanged) {
                            sbAnnotations.append("\t@SubTag (\"").append(tagName).append("\")");
                        } else if (JetBrainsEmitter.isBadTagName(tagName)) {
                            sbAnnotations.append("\t@SubTagList (\"").append(tagName).append("\")");
                        }
                    } else if (field.duplicateIndex >= 0) {
                        sbAnnotations.append("\t@SubTag (value = \"").append(tagName).append("\", index = ").append(field.duplicateIndex - 1).append(")");
                    } else if (field.clType == 2) {
                        sbAnnotations.append("\t@SubTag (value = \"").append(tagName).append("\", indicator = true)");
                    } else if (!name.equals(field.name)) {
                        sbAnnotations.append("\t@SubTag (\"").append(tagName).append("\")");
                    }
                }
                if (converterString != null) {
                    sbAnnotations.append("\n").append(converterString);
                }
                if (td.type != TypeDesc.TypeEnum.GROUP_INTERFACE) {
                    String text2;
                    out.println("\t/**");
                    if (isList) {
                        String text3 = "the list of " + (String)javaDocTagName;
                    } else {
                        text2 = "the value of the " + (String)javaDocTagName;
                    }
                    out.println("\t * Returns " + text2 + ".");
                    JetBrainsEmitter.printDocumentation(out, field.documentation, "\t * ");
                    out.println("\t * @return " + text2 + ".");
                    out.println("\t */");
                }
                out.println("\t@NotNull");
                if (td.type != TypeDesc.TypeEnum.GROUP_INTERFACE) {
                    if (sbAnnotations.length() > 0) {
                        out.println(sbAnnotations);
                    }
                    if (field.required) {
                        out.println("\t@Required");
                    }
                }
                out.print("\t");
                out.print((String)type2);
                out.print(" ");
                out.print("get");
                out.print(Util.capitalize(name));
                out.println("();");
                boolean genAddRemoveInsteadOfSet = true;
                if (field.clType > 0) {
                    if (field.clType == 6) {
                        if (td.type != TypeDesc.TypeEnum.GROUP_INTERFACE) {
                            out.println("\t/**");
                            if (field.clType < 0) {
                                out.println("\t * Sets the list of " + (String)javaDocTagName + ".");
                            } else {
                                out.println("\t * Sets the value of the " + (String)javaDocTagName + ".");
                            }
                            out.println("\t * @param " + paramName + " the new value to set");
                            out.println("\t */");
                            if (sbAnnotations.length() > 0) {
                                out.println(sbAnnotations);
                            }
                        }
                        out.print("\t");
                        out.print("void set");
                        out.print(Util.capitalize(name));
                        out.print("(");
                        if (field.required) {
                            out.print("@NotNull ");
                        }
                        out.print((String)type2);
                        out.print(" ");
                        out.print(paramName);
                        out.println(");");
                    }
                } else {
                    if (td.type != TypeDesc.TypeEnum.GROUP_INTERFACE) {
                        out.println("\t/**");
                        out.println("\t * Adds new child to the list of " + (String)javaDocTagName + ".");
                        out.println("\t * @return created child");
                        out.println("\t */");
                        if (sbAnnotations.length() > 0) {
                            out.println(sbAnnotations);
                        }
                    }
                    out.print("\t");
                    out.print((String)elementType + " add");
                    out.print(Util.capitalize(field.elementName));
                    out.println("();");
                }
                out.println("");
                out.println("");
                ++var19_46;
            }
            out.println("}");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
            fileManager.releaseOutputFile(outFile);
        }
    }

    private static boolean isBadTagName(String tagName) {
        if (Character.isUpperCase(tagName.charAt(0))) {
            return false;
        }
        char[] chars = tagName.toCharArray();
        for (int i = 1; i < chars.length; ++i) {
            if (!Character.isUpperCase(chars[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSuper(FileManager fileManager, NamespaceDesc nsd, ModelDesc model, File outDir) {
        if (nsd.superClass == null || nsd.superClass.length() == 0) {
            return;
        }
        String typeName = nsd.superClass.substring(nsd.superClass.lastIndexOf(".") + 1);
        String typeQName = model.toJavaQualifiedTypeName("", nsd.superClass, false);
        String pkgName = typeQName.substring(0, typeQName.lastIndexOf(46));
        File outFile = new File(outDir, JetBrainsEmitter.toJavaFileName(typeQName));
        outFile = fileManager.getOutputFile(outFile);
        PrintWriter out = null;
        try {
            Util.log("Generating type: " + typeName + "..");
            out = new PrintWriter(new FileWriter(outFile));
            out.println("// Generated on " + new Date());
            out.println("// DTD/Schema  :    " + nsd.name);
            out.println("");
            if (pkgName != null) {
                out.println("package " + pkgName + ";");
            }
            out.println("");
            out.println("");
            out.println("/**");
            out.println(" * " + nsd.name + " base interface.");
            if (this.AUTHOR != null) {
                out.println(" * " + this.AUTHOR);
            }
            out.println(" */");
            out.print("public interface " + typeName + " ");
            out.println("{");
            out.println("}");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            fileManager.releaseOutputFile(outFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateHelper(FileManager fileManager, NamespaceDesc nsd, ModelDesc model, File outDir) {
        Map<String, TypeDesc> jtMap = model.jtMap;
        Map<String, NamespaceDesc> nsdMap = model.nsdMap;
        if (nsd.helperClass == null || nsd.helperClass.length() == 0) {
            return;
        }
        ArrayList<TypeDesc> jtList = new ArrayList<TypeDesc>();
        for (TypeDesc td : jtMap.values()) {
            if (td.type != TypeDesc.TypeEnum.CLASS) continue;
            jtList.add(td);
        }
        if (jtList.size() == 0) {
            return;
        }
        String stringClass = this.getStringClassName();
        String typeName = nsd.helperClass.substring(nsd.helperClass.lastIndexOf(".") + 1);
        String typeQName = model.toJavaQualifiedTypeName("", nsd.helperClass, false);
        String pkgName = typeQName.substring(0, typeQName.lastIndexOf(46));
        File outFile = new File(outDir, JetBrainsEmitter.toJavaFileName(typeQName));
        outFile = fileManager.getOutputFile(outFile);
        PrintWriter out = null;
        try {
            Util.log("Generating type: " + typeName + "..");
            out = new PrintWriter(new FileWriter(outFile));
            out.println("// Generated on " + new Date());
            out.println("// DTD/Schema  :    " + nsd.name);
            out.println("");
            if (pkgName != null) {
                out.println("package " + pkgName + ";");
            }
            out.println("");
            out.println("");
            out.println("/**");
            out.println(" * " + nsd.name + " helper class.");
            if (this.AUTHOR != null) {
                out.println(" * " + this.AUTHOR);
            }
            out.println(" */");
            out.print("public class " + typeName + " ");
            out.println("{");
            out.println("");
            out.println("\tprivate interface GetName { " + stringClass + " getName(Object o); }");
            out.println("\tprivate static java.util.HashMap<Class, GetName> nameMap = new java.util.HashMap();");
            out.println("\tstatic {");
            for (TypeDesc td : jtList) {
                ArrayList<FieldDesc> fields2 = new ArrayList<FieldDesc>(td.fdMap.values());
                fields2.sort(Comparator.comparingInt(o -> o.realIndex));
                int guessPriority = 0;
                FieldDesc guessedField = null;
                for (FieldDesc fd : fields2) {
                    if (fd.clType == 1 || fd.clType == 6 || fd.clType == 4) {
                        if (fd.name.equals("name") && guessPriority < 10) {
                            guessPriority = 10;
                            guessedField = fd;
                            continue;
                        }
                        if (fd.name.endsWith("Name")) {
                            if ((fd.name.endsWith(Util.decapitalize(td.name + "Name")) || fd.realIndex < 2) && guessPriority < 10) {
                                guessPriority = 10;
                                guessedField = fd;
                                continue;
                            }
                            if (fd.name.endsWith(Util.decapitalize("DisplayName")) && guessPriority < 5) {
                                guessPriority = 5;
                                guessedField = fd;
                                continue;
                            }
                            if (guessPriority >= 3) continue;
                            guessPriority = 3;
                            guessedField = fd;
                            continue;
                        }
                        if (!fd.name.equals("value") || guessPriority >= 1) continue;
                        guessPriority = 1;
                        guessedField = fd;
                        continue;
                    }
                    if (fd.clType != -3 && fd.clType != -1 || !fd.name.endsWith("displayNames") || guessPriority >= 5) continue;
                    guessPriority = 5;
                    guessedField = fd;
                }
                out.println();
                String qname = model.getNSDPrefix(td) + td.name;
                String tdNameString = "\"" + JetBrainsEmitter.toPresentationName(td.name) + "\"";
                out.println("\t\tnameMap.put(" + qname + ".class, new GetName() {");
                out.println("\t\t\tpublic " + stringClass + " getName(Object o) {");
                if (guessedField != null) {
                    out.println("\t\t\t\t" + qname + " my = (" + qname + ") o;");
                    String getter = "my.get" + Util.capitalize(guessedField.name) + "()";
                    if (guessedField.clType > 0) {
                        out.println("\t\t\t\t" + stringClass + " s = o==null? null:" + getter + (guessedField.clType == 1 || guessedField.clType == 4 ? ".getValue();" : ";"));
                        out.println("\t\t\t\treturn s==null?" + tdNameString + ":s;");
                    } else {
                        out.println("\t\t\t\treturn (o!=null && " + getter + "!=null && " + getter + ".size()>0)?");
                        out.println("\t\t\t\t\tgetPresentationName(" + getter + ".get(0), null):" + tdNameString + ";");
                    }
                } else {
                    out.println("\t\t\t\treturn " + tdNameString + ";");
                }
                out.println("\t\t\t}");
                out.println("\t\t});");
            }
            out.println("\t}");
            out.println("\tpublic static " + stringClass + " getPresentationName(Object o, " + stringClass + " def) {");
            out.println("\t\tGetName g = o!=null? nameMap.get(o.getClass().getInterfaces()[0]):null;");
            out.println("\t\treturn g != null?g.getName(o):def;");
            out.println("\t}");
            out.println("}");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
            fileManager.releaseOutputFile(outFile);
        }
    }

    public static void printDocumentation(PrintWriter out, String str, String prefix) {
        if (str == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(str, "\n\r");
        while (st.hasMoreTokens()) {
            String line = prefix + st.nextToken();
            out.println(line);
        }
    }

    public static String toPresentationName(String typeName) {
        StringBuilder sb = new StringBuilder(typeName.length() + 10);
        boolean prevUp = true;
        for (int i = 0; i < typeName.length(); ++i) {
            char c = typeName.charAt(i);
            if (Character.isUpperCase(c) && !prevUp) {
                sb.append(' ');
            }
            sb.append(c);
            prevUp = Character.isUpperCase(c);
        }
        return sb.toString();
    }

    private static String toJavaFileName(String typeName) {
        return typeName.replace('.', File.separatorChar) + ".java";
    }

    private String getStringClassName() {
        return this.myUseQualifiedClassNames ? "java.lang.String" : StringUtil.getShortName((String)"java.lang.String");
    }

    public static String toJavaIdName(String javaFieldName) {
        if (Util.RESERVED_NAMES_MAP.containsKey(javaFieldName)) {
            javaFieldName = (String)javaFieldName + "_";
        }
        return javaFieldName;
    }

    public void setAuthor(String author) {
        this.AUTHOR = "@author " + author;
    }

    public void enableQualifiedClassNames() {
        this.myUseQualifiedClassNames = true;
    }
}

