/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

class RegistrationEntry {
    private final RegistrationType myRegistrationType;
    private final int myOffset;

    RegistrationEntry(RegistrationType registrationType, int offset) {
        this.myRegistrationType = registrationType;
        this.myOffset = offset;
    }

    RegistrationType getRegistrationType() {
        return this.myRegistrationType;
    }

    int getOffset() {
        return this.myOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistrationEntry entry = (RegistrationEntry)o;
        if (this.myOffset != entry.myOffset) {
            return false;
        }
        return this.myRegistrationType == entry.myRegistrationType;
    }

    public int hashCode() {
        int result = this.myRegistrationType.hashCode();
        result = 31 * result + this.myOffset;
        return result;
    }

    static enum RegistrationType {
        ACTION(true),
        APPLICATION_COMPONENT(true),
        PROJECT_COMPONENT(true),
        MODULE_COMPONENT(true),
        COMPONENT_INTERFACE(true),
        ACTION_ID(false),
        ACTION_GROUP_ID(false),
        APPLICATION_LISTENER(true),
        PROJECT_LISTENER(true),
        LISTENER_TOPIC(true);

        private final boolean myIsClass;

        private RegistrationType(boolean isClass) {
            this.myIsClass = isClass;
        }

        boolean isClass() {
            return this.myIsClass;
        }
    }
}

