/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomFileElement;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Dependency;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.index.IdeaPluginRegistrationIndex;
import org.jetbrains.idea.devkit.module.PluginModuleType;
import org.jetbrains.idea.devkit.util.ActionType;
import org.jetbrains.idea.devkit.util.ComponentType;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PsiUtil;

final class RegistrationCheckerUtil {
    RegistrationCheckerUtil() {
    }

    @Nullable
    static Set<PsiClass> getRegistrationTypes(@NotNull PsiClass psiClass, @NotNull RegistrationType registrationType) {
        if (psiClass == null) {
            RegistrationCheckerUtil.$$$reportNull$$$0(0);
        }
        if (registrationType == null) {
            RegistrationCheckerUtil.$$$reportNull$$$0(1);
        }
        Project project = psiClass.getProject();
        PsiFile psiFile = psiClass.getContainingFile();
        assert (psiFile != null);
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            return null;
        }
        RegistrationTypeFinder finder = new RegistrationTypeFinder(psiClass, registrationType);
        if (PsiUtil.isIdeaProject(project)) {
            return RegistrationCheckerUtil.checkIdeaProject(project, finder);
        }
        Set<PsiClass> pluginModuleResults = RegistrationCheckerUtil.checkModule(module, finder);
        if (pluginModuleResults != null) {
            return pluginModuleResults;
        }
        List<Module> candidateModules = PluginModuleType.getCandidateModules(module);
        candidateModules.remove(module);
        for (Module candidateModule : candidateModules) {
            Set<PsiClass> types = RegistrationCheckerUtil.checkModule(candidateModule, finder);
            if (types == null) continue;
            return types;
        }
        return null;
    }

    @Nullable
    private static Set<PsiClass> checkIdeaProject(Project project, RegistrationTypeFinder finder) {
        finder.processScope(GlobalSearchScopesCore.projectProductionScope((Project)project));
        return finder.getTypes();
    }

    @Nullable
    private static Set<PsiClass> checkModule(Module module, RegistrationTypeFinder finder) {
        DomFileElement<IdeaPlugin> pluginXml = RegistrationCheckerUtil.getPluginXmlFile(module);
        if (pluginXml == null) {
            return null;
        }
        XmlFile pluginXmlFile = pluginXml.getFile();
        if (!finder.processScope(GlobalSearchScope.fileScope((PsiFile)pluginXmlFile))) {
            return finder.getTypes();
        }
        HashSet<XmlFile> processedFiles = new HashSet<XmlFile>();
        processedFiles.add(pluginXmlFile);
        for (Dependency dependency : ((IdeaPlugin)pluginXml.getRootElement()).getDepends()) {
            XmlFile depPluginXml = dependency.getResolvedConfigFile();
            if (depPluginXml == null) continue;
            DomFileElement<IdeaPlugin> dependentIdeaPlugin = DescriptorUtil.getIdeaPluginFileElement(depPluginXml);
            if (dependentIdeaPlugin != null && !finder.processScope(GlobalSearchScope.fileScope((PsiFile)dependentIdeaPlugin.getFile()))) {
                return finder.getTypes();
            }
            processedFiles.add(depPluginXml);
        }
        Project project = module.getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        FileIncludeManager includeManager = FileIncludeManager.getManager((Project)project);
        HashSet<PsiFile> processedIncludedFiles = new HashSet<PsiFile>();
        for (PsiFile psiFile : processedFiles) {
            VirtualFile[] includes;
            for (VirtualFile includedFile : includes = includeManager.getIncludedFiles(psiFile.getVirtualFile(), true, true)) {
                PsiFile includedPsiFile = psiManager.findFile(includedFile);
                if (includedPsiFile == null || processedFiles.contains(includedPsiFile) || !processedIncludedFiles.add(includedPsiFile) || finder.processScope(GlobalSearchScope.fileScope((PsiFile)includedPsiFile))) continue;
                return finder.getTypes();
            }
        }
        return finder.getTypes();
    }

    @Nullable
    private static DomFileElement<IdeaPlugin> getPluginXmlFile(Module module) {
        XmlFile pluginXml = PluginModuleType.getPluginXml(module);
        if (pluginXml == null) {
            return null;
        }
        return DescriptorUtil.getIdeaPluginFileElement(pluginXml);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "registrationType";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/inspections/RegistrationCheckerUtil";
        objectArray[2] = "getRegistrationTypes";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class RegistrationTypeFinder {
        private final PsiClass myPsiClass;
        private final RegistrationType myRegistrationType;
        private final Set<PsiClass> myTypes = Collections.newSetFromMap(new IdentityHashMap());

        private RegistrationTypeFinder(PsiClass psiClass, RegistrationType registrationType) {
            this.myPsiClass = psiClass;
            this.myRegistrationType = registrationType;
        }

        private boolean processScope(GlobalSearchScope scope) {
            boolean allComponents;
            boolean findAll = this.myRegistrationType == RegistrationType.ALL;
            boolean bl = allComponents = findAll || this.myRegistrationType == RegistrationType.ALL_COMPONENTS;
            if ((allComponents || this.myRegistrationType == RegistrationType.APPLICATION_COMPONENT) && IdeaPluginRegistrationIndex.isRegisteredApplicationComponent(this.myPsiClass, scope)) {
                this.addType(ComponentType.APPLICATION.myClassName);
                return false;
            }
            if ((allComponents || this.myRegistrationType == RegistrationType.PROJECT_COMPONENT) && IdeaPluginRegistrationIndex.isRegisteredProjectComponent(this.myPsiClass, scope)) {
                this.addType(ComponentType.PROJECT.myClassName);
                return false;
            }
            if ((allComponents || this.myRegistrationType == RegistrationType.MODULE_COMPONENT) && IdeaPluginRegistrationIndex.isRegisteredModuleComponent(this.myPsiClass, scope)) {
                this.addType(ComponentType.MODULE.myClassName);
                return false;
            }
            if ((findAll || this.myRegistrationType == RegistrationType.ACTION) && IdeaPluginRegistrationIndex.isRegisteredActionOrGroup(this.myPsiClass, scope)) {
                this.addType(ActionType.ACTION.myClassName);
                return false;
            }
            return true;
        }

        private void addType(String fqn) {
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.myPsiClass.getProject()).findClass(fqn, this.myPsiClass.getResolveScope());
            ContainerUtil.addIfNotNull(this.myTypes, (Object)psiClass);
        }

        private Set<PsiClass> getTypes() {
            return this.myTypes.isEmpty() ? null : this.myTypes;
        }
    }

    static enum RegistrationType {
        ALL,
        ALL_COMPONENTS,
        APPLICATION_COMPONENT,
        PROJECT_COMPONENT,
        MODULE_COMPONENT,
        ACTION;

    }
}

