/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.idea.devkit.util.PluginRelatedLocatorsUtils;
import org.jetbrains.idea.devkit.util.PsiUtil;

public class PluginDescriptorXIncludeFileReferenceHelper
extends FileReferenceHelper {
    public boolean isMine(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            PluginDescriptorXIncludeFileReferenceHelper.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PluginDescriptorXIncludeFileReferenceHelper.$$$reportNull$$$0(1);
        }
        return !DumbService.isDumb((Project)project) && FileTypeRegistry.getInstance().isFileOfType(file, (FileType)XmlFileType.INSTANCE) && PsiUtil.isPluginProject(project) && DescriptorUtil.isPluginXml(PsiManager.getInstance((Project)project).findFile(file));
    }

    @NotNull
    public Collection<PsiFileSystemItem> getContexts(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            PluginDescriptorXIncludeFileReferenceHelper.$$$reportNull$$$0(2);
        }
        if (file == null) {
            PluginDescriptorXIncludeFileReferenceHelper.$$$reportNull$$$0(3);
        }
        Collection<PsiFileSystemItem> collection = PluginDescriptorXIncludeFileReferenceHelper.getRootsContainingPluginXmlFiles(project);
        if (collection == null) {
            PluginDescriptorXIncludeFileReferenceHelper.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module) {
        if (module == null) {
            PluginDescriptorXIncludeFileReferenceHelper.$$$reportNull$$$0(5);
        }
        Collection<PsiFileSystemItem> collection = PluginDescriptorXIncludeFileReferenceHelper.getRootsContainingPluginXmlFiles(module.getProject());
        if (collection == null) {
            PluginDescriptorXIncludeFileReferenceHelper.$$$reportNull$$$0(6);
        }
        return collection;
    }

    private static Collection<PsiFileSystemItem> getRootsContainingPluginXmlFiles(@NotNull Project project) {
        if (project == null) {
            PluginDescriptorXIncludeFileReferenceHelper.$$$reportNull$$$0(7);
        }
        return (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            Collection pluginXmlFilesInProductionScope = DomService.getInstance().getDomFileCandidates(IdeaPlugin.class, PluginRelatedLocatorsUtils.getCandidatesScope(project));
            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
            HashSet<VirtualFile> pluginXmlRoots = new HashSet<VirtualFile>();
            for (VirtualFile pluginXml : pluginXmlFilesInProductionScope) {
                VirtualFile sourceRoot = projectFileIndex.getSourceRootForFile(pluginXml);
                if (sourceRoot != null) {
                    pluginXmlRoots.add(sourceRoot);
                    continue;
                }
                VirtualFile classRoot = projectFileIndex.getClassRootForFile(pluginXml);
                ContainerUtil.addIfNotNull(pluginXmlRoots, (Object)classRoot);
            }
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            List rootsPsiFileSystemItems = pluginXmlRoots.stream().map(virtualFile -> psiManager.findDirectory(virtualFile)).filter(Objects::nonNull).collect(Collectors.toList());
            return CachedValueProvider.Result.create(rootsPsiFileSystemItems, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/references/PluginDescriptorXIncludeFileReferenceHelper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/references/PluginDescriptorXIncludeFileReferenceHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRootsContainingPluginXmlFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

