/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.ui.PlatformColors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class TestDataHighlightingPass
extends TextEditorHighlightingPass {
    private static final Key<Object> KEY = Key.create((String)"TestDataHighlighterKey");
    private static final Object VALUE = new Object();
    private static final GutterIconRenderer ICON_RENDERER = new MyGutterIconRenderer();
    private static final TextAttributes CARET_ATTRIBUTES = new TextAttributes(PlatformColors.BLUE, null, null, null, 1);
    private static final String CARET = "<caret>";

    protected TestDataHighlightingPass(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            TestDataHighlightingPass.$$$reportNull$$$0(0);
        }
        if (document == null) {
            TestDataHighlightingPass.$$$reportNull$$$0(1);
        }
        super(project, document);
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            TestDataHighlightingPass.$$$reportNull$$$0(2);
        }
    }

    public void doApplyInformationToEditor() {
        this.removeHighlighters();
        MarkupModel model = DocumentMarkupModel.forDocument((Document)this.myDocument, (Project)this.myProject, (boolean)true);
        String text2 = this.myDocument.getText();
        int ind = -1;
        while ((ind = text2.indexOf(CARET, ind + 1)) >= 0) {
            RangeHighlighter highlighter = model.addRangeHighlighter(ind, ind + CARET.length(), 3000, CARET_ATTRIBUTES, HighlighterTargetArea.EXACT_RANGE);
            highlighter.setGutterIconRenderer(ICON_RENDERER);
            highlighter.putUserData(KEY, VALUE);
        }
    }

    private void removeHighlighters() {
        MarkupModel model = DocumentMarkupModel.forDocument((Document)this.myDocument, (Project)this.myProject, (boolean)true);
        for (RangeHighlighter highlighter : model.getAllHighlighters()) {
            if (highlighter.getUserData(KEY) != VALUE) continue;
            highlighter.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataHighlightingPass";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doCollectInformation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyGutterIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        private MyGutterIconRenderer() {
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = AllIcons.RunConfigurations.Junit;
            if (icon == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(0);
            }
            return icon;
        }

        public boolean equals(Object obj) {
            return obj instanceof MyGutterIconRenderer;
        }

        public int hashCode() {
            return this.getIcon().hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/testAssistant/TestDataHighlightingPass$MyGutterIconRenderer", "getIcon"));
        }
    }
}

