/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.customizeActions.DissociateResourceBundleAction;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SuspiciousLocalesLanguagesInspection
extends LocalInspectionTool {
    private static final String ADDITIONAL_LANGUAGES_ATTR_NAME = "additionalLanguages";
    private static final Supplier<Set<String>> JAVA_LOCALES = NotNullLazyValue.softLazy(() -> {
        HashSet<String> result = new HashSet<String>();
        for (Locale locale : Locale.getAvailableLocales()) {
            result.add(locale.getLanguage());
        }
        return result;
    });
    private final List<String> myAdditionalLanguages = new ArrayList<String>();

    @TestOnly
    void setAdditionalLanguages(List<String> additionalLanguages) {
        this.myAdditionalLanguages.clear();
        this.myAdditionalLanguages.addAll(additionalLanguages);
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        String rawLanguages;
        if (node == null) {
            SuspiciousLocalesLanguagesInspection.$$$reportNull$$$0(0);
        }
        if ((rawLanguages = node.getAttributeValue(ADDITIONAL_LANGUAGES_ATTR_NAME)) != null) {
            this.myAdditionalLanguages.clear();
            this.myAdditionalLanguages.addAll(StringUtil.split((String)rawLanguages, (String)","));
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            SuspiciousLocalesLanguagesInspection.$$$reportNull$$$0(1);
        }
        if (!this.myAdditionalLanguages.isEmpty()) {
            ArrayList<String> uniqueLanguages = new ArrayList<String>(new HashSet<String>(this.myAdditionalLanguages));
            Collections.sort(uniqueLanguages);
            String locales = StringUtil.join(uniqueLanguages, (String)",");
            node.setAttribute(ADDITIONAL_LANGUAGES_ATTR_NAME, locales);
        }
    }

    @NotNull
    public JComponent createOptionsPanel() {
        JPanel jPanel = new MyOptions().getComponent();
        if (jPanel == null) {
            SuspiciousLocalesLanguagesInspection.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PropertiesFile propertiesFile;
        if (file == null) {
            SuspiciousLocalesLanguagesInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            SuspiciousLocalesLanguagesInspection.$$$reportNull$$$0(4);
        }
        if ((propertiesFile = PropertiesImplUtil.getPropertiesFile((PsiFile)file)) == null) {
            return null;
        }
        ResourceBundle resourceBundle = propertiesFile.getResourceBundle();
        List files = resourceBundle.getPropertiesFiles();
        if (!(resourceBundle instanceof ResourceBundleImpl) || files.size() < 2) {
            return null;
        }
        List bundleLocales = ContainerUtil.mapNotNull((Collection)files, propertiesFile1 -> {
            Locale locale = propertiesFile1.getLocale();
            return locale == PropertiesUtil.DEFAULT_LOCALE ? null : locale;
        });
        if ((bundleLocales = ContainerUtil.filter((Collection)bundleLocales, locale -> !JAVA_LOCALES.get().contains(locale.getLanguage()) && !this.myAdditionalLanguages.contains(locale.getLanguage()))).isEmpty()) {
            return null;
        }
        ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)file, JavaI18nBundle.message("resource.bundle.contains.locales.with.suspicious.locale.languages.desciptor", new Object[0]), (LocalQuickFix)new DissociateResourceBundleQuickFix(resourceBundle), ProblemHighlightType.WEAK_WARNING, true);
        return new ProblemDescriptor[]{descriptor};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/SuspiciousLocalesLanguagesInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/SuspiciousLocalesLanguagesInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyOptions {
        private final JBList<String> myAdditionalLocalesList;

        private MyOptions() {
            this.myAdditionalLocalesList = new JBList((ListModel)new CollectionListModel(SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages, true));
            this.myAdditionalLocalesList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer());
        }

        public JPanel getComponent() {
            final JPanel panel = new JPanel(new BorderLayout());
            panel.add(ToolbarDecorator.createDecorator(this.myAdditionalLocalesList).setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    Messages.showInputDialog((Component)panel, (String)JavaI18nBundle.message("dissociate.resource.bundle.quick.fix.options.input.text", new Object[0]), (String)JavaI18nBundle.message("dissociate.resource.bundle.quick.fix.options.input.title", new Object[0]), null, (String)"", (InputValidator)new InputValidator(){

                        public boolean checkInput(String inputString) {
                            return 1 < inputString.length() && inputString.length() < 9 && !SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages.contains(inputString);
                        }

                        public boolean canClose(String inputString) {
                            if (inputString != null) {
                                SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages.add(inputString);
                                ((CollectionListModel)MyOptions.this.myAdditionalLocalesList.getModel()).allContentsChanged();
                            }
                            return true;
                        }
                    });
                }
            }).setRemoveAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button) {
                    int index = MyOptions.this.myAdditionalLocalesList.getSelectedIndex();
                    if (index > -1 && index < SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages.size()) {
                        SuspiciousLocalesLanguagesInspection.this.myAdditionalLanguages.remove(index);
                        ((CollectionListModel)MyOptions.this.myAdditionalLocalesList.getModel()).allContentsChanged();
                    }
                }
            }).setPreferredSize(new Dimension(-1, 100)).disableUpDownActions().setToolbarPosition(ActionToolbarPosition.RIGHT).createPanel());
            return UI.PanelFactory.panel((JComponent)panel).withLabel(JavaI18nBundle.message("dissociate.resource.bundle.quick.fix.options.label", new Object[0])).moveLabelOnTop().resizeY(true).createPanel();
        }
    }

    private static final class DissociateResourceBundleQuickFix
    implements LocalQuickFix {
        private final ResourceBundle myResourceBundle;

        private DissociateResourceBundleQuickFix(ResourceBundle bundle) {
            this.myResourceBundle = bundle;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaI18nBundle.message("dissociate.resource.bundle.quick.fix.name", new Object[0]);
            if (string == null) {
                DissociateResourceBundleQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                DissociateResourceBundleQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                DissociateResourceBundleQuickFix.$$$reportNull$$$0(2);
            }
            DissociateResourceBundleAction.dissociate(Collections.singleton(this.myResourceBundle), (Project)project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/SuspiciousLocalesLanguagesInspection$DissociateResourceBundleQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/SuspiciousLocalesLanguagesInspection$DissociateResourceBundleQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

