/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.i18n.AbstractI18nizeQuickFix;
import com.intellij.codeInspection.i18n.I18nizeAction;
import com.intellij.codeInspection.i18n.JavaI18nizeQuickFixDialog;
import com.intellij.codeInspection.i18n.NlsInfo;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastElementFactory;

public class I18nizeQuickFix
extends AbstractI18nizeQuickFix<UInjectionHost> {
    private static final Logger LOG = Logger.getInstance(I18nizeQuickFix.class);
    private TextRange mySelectionRange;

    public I18nizeQuickFix(NlsInfo.Localized info) {
        super(info);
    }

    public I18nizeQuickFix() {
        this(NlsInfo.localized());
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaI18nBundle.message("inspection.i18n.quickfix", new Object[0]);
        if (string == null) {
            I18nizeQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void checkApplicability(PsiFile psiFile, Editor editor) throws IncorrectOperationException {
        UInjectionHost literalExpression = I18nizeAction.getEnclosingStringLiteral(psiFile, editor);
        if (literalExpression != null) {
            SelectionModel selectionModel = editor.getSelectionModel();
            if (!selectionModel.hasSelection()) {
                return;
            }
            int start = selectionModel.getSelectionStart();
            int end = selectionModel.getSelectionEnd();
            TextRange textRange = UastUtils.getTextRange((UElement)literalExpression);
            if (textRange != null && textRange.contains(start) && textRange.contains(end)) {
                this.mySelectionRange = new TextRange(start, end);
                return;
            }
        }
        String message = JavaI18nBundle.message("i18nize.error.message", new Object[0]);
        throw new IncorrectOperationException(message);
    }

    @Override
    public UInjectionHost getEnclosingLiteral(PsiFile file, Editor editor) {
        return I18nizeAction.getEnclosingStringLiteral(file, editor);
    }

    @Override
    public JavaI18nizeQuickFixDialog<UInjectionHost> createDialog(Project project, Editor editor, PsiFile psiFile) {
        UInjectionHost literalExpression = I18nizeAction.getEnclosingStringLiteral(psiFile, editor);
        return this.createDialog(project, psiFile, literalExpression);
    }

    @Override
    protected void doReplacement(@NotNull PsiFile psiFile, Editor editor, UInjectionHost literalExpression, String i18nizedText) throws IncorrectOperationException {
        if (psiFile == null) {
            I18nizeQuickFix.$$$reportNull$$$0(1);
        }
        UastCodeGenerationPlugin generationPlugin = UastCodeGenerationPlugin.byLanguage((Language)literalExpression.getLang());
        Document document = editor.getDocument();
        if (this.mySelectionRange != null && generationPlugin != null) {
            UastElementFactory elementFactory = generationPlugin.getElementFactory(psiFile.getProject());
            try {
                UBinaryExpression binaryExpression = I18nizeQuickFix.breakStringLiteral(literalExpression, generationPlugin, elementFactory, this.mySelectionRange.getEndOffset());
                if (binaryExpression != null) {
                    literalExpression = (UInjectionHost)binaryExpression.getLeftOperand();
                }
                if ((binaryExpression = I18nizeQuickFix.breakStringLiteral(literalExpression, generationPlugin, elementFactory, this.mySelectionRange.getStartOffset())) != null) {
                    literalExpression = (UInjectionHost)binaryExpression.getRightOperand();
                }
                PsiDocumentManager.getInstance((Project)psiFile.getProject()).doPostponedOperationsAndUnblockDocument(document);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        I18nizeQuickFix.doDocumentReplacement(psiFile, (UElement)literalExpression, i18nizedText, document, generationPlugin);
    }

    @Override
    protected JavaI18nizeQuickFixDialog<UInjectionHost> createDialog(Project project, PsiFile context, @NotNull UInjectionHost literalExpression) {
        if (literalExpression == null) {
            I18nizeQuickFix.$$$reportNull$$$0(2);
        }
        String value = this.getStringToExtract(literalExpression);
        return new JavaI18nizeQuickFixDialog<UInjectionHost>(project, context, literalExpression, value, this.getCustomization(value), true, true);
    }

    @NotNull
    @NlsSafe
    private String getStringToExtract(@NotNull UInjectionHost literalExpression) {
        if (literalExpression == null) {
            I18nizeQuickFix.$$$reportNull$$$0(3);
        }
        if (this.mySelectionRange != null) {
            TextRange literalRange = Objects.requireNonNull(literalExpression.getSourcePsi()).getTextRange();
            TextRange intersection = literalRange.intersection(this.mySelectionRange);
            String string = literalExpression.asSourceString().substring(intersection.getStartOffset() - literalRange.getStartOffset(), intersection.getEndOffset() - literalRange.getStartOffset());
            if (string == null) {
                I18nizeQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)literalExpression.evaluateToString());
        if (string == null) {
            I18nizeQuickFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        UInjectionHost literal;
        if (project == null) {
            I18nizeQuickFix.$$$reportNull$$$0(6);
        }
        if (descriptor == null) {
            I18nizeQuickFix.$$$reportNull$$$0(7);
        }
        if ((literal = I18nizeAction.getEnclosingStringLiteral(element = descriptor.getPsiElement())) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                I18nizeQuickFix.$$$reportNull$$$0(8);
            }
            return intentionPreviewInfo;
        }
        String string = this.getStringToExtract(literal);
        return new IntentionPreviewInfo.Html(new HtmlBuilder().append(JavaI18nBundle.message("i18n.quickfix.preview.description", new Object[0])).br().append((HtmlChunk)HtmlChunk.text((String)string).code()).toFragment());
    }

    @Nullable
    private static UBinaryExpression breakStringLiteral(@NotNull UInjectionHost literalExpression, UastCodeGenerationPlugin generationPlugin, UastElementFactory elementFactory, int offset) throws IncorrectOperationException {
        PsiElement sourcePsi;
        if (literalExpression == null) {
            I18nizeQuickFix.$$$reportNull$$$0(9);
        }
        if ((sourcePsi = literalExpression.getSourcePsi()) == null) {
            return null;
        }
        TextRange literalRange = sourcePsi.getTextRange();
        String value = literalExpression.evaluateToString();
        if (literalRange.getStartOffset() + 1 >= offset || offset >= literalRange.getEndOffset() - 1 || value == null) {
            return null;
        }
        int breakIndex = offset - literalRange.getStartOffset() - 1;
        String lsubstring = value.substring(0, breakIndex);
        String rsubstring = value.substring(breakIndex);
        ULiteralExpression left = elementFactory.createStringLiteralExpression(lsubstring, sourcePsi);
        ULiteralExpression right = elementFactory.createStringLiteralExpression(rsubstring, sourcePsi);
        if (left == null || right == null) {
            return null;
        }
        UBinaryExpression binaryExpression = elementFactory.createBinaryExpression((UExpression)left, (UExpression)right, (UastBinaryOperator)UastBinaryOperator.PLUS, sourcePsi);
        if (binaryExpression == null) {
            return null;
        }
        return (UBinaryExpression)generationPlugin.replace((UElement)literalExpression, (UElement)binaryExpression, UBinaryExpression.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/I18nizeQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/I18nizeQuickFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringToExtract";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doReplacement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStringToExtract";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "breakStringLiteral";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

