/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.textmate.TextMateBundle;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.bundles.Bundle;
import org.jetbrains.plugins.textmate.bundles.BundleFactory;
import org.jetbrains.plugins.textmate.configuration.BundleConfigBean;
import org.jetbrains.plugins.textmate.configuration.TextMateSettings;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistry;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.preferences.TextMateTextAttributes;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTable;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTextAttributesAdapter;
import org.jetbrains.plugins.textmate.language.syntax.lexer.SyntaxMatchUtils;
import org.jetbrains.plugins.textmate.plist.CompositePlistReader;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;

public final class TextMateServiceImpl
extends TextMateService {
    public static final String BUNDLED_BUNDLES_PATH = PluginPathManager.getPluginHome((String)"textmate") + "/lib/bundles";
    private boolean ourBuiltinBundlesDisabled;
    private volatile boolean myInitialized;
    private final Lock myRegistrationLock = new ReentrantLock();
    private final Map<CharSequence, TextMateTextAttributesAdapter> myCustomHighlightingColors = new HashMap<CharSequence, TextMateTextAttributesAdapter>();
    private Map<String, CharSequence> myExtensionsMapping = new HashMap<String, CharSequence>();
    private final PlistReader myPlistReader = new CompositePlistReader();
    private final BundleFactory myBundleFactory = new BundleFactory(this.myPlistReader);
    private final TextMateSyntaxTable mySyntaxTable = new TextMateSyntaxTable();
    private final SnippetsRegistry mySnippetsRegistry = new SnippetsRegistry();
    private final PreferencesRegistry myPreferencesRegistry = new PreferencesRegistry();
    private final ShellVariablesRegistry myShellVariablesRegistry = new ShellVariablesRegistry();
    private final Interner<CharSequence> myInterner = Interner.createWeakInterner();

    public TextMateServiceImpl() {
        Application application = ApplicationManager.getApplication();
        Runnable checkCancelled = application != null && !application.isUnitTestMode() ? ProgressManager::checkCanceled : null;
        SyntaxMatchUtils.setCheckCancelledCallback(checkCancelled);
    }

    @Override
    public void reloadEnabledBundles() {
        this.registerBundles(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerBundles(boolean fireEvents) {
        this.myRegistrationLock.lock();
        try {
            HashMap<String, CharSequence> oldExtensionsMapping = new HashMap<String, CharSequence>(this.myExtensionsMapping);
            this.unregisterAllBundles();
            TextMateSettings settings = TextMateSettings.getInstance();
            if (settings == null) {
                return;
            }
            if (!this.ourBuiltinBundlesDisabled) {
                TextMateServiceImpl.loadBuiltinBundles(settings);
            }
            HashMap<String, CharSequence> newExtensionsMapping = new HashMap<String, CharSequence>();
            for (BundleConfigBean bundleConfigBean : settings.getBundles()) {
                VirtualFile bundleFile;
                boolean result;
                if (!bundleConfigBean.isEnabled() || (result = this.registerBundle(bundleFile = LocalFileSystem.getInstance().findFileByPath(bundleConfigBean.getPath()), newExtensionsMapping)) || bundleFile == null && bundleConfigBean.getPath().startsWith(BUNDLED_BUNDLES_PATH)) continue;
                String bundleName = bundleConfigBean.getName();
                String errorMessage = bundleFile != null ? TextMateBundle.message("textmate.cant.register.bundle", bundleName) : TextMateBundle.message("textmate.cant.find.bundle", bundleName);
                new Notification("TextMate Bundles", TextMateBundle.message("textmate.bundle.load.error", bundleName), errorMessage, NotificationType.ERROR).addAction((AnAction)NotificationAction.createSimpleExpiring((String)TextMateBundle.message("textmate.disable.bundle.notification.action", bundleName), () -> bundleConfigBean.setEnabled(false))).notify(null);
            }
            if (!oldExtensionsMapping.equals(newExtensionsMapping)) {
                if (fireEvents) {
                    TextMateServiceImpl.fireFileTypesChangedEvent("old mappings = " + oldExtensionsMapping + ", new mappings" + newExtensionsMapping, () -> {
                        this.myExtensionsMapping = newExtensionsMapping;
                    });
                } else {
                    this.myExtensionsMapping = newExtensionsMapping;
                }
            }
            this.mySyntaxTable.compact();
        }
        finally {
            this.myRegistrationLock.unlock();
        }
    }

    private static void fireFileTypesChangedEvent(@NonNls @NotNull String reason, @NotNull Runnable update) {
        if (reason == null) {
            TextMateServiceImpl.$$$reportNull$$$0(0);
        }
        if (update == null) {
            TextMateServiceImpl.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            FileTypeManagerImpl fileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();
            fileTypeManager.makeFileTypesChange(reason, update);
        }), ModalityState.NON_MODAL);
    }

    private static void loadBuiltinBundles(TextMateSettings settings) {
        File bundles = new File(BUNDLED_BUNDLES_PATH);
        File[] files = bundles.listFiles();
        if (files == null) {
            LOG.warn("Builtin bundles not found at " + bundles);
            return;
        }
        TextMateSettings.TextMateSettingsState state = settings.getState();
        state = state == null ? new TextMateSettings.TextMateSettingsState() : state;
        List<BundleConfigBean> oldBundles = state.getBundles();
        ArrayList<BundleConfigBean> newBundles = new ArrayList<BundleConfigBean>(oldBundles);
        for (File file : files) {
            String path;
            BundleConfigBean existing;
            if (file.getName().startsWith(".") || (existing = (BundleConfigBean)ContainerUtil.find(oldBundles, arg_0 -> TextMateServiceImpl.lambda$loadBuiltinBundles$4(path = FileUtil.toSystemIndependentName((String)file.getPath()), arg_0))) != null) continue;
            newBundles.add(new BundleConfigBean(file.getName(), path, true));
        }
        state.setBundles(newBundles);
        settings.loadState(state);
    }

    private void unregisterAllBundles() {
        this.myExtensionsMapping.clear();
        this.myPreferencesRegistry.clear();
        this.myCustomHighlightingColors.clear();
        this.mySyntaxTable.clear();
        this.mySnippetsRegistry.clear();
        this.myShellVariablesRegistry.clear();
    }

    @Override
    @NotNull
    public Map<CharSequence, TextMateTextAttributesAdapter> getCustomHighlightingColors() {
        this.ensureInitialized();
        Map<CharSequence, TextMateTextAttributesAdapter> map = this.myCustomHighlightingColors;
        if (map == null) {
            TextMateServiceImpl.$$$reportNull$$$0(2);
        }
        return map;
    }

    @Override
    @Nullable
    public TextMateShellVariable getVariable(@NotNull String name, @NotNull EditorEx editor) {
        if (name == null) {
            TextMateServiceImpl.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            TextMateServiceImpl.$$$reportNull$$$0(4);
        }
        this.ensureInitialized();
        return this.myShellVariablesRegistry.getVariableValue(name, TextMateEditorUtils.getCurrentScopeSelector(editor));
    }

    @Override
    @NotNull
    public SnippetsRegistry getSnippetsRegistry() {
        this.ensureInitialized();
        SnippetsRegistry snippetsRegistry = this.mySnippetsRegistry;
        if (snippetsRegistry == null) {
            TextMateServiceImpl.$$$reportNull$$$0(5);
        }
        return snippetsRegistry;
    }

    @Override
    @NotNull
    public PreferencesRegistry getPreferencesRegistry() {
        this.ensureInitialized();
        PreferencesRegistry preferencesRegistry = this.myPreferencesRegistry;
        if (preferencesRegistry == null) {
            TextMateServiceImpl.$$$reportNull$$$0(6);
        }
        return preferencesRegistry;
    }

    @Override
    @Nullable
    public TextMateLanguageDescriptor getLanguageDescriptorByFileName(@NotNull CharSequence fileName) {
        if (fileName == null) {
            TextMateServiceImpl.$$$reportNull$$$0(7);
        }
        if (Strings.isEmpty((CharSequence)fileName)) {
            return null;
        }
        this.ensureInitialized();
        Ref result = new Ref();
        TextMateEditorUtils.processExtensions(fileName, (Processor<? super CharSequence>)((Processor)extension -> {
            result.set((Object)this.getLanguageDescriptorByExtension((CharSequence)extension));
            return result.isNull();
        }));
        return (TextMateLanguageDescriptor)result.get();
    }

    @Override
    @Nullable
    public TextMateLanguageDescriptor getLanguageDescriptorByExtension(@Nullable CharSequence extension) {
        if (Strings.isEmpty((CharSequence)extension)) {
            return null;
        }
        this.ensureInitialized();
        CharSequence scopeName = this.myExtensionsMapping.get(Strings.toLowerCase((String)extension.toString()));
        return !Strings.isEmpty((CharSequence)scopeName) ? new TextMateLanguageDescriptor(scopeName, this.mySyntaxTable.getSyntax(scopeName)) : null;
    }

    @Override
    @Nullable
    public Bundle createBundle(@Nullable VirtualFile directory) {
        String path;
        if (directory != null && directory.isInLocalFileSystem() && (path = directory.getCanonicalPath()) != null) {
            try {
                return this.myBundleFactory.fromDirectory(new File(path));
            }
            catch (IOException e) {
                LOG.debug("Couldn't load bundle from " + path, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private void ensureInitialized() {
        if (!this.myInitialized) {
            this.myRegistrationLock.lock();
            try {
                if (this.myInitialized) {
                    return;
                }
                this.registerBundles(false);
                this.myInitialized = true;
            }
            finally {
                this.myRegistrationLock.unlock();
            }
        }
    }

    private boolean registerBundle(@Nullable VirtualFile directory, @NotNull Map<String, CharSequence> extensionsMapping) {
        Bundle bundle;
        if (extensionsMapping == null) {
            TextMateServiceImpl.$$$reportNull$$$0(8);
        }
        if ((bundle = this.createBundle(directory)) != null) {
            this.registerLanguageSupport(bundle, extensionsMapping);
            this.registerPreferences(bundle);
            this.registerSnippets(bundle);
            return true;
        }
        return false;
    }

    private void registerSnippets(@NotNull Bundle bundle) {
        if (bundle == null) {
            TextMateServiceImpl.$$$reportNull$$$0(9);
        }
        for (File snippetFile : bundle.getSnippetFiles()) {
            try {
                TextMateSnippet snippet = PreferencesReadUtil.loadSnippet(snippetFile, this.myPlistReader.read(snippetFile), this.myInterner);
                if (snippet == null) continue;
                this.mySnippetsRegistry.register(snippet);
            }
            catch (IOException e) {
                LOG.debug("Can't load textmate preferences file: " + snippetFile.getPath());
            }
        }
    }

    private void registerPreferences(@NotNull Bundle bundle) {
        if (bundle == null) {
            TextMateServiceImpl.$$$reportNull$$$0(10);
        }
        for (File preferenceFile : bundle.getPreferenceFiles()) {
            try {
                for (Map.Entry<String, Plist> settingsPair : bundle.loadPreferenceFile(preferenceFile, this.myPlistReader)) {
                    if (settingsPair == null) continue;
                    CharSequence scopeName = (CharSequence)this.myInterner.intern((Object)settingsPair.getKey());
                    this.myPreferencesRegistry.fillFromPList(scopeName, settingsPair.getValue());
                    this.myShellVariablesRegistry.fillVariablesFromPlist(scopeName, settingsPair.getValue());
                    this.readCustomHighlightingColors(scopeName, settingsPair.getValue());
                }
            }
            catch (IOException e) {
                LOG.debug("Can't load textmate preferences file: " + preferenceFile.getPath());
            }
        }
    }

    private void readCustomHighlightingColors(@NotNull CharSequence scopeName, @NotNull Plist preferencesPList) {
        TextMateTextAttributes textAttributes;
        if (scopeName == null) {
            TextMateServiceImpl.$$$reportNull$$$0(11);
        }
        if (preferencesPList == null) {
            TextMateServiceImpl.$$$reportNull$$$0(12);
        }
        if ((textAttributes = TextMateTextAttributes.fromPlist(preferencesPList)) != null) {
            this.myCustomHighlightingColors.put(scopeName, new TextMateTextAttributesAdapter(scopeName, textAttributes));
        }
    }

    private void registerLanguageSupport(@NotNull Bundle bundle, @NotNull Map<String, CharSequence> extensionsMapping) {
        if (bundle == null) {
            TextMateServiceImpl.$$$reportNull$$$0(13);
        }
        if (extensionsMapping == null) {
            TextMateServiceImpl.$$$reportNull$$$0(14);
        }
        for (File grammarFile : bundle.getGrammarFiles()) {
            try {
                Plist plist = this.myPlistReader.read(grammarFile);
                CharSequence rootScopeName = this.mySyntaxTable.loadSyntax(plist, this.myInterner);
                Collection<String> extensions = bundle.getExtensions(grammarFile, plist);
                for (String extension : extensions) {
                    extensionsMapping.put(Strings.toLowerCase((String)extension), rootScopeName);
                }
            }
            catch (IOException e) {
                LOG.warn("Can't load textmate language file: " + grammarFile.getPath());
            }
        }
    }

    @TestOnly
    public void disableBuiltinBundles(Disposable disposable) {
        this.ourBuiltinBundlesDisabled = true;
        TextMateService.getInstance().reloadEnabledBundles();
        this.myInitialized = true;
        Disposer.register((Disposable)disposable, () -> {
            this.ourBuiltinBundlesDisabled = false;
            this.unregisterAllBundles();
            this.myInitialized = false;
        });
    }

    private static /* synthetic */ boolean lambda$loadBuiltinBundles$4(String path, BundleConfigBean bundle) {
        return bundle.getPath().equals(path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/TextMateServiceImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionsMapping";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundle";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferencesPList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/TextMateServiceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomHighlightingColors";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSnippetsRegistry";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferencesRegistry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fireFileTypesChangedEvent";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVariable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageDescriptorByFileName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "registerBundle";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerSnippets";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerPreferences";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readCustomHighlightingColors";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerLanguageSupport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

