/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.impl.CancellableRunnable;
import com.intellij.util.ThrowableConsumer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class StreamGobbler
implements CancellableRunnable {
    private static final Logger LOG = Logger.getInstance(StreamGobbler.class);
    private static final int IN_MEMORY_RESULT_THRESHOULD = 49152;
    private OutputStream myByteContents;
    private final ByteArrayOutputStream myInMemoryContents;
    private final InputStream is;
    private File myTempFile = null;
    private int myOutputLength = 0;
    private boolean myResultUsedOnce;
    private volatile boolean myMasterExited;

    public StreamGobbler(InputStream is) {
        this.is = is;
        this.myInMemoryContents = new ByteArrayOutputStream();
        this.myByteContents = this.myInMemoryContents;
        this.myResultUsedOnce = true;
    }

    public void run() {
        byte[] buffer = new byte[8192];
        try {
            int read;
            while ((read = this.is.read(buffer, 0, buffer.length)) != -1) {
                this.myByteContents.write(buffer, 0, read);
                this.myOutputLength += read;
                if (this.myTempFile != null || this.myOutputLength <= 49152) continue;
                this.switchToTemporaryFileContent();
            }
        }
        catch (IOException ioe) {
            if (this.myMasterExited) {
            } else {
                LOG.error(this.myInMemoryContents.toString(), (Throwable)ioe);
            }
        }
        finally {
            try {
                this.myByteContents.close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean switchToTemporaryFileContent() {
        try {
            this.myTempFile = FileUtil.createTempFile((String)"idea_p4", (String)"command.output");
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.myTempFile = null;
            return false;
        }
        try {
            this.myByteContents = new BufferedOutputStream(new FileOutputStream(this.myTempFile));
            this.myInMemoryContents.writeTo(this.myByteContents);
            return true;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            if (this.myByteContents != null) {
                try {
                    this.myByteContents.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            FileUtil.delete((File)this.myTempFile);
            this.myTempFile = null;
            return false;
        }
    }

    public int getResultLength() {
        return this.myOutputLength;
    }

    public String toString() {
        return this.myInMemoryContents.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allowSafeStreamUsage(ThrowableConsumer<InputStream, IOException> consumer) throws IOException {
        if (!this.myResultUsedOnce) {
            LOG.warn("Result taken from StreamGobbler more than once. An error, since the result might have been backed by a temp file which is already deleted.", new Throwable());
        }
        this.myResultUsedOnce = false;
        InputStream is = this.myTempFile != null ? new BufferedInputStream(new FileInputStream(this.myTempFile)) : new ByteArrayInputStream(this.myInMemoryContents.toByteArray());
        try {
            consumer.consume((Object)is);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
            if (this.myTempFile != null) {
                FileUtil.delete((File)this.myTempFile);
                this.myTempFile = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.myTempFile != null) {
            LOG.warn("Stream Gobbler's temp file hadn't been deleted: " + this.myTempFile.getAbsolutePath());
        }
    }

    public void deleteTempFile() {
        if (this.myTempFile != null) {
            FileUtil.delete((File)this.myTempFile);
            this.myTempFile = null;
        }
    }

    public void cancel() {
        this.myMasterExited = true;
    }
}

