/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsVFSListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LastUnchangedContentTracker;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.FileGrouper;
import org.jetbrains.idea.perforce.application.PerforceChangeProvider;
import org.jetbrains.idea.perforce.application.PerforceOfflineRollbackEnvironment;
import org.jetbrains.idea.perforce.application.PerforceUnversionedTracker;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.operations.P4AddOperation;
import org.jetbrains.idea.perforce.operations.P4CopyOperation;
import org.jetbrains.idea.perforce.operations.P4EditOperation;
import org.jetbrains.idea.perforce.operations.P4MoveRenameOperation;
import org.jetbrains.idea.perforce.operations.VcsOperation;
import org.jetbrains.idea.perforce.operations.VcsOperationLog;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceCachingContentRevision;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;

public final class PerforceVFSListener
extends VcsVFSListener {
    private static final Logger LOG = Logger.getInstance(PerforceVFSListener.class);

    private PerforceVFSListener(@NotNull Project project) {
        if (project == null) {
            PerforceVFSListener.$$$reportNull$$$0(0);
        }
        super((AbstractVcs)PerforceVcs.getInstance(project));
    }

    @NotNull
    public static PerforceVFSListener createInstance(@NotNull Project project) {
        if (project == null) {
            PerforceVFSListener.$$$reportNull$$$0(1);
        }
        PerforceVFSListener listener = new PerforceVFSListener(project);
        listener.installListeners();
        PerforceVFSListener perforceVFSListener = listener;
        if (perforceVFSListener == null) {
            PerforceVFSListener.$$$reportNull$$$0(2);
        }
        return perforceVFSListener;
    }

    protected void installListeners() {
        super.installListeners();
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file;
                    FilePath filePath;
                    if (!(vFileEvent instanceof VFileCreateEvent) || !(vFileEvent.getFileSystem() instanceof LocalFileSystem) || !PerforceVFSListener.this.isUnderMyVcs(filePath = VcsUtil.getFilePath((String)vFileEvent.getPath())) || (file = vFileEvent.getFile()) == null) continue;
                    LastUnchangedContentTracker.markTouched((VirtualFile)file);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/jetbrains/idea/perforce/application/PerforceVFSListener$1", "after"));
            }
        });
    }

    protected boolean filterOutUnknownFiles() {
        return false;
    }

    protected boolean isEventAccepted(@NotNull VFileEvent event) {
        if (event == null) {
            PerforceVFSListener.$$$reportNull$$$0(3);
        }
        return !(event.getRequestor() instanceof PerforceOfflineRollbackEnvironment) && super.isEventAccepted(event);
    }

    protected void executeAdd(@NotNull List<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copiedFiles) {
        if (addedFiles == null) {
            PerforceVFSListener.$$$reportNull$$$0(4);
        }
        if (copiedFiles == null) {
            PerforceVFSListener.$$$reportNull$$$0(5);
        }
        this.executeAddWithoutIgnores(addedFiles, copiedFiles, (notIgnoredAddedFiles, copiedFilesMap) -> super.executeAdd(notIgnoredAddedFiles, copiedFilesMap));
    }

    protected void executeAddWithoutIgnores(final @NotNull List<VirtualFile> addedFiles, final @NotNull Map<VirtualFile, VirtualFile> copiedFiles, final @NotNull VcsVFSListener.ExecuteAddCallback executeAddCallback) {
        if (addedFiles == null) {
            PerforceVFSListener.$$$reportNull$$$0(6);
        }
        if (copiedFiles == null) {
            PerforceVFSListener.$$$reportNull$$$0(7);
        }
        if (executeAddCallback == null) {
            PerforceVFSListener.$$$reportNull$$$0(8);
        }
        this.saveUnsavedVcsIgnoreFiles();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            super.executeAdd(addedFiles, copiedFiles);
            return;
        }
        if (!PerforceSettings.getSettings((Project)this.myProject).ENABLED) {
            AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> super.executeAdd(addedFiles, copiedFiles));
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, PerforceBundle.message("progress.title.checking.for.ignored.files", new Object[0]), false){

            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    2.$$$reportNull$$$0(0);
                }
                MultiMap<P4Connection, VirtualFile> map = FileGrouper.distributeFilesByConnection(addedFiles, this.myProject);
                for (P4Connection connection : map.keySet()) {
                    try {
                        addedFiles.removeAll(PerforceUnversionedTracker.getFilesOutsideClientSpec(this.myProject, connection, map.get((Object)connection)));
                    }
                    catch (VcsException e) {
                        AbstractVcsHelper.getInstance((Project)this.myProject).showError(e, PerforceBundle.message("perforce.error", new Object[0]));
                    }
                }
                AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> executeAddCallback.executeAdd(addedFiles, copiedFiles));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "org/jetbrains/idea/perforce/application/PerforceVFSListener$2", "run"));
            }
        });
    }

    protected void performAdding(@NotNull Collection<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copyFromMap) {
        if (addedFiles == null) {
            PerforceVFSListener.$$$reportNull$$$0(9);
        }
        if (copyFromMap == null) {
            PerforceVFSListener.$$$reportNull$$$0(10);
        }
        String title = PerforceBundle.message("progress.title.running.perforce.commands", new Object[0]);
        List<VcsOperation> operations = this.createOperations(addedFiles, copyFromMap);
        VcsOperationLog.getInstance(this.myProject).queueOperations(operations, title, PerformInBackgroundOption.ALWAYS_BACKGROUND);
    }

    private List<VcsOperation> createOperations(Collection<VirtualFile> addedFiles, Map<VirtualFile, VirtualFile> copyFromMap) {
        String chList = this.myChangeListManager.getDefaultChangeList().getName();
        ArrayList<VcsOperation> operations = new ArrayList<VcsOperation>();
        Processor fileProcessor = file -> {
            if (!file.isDirectory()) {
                VirtualFile copyFrom = (VirtualFile)copyFromMap.get(file);
                operations.add(copyFrom != null ? new P4CopyOperation(chList, (VirtualFile)file, copyFrom) : new P4AddOperation(chList, (VirtualFile)file));
            }
            return true;
        };
        for (VirtualFile file2 : addedFiles) {
            VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)file2, (Processor)fileProcessor);
        }
        return operations;
    }

    @NotNull
    protected String getSingleFileAddPromptTemplate() {
        String string = PerforceBundle.message("confirmation.text.add.files", new Object[0]);
        if (string == null) {
            PerforceVFSListener.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    protected String getSingleFileAddTitle() {
        String string = PerforceBundle.message("confirmation.title.add.files", new Object[0]);
        if (string == null) {
            PerforceVFSListener.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    protected String getAddTitle() {
        String string = PerforceBundle.message("add.select.files", new Object[0]);
        if (string == null) {
            PerforceVFSListener.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    protected VcsVFSListener.VcsDeleteType needConfirmDeletion(@NotNull VirtualFile file) {
        if (file == null) {
            PerforceVFSListener.$$$reportNull$$$0(14);
        }
        VcsVFSListener.VcsDeleteType vcsDeleteType = ChangeListManager.getInstance((Project)this.myProject).isUnversioned(file) ? VcsVFSListener.VcsDeleteType.IGNORE : VcsVFSListener.VcsDeleteType.CONFIRM;
        if (vcsDeleteType == null) {
            PerforceVFSListener.$$$reportNull$$$0(15);
        }
        return vcsDeleteType;
    }

    protected void performDeletion(@NotNull List<FilePath> filesToDelete) {
        if (filesToDelete == null) {
            PerforceVFSListener.$$$reportNull$$$0(16);
        }
        PerforceVcs.getInstance(this.myProject).getCheckinEnvironment().scheduleMissingFileForDeletion(filesToDelete);
    }

    protected String getSingleFileDeletePromptTemplate() {
        return PerforceBundle.message("confirmation.text.remove.files", new Object[0]);
    }

    protected String getSingleFileDeleteTitle() {
        return PerforceBundle.message("confirmation.title.remove.files", new Object[0]);
    }

    @NotNull
    protected String getDeleteTitle() {
        String string = PerforceBundle.message("delete.select.files", new Object[0]);
        if (string == null) {
            PerforceVFSListener.$$$reportNull$$$0(17);
        }
        return string;
    }

    protected void processMovedFile(@NotNull VirtualFile file, @NotNull String newParentPath, @NotNull String newName) {
        if (file == null) {
            PerforceVFSListener.$$$reportNull$$$0(18);
        }
        if (newParentPath == null) {
            PerforceVFSListener.$$$reportNull$$$0(19);
        }
        if (newName == null) {
            PerforceVFSListener.$$$reportNull$$$0(20);
        }
        LOG.debug("processMovedFile " + file + " newParentPath=" + newParentPath + " newName=" + newName);
        PerforceVFSListener.updateLastUnchangedContent(file, this.myChangeListManager);
        PerforceCachingContentRevision.removeCachedContent(file);
        P4File.invalidateFstat(file);
        super.processMovedFile(file, newParentPath, newName);
    }

    protected void performMoveRename(@NotNull List<VcsVFSListener.MovedFileInfo> movedFiles) {
        if (movedFiles == null) {
            PerforceVFSListener.$$$reportNull$$$0(21);
        }
        ArrayList<P4MoveRenameOperation> operations = new ArrayList<P4MoveRenameOperation>();
        for (VcsVFSListener.MovedFileInfo movedFile : movedFiles) {
            operations.add(new P4MoveRenameOperation(ChangeListManager.getInstance((Project)this.myProject).getDefaultChangeList().getName(), movedFile.myOldPath, movedFile.myNewPath));
        }
        VcsOperationLog.getInstance(this.myProject).queueOperations(operations, PerforceBundle.message("progress.title.running.perforce.commands", new Object[0]), PerformInBackgroundOption.ALWAYS_BACKGROUND);
    }

    protected boolean isDirectoryVersioningSupported() {
        return false;
    }

    protected void beforeContentsChange(@NotNull VFileContentChangeEvent event) {
        P4Connection connection;
        if (event == null) {
            PerforceVFSListener.$$$reportNull$$$0(22);
        }
        VirtualFile file = event.getFile();
        PerforceVFSListener.updateLastUnchangedContent(file, this.myChangeListManager);
        if (!event.isFromRefresh() && this.myChangeListManager.getStatus(file) == FileStatus.NOT_CHANGED && (connection = PerforceConnectionManager.getInstance(this.myProject).getConnectionForFile(file)) != null && PerforceChangeProvider.isAllWriteWorkspace(connection, this.myProject)) {
            this.asyncEdit(file);
        }
    }

    private void asyncEdit(VirtualFile file) {
        PerforceVcs vcs = PerforceVcs.getInstance(this.myProject);
        if (vcs.getAsyncEditedFiles().contains(file)) {
            return;
        }
        vcs.startAsyncEdit(file);
        P4EditOperation op = new P4EditOperation(this.myChangeListManager.getDefaultListName(), file);
        op.setSuppressErrors(true);
        VcsOperationLog.getInstance(this.myProject).queueOperations(Collections.singletonList(op), PerforceBundle.message("progress.title.running.perforce.commands", new Object[0]), PerformInBackgroundOption.ALWAYS_BACKGROUND);
    }

    public static void updateLastUnchangedContent(VirtualFile file, ChangeListManager changeListManager) {
        FileStatus status = changeListManager.getStatus(file);
        if (status == FileStatus.NOT_CHANGED) {
            LastUnchangedContentTracker.updateLastUnchangedContent((VirtualFile)file);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/PerforceVFSListener";
                break;
            }
            case 3: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedFiles";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copiedFiles";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executeAddCallback";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFromMap";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToDelete";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParentPath";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceVFSListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleFileAddPromptTemplate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleFileAddTitle";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddTitle";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "needConfirmDeletion";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeleteTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEventAccepted";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executeAdd";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "executeAddWithoutIgnores";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performAdding";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "needConfirmDeletion";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "performDeletion";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processMovedFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "performMoveRename";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "beforeContentsChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

