/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.DynamicBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ClientRootsCache;
import org.jetbrains.idea.perforce.application.ConnectionDiagnoseRefresher;
import org.jetbrains.idea.perforce.application.ConnectionInfo;
import org.jetbrains.idea.perforce.application.P4ConfigConnectionDiagnoseDialog;
import org.jetbrains.idea.perforce.application.P4RootsInformation;
import org.jetbrains.idea.perforce.application.PerforceClientRootsChecker;
import org.jetbrains.idea.perforce.application.PerforceInfoAndClient;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4ConfigHelper;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionCalculator;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionParameters;
import org.jetbrains.idea.perforce.perforce.connections.P4ParametersConnection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionProblemsNotifier;
import org.jetbrains.idea.perforce.perforce.connections.PerforceMultipleConnections;
import org.jetbrains.idea.perforce.perforce.connections.SingletonConnection;
import org.jetbrains.idea.perforce.perforce.login.LoginPerformerImpl;
import org.jetbrains.idea.perforce.perforce.login.LoginState;
import org.jetbrains.idea.perforce.perforce.login.LoginSupport;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

public class ConfigPanel {
    private JTextField m_port;
    private JTextField m_client;
    private JTextField m_user;
    private JCheckBox m_showCmds;
    private TextFieldWithBrowseButton m_pathToExec;
    private JPanel myPanel;
    private HyperlinkLabel myOutputFileLabel;
    private JComboBox myCharset;
    private JButton myTestConnectionButton;
    private final Project myProject;
    private JCheckBox myShowBranchingHistory;
    private JCheckBox myIsEnabled;
    private JCheckBox myUseLogin;
    private JTextField myServerTimeoutField;
    private TextFieldWithBrowseButton myP4VCPathField;
    private JCheckBox myUsePerforceJobs;
    private JCheckBox myShowIntegratedChangelistsInCheckBox;
    private JRadioButton myUseP4CONFIGOrDefaultRadioButton;
    private JRadioButton myUseConnectionParametersRadioButton;
    private JLabel myPOrtLabel;
    private JLabel myUserLabel;
    private JLabel myClientLabel;
    private JLabel myCharsetLabel;
    private JCheckBox mySwitchToOffline;
    private JPanel myConfigSettingsPanel;
    private JBLabel myP4ConfigWarningLabel;
    private JRadioButton myUseP4IGNOREOrDefaultRadioButton;
    private JBLabel myP4IgnoreWarningLabel;
    private JPanel myIgnoreSettingsPanel;
    private JLabel myIgnoreLabel;
    private JRadioButton myUseIgnoreSettingsRadioButton;
    private TextFieldWithBrowseButton m_pathToIgnore;
    @NlsSafe
    private static final String CHARSET_ISO8859_1 = "iso8859-1";
    @NlsSafe
    private static final String CHARSET_ISO8859_15 = "iso8859-15";
    @NlsSafe
    private static final String CHARSET_eucjp = "eucjp";
    @NlsSafe
    private static final String CHARSET_shiftjis = "shiftjis";
    @NlsSafe
    private static final String CHARSET_winansi = "winansi";
    @NlsSafe
    private static final String CHARSET_macosroman = "macosroman";
    @NlsSafe
    private static final String CHARSET_utf8 = "utf8";

    public ConfigPanel(final Project project) {
        String unsetEnv;
        this.myProject = project;
        this.$$$setupUI$$$();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.myUseConnectionParametersRadioButton);
        bg.add(this.myUseP4CONFIGOrDefaultRadioButton);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigPanel.this.reenableConnectPanel();
            }
        };
        this.myUseConnectionParametersRadioButton.addActionListener(actionListener);
        this.myUseP4CONFIGOrDefaultRadioButton.addActionListener(actionListener);
        ButtonGroup ignoreBg = new ButtonGroup();
        ignoreBg.add(this.myUseIgnoreSettingsRadioButton);
        ignoreBg.add(this.myUseP4IGNOREOrDefaultRadioButton);
        ActionListener ignoreActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigPanel.this.reenableIgnorePanel();
            }
        };
        this.myUseIgnoreSettingsRadioButton.addActionListener(ignoreActionListener);
        this.myUseP4IGNOREOrDefaultRadioButton.addActionListener(ignoreActionListener);
        this.myTestConnectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isEmpty = PerforceLoginManager.getInstance(ConfigPanel.this.myProject).getNotifier().isEmpty();
                PerforceSettings settings = new PerforceSettings(ConfigPanel.this.myProject);
                settings.setCanGoOffline(false);
                ConfigPanel.this.applyImpl(settings);
                TestPerforceConnectionManager connectionManager = new TestPerforceConnectionManager(ConfigPanel.this.myProject, !settings.useP4CONFIG);
                TestLoginManager testLoginManager = new TestLoginManager(ConfigPanel.this.myProject, settings, connectionManager);
                PerforceRunner runner = new PerforceRunner(connectionManager, settings, testLoginManager);
                if (settings.useP4CONFIG) {
                    ConnectionTestDataProvider connectionTestDataProvider = new ConnectionTestDataProvider(ConfigPanel.this.myProject, connectionManager, runner);
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(connectionTestDataProvider::refresh, PerforceBundle.message("connection.test", new Object[0]), false, ConfigPanel.this.myProject);
                    P4ConfigConnectionDiagnoseDialog dialog = new P4ConfigConnectionDiagnoseDialog(ConfigPanel.this.myProject, connectionTestDataProvider);
                    dialog.show();
                } else {
                    connectionManager.setSingletonConnection(new SingletonConnection(project, settings));
                    PerforceClientRootsChecker[] checker = new PerforceClientRootsChecker[1];
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                        Map<VirtualFile, P4Connection> allConnections = connectionManager.getAllConnections();
                        ClientRootsCache cache = ClientRootsCache.getClientRootsCache(project);
                        Map<P4Connection, ConnectionInfo> info = PerforceInfoAndClient.calculateInfos(allConnections.values(), runner, cache);
                        checker[0] = new PerforceClientRootsChecker(info, allConnections);
                    }, PerforceBundle.message("connection.test", new Object[0]), false, ConfigPanel.this.myProject);
                    PerforceConnectionProblemsNotifier.showSingleConnectionState(project, checker[0]);
                }
                if (!isEmpty) {
                    ConfigPanel.this.refreshAuthenticationState();
                }
            }
        });
        this.m_pathToExec.addBrowseFolderListener(PerforceBundle.message("dialog.title.path.to.p4.exe", new Object[0]), PerforceBundle.message("dialog.description.path.to.p4.exe", new Object[0]), project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        this.myP4VCPathField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(PerforceBundle.message("dialog.title.path.to.p4.exe", new Object[0]), PerforceBundle.message("dialog.description.path.to.p4vc.exe", new Object[0]), (ComponentWithBrowseButton)this.myP4VCPathField, project, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            protected VirtualFile getInitialFile() {
                VirtualFile file = super.getInitialFile();
                if (file == null && SystemInfo.isMac) {
                    return LocalFileSystem.getInstance().refreshAndFindFileByPath("/Applications/p4vc");
                }
                return file;
            }

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    4.$$$reportNull$$$0(0);
                }
                super.onFileChosen(chosenFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "org/jetbrains/idea/perforce/perforce/ConfigPanel$4", "onFileChosen"));
            }
        });
        this.m_pathToIgnore.addBrowseFolderListener(PerforceBundle.message("dialog.title.path.to.p4.ignore", new Object[0]), PerforceBundle.message("dialog.description.path.to.p4.ignore", new Object[0]), project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.reenableConnectPanel();
        this.reenableIgnorePanel();
        if (this.myProject.isDefault()) {
            this.hideProjectSpecificControls();
        }
        if (!(unsetEnv = P4ConfigHelper.getUnsetP4EnvironmentConfig()).isEmpty()) {
            this.myP4ConfigWarningLabel.setText(PerforceBundle.message("radio.no.p4config.env", unsetEnv));
            this.myP4ConfigWarningLabel.setVisible(true);
            RelativeFont.SMALL.install((Component)this.myP4ConfigWarningLabel);
        }
        this.myP4IgnoreWarningLabel.setVisible(!P4ConfigHelper.hasP4IgnoreSettingInEnvironment());
        RelativeFont.SMALL.install((Component)this.myP4IgnoreWarningLabel);
    }

    private void hideProjectSpecificControls() {
        this.myIsEnabled.setVisible(false);
        this.myConfigSettingsPanel.setVisible(false);
        this.myIgnoreSettingsPanel.setVisible(false);
        this.myTestConnectionButton.setVisible(false);
    }

    private void refreshAuthenticationState() {
        PerforceConnectionManager.getInstance(this.myProject).updateConnections();
    }

    private void reenableConnectPanel() {
        boolean useP4Conf = this.myUseP4CONFIGOrDefaultRadioButton.isSelected();
        this.m_port.setEnabled(!useP4Conf);
        this.m_client.setEnabled(!useP4Conf);
        this.m_user.setEnabled(!useP4Conf);
        this.myCharset.setEnabled(!useP4Conf);
        this.myUserLabel.setEnabled(!useP4Conf);
        this.myPOrtLabel.setEnabled(!useP4Conf);
        this.myClientLabel.setEnabled(!useP4Conf);
        this.myCharsetLabel.setEnabled(!useP4Conf);
        this.myTestConnectionButton.setEnabled(!this.myProject.isDefault() || !useP4Conf);
        this.reenableIgnorePanel();
    }

    private boolean shouldIgnorePanelBeEnabled() {
        boolean useP4CONFIG = this.myUseP4CONFIGOrDefaultRadioButton.isSelected();
        if (useP4CONFIG && P4ConfigHelper.hasP4ConfigSettingInEnvironment()) {
            String configFileName;
            String basePath = this.myProject.getBasePath();
            P4ConnectionParameters params = P4ConnectionCalculator.getParametersFromConfig(new File(basePath), configFileName = P4ConfigHelper.getP4ConfigFileName());
            return params.getIgnoreFileName() == null;
        }
        return true;
    }

    private void setBorderForIgnorePanel(@Nls String title) {
        Border etchedBorder = BorderFactory.createEtchedBorder();
        TitledBorder etchedTitledBorder = BorderFactory.createTitledBorder(etchedBorder, title);
        this.myIgnoreSettingsPanel.setBorder(etchedTitledBorder);
    }

    private void reenableIgnorePanel() {
        boolean useP4Ignore = this.myUseP4IGNOREOrDefaultRadioButton.isSelected();
        boolean enablePanel = this.shouldIgnorePanelBeEnabled();
        this.myIgnoreSettingsPanel.setEnabled(enablePanel);
        this.setBorderForIgnorePanel(enablePanel ? PerforceBundle.message("border.configure.ignore.settings", new Object[0]) : PerforceBundle.message("border.configure.ignore.settings.disabled", new Object[0]));
        this.myUseIgnoreSettingsRadioButton.setEnabled(enablePanel);
        this.myUseP4IGNOREOrDefaultRadioButton.setEnabled(enablePanel);
        this.myP4IgnoreWarningLabel.setEnabled(enablePanel);
        this.myIgnoreLabel.setEnabled(enablePanel && !useP4Ignore);
        this.m_pathToIgnore.setEnabled(enablePanel && !useP4Ignore);
    }

    public void resetFrom(PerforceSettings settings) {
        this.myUseP4CONFIGOrDefaultRadioButton.setSelected(settings.useP4CONFIG);
        this.myUseConnectionParametersRadioButton.setSelected(!settings.useP4CONFIG);
        this.myUseP4IGNOREOrDefaultRadioButton.setSelected(settings.useP4IGNORE);
        this.myUseIgnoreSettingsRadioButton.setSelected(!settings.useP4IGNORE);
        this.m_port.setText(settings.port);
        this.m_client.setText(settings.client);
        this.m_user.setText(settings.user);
        this.m_showCmds.setSelected(settings.showCmds);
        this.m_pathToExec.setText(settings.pathToExec);
        this.myP4VCPathField.setText(settings.PATH_TO_P4VC);
        this.m_pathToIgnore.setText(settings.pathToIgnore);
        final File dumpFile = PerforceRunner.getDumpFile();
        if (dumpFile.exists()) {
            this.myOutputFileLabel.setHyperlinkText("'", dumpFile.getAbsolutePath(), "'");
        } else {
            this.myOutputFileLabel.setText("'" + dumpFile.getAbsolutePath() + "'");
        }
        this.myOutputFileLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    RevealFileAction.openFile((File)dumpFile);
                }
            }
        });
        this.myShowBranchingHistory.setSelected(settings.SHOW_BRANCHES_HISTORY);
        this.myUseLogin.setSelected(settings.USE_LOGIN);
        this.myServerTimeoutField.setText(Integer.toString(settings.SERVER_TIMEOUT / 1000));
        this.myUsePerforceJobs.setSelected(settings.USE_PERFORCE_JOBS);
        this.mySwitchToOffline.setSelected(settings.myCanGoOffline);
        this.myShowIntegratedChangelistsInCheckBox.setSelected(settings.SHOW_INTEGRATED_IN_COMMITTED_CHANGES);
        this.myCharset.removeAllItems();
        this.myCharset.addItem(PerforceSettings.getCharsetNone());
        this.myCharset.addItem(CHARSET_ISO8859_1);
        this.myCharset.addItem(CHARSET_ISO8859_15);
        this.myCharset.addItem(CHARSET_eucjp);
        this.myCharset.addItem(CHARSET_shiftjis);
        this.myCharset.addItem(CHARSET_winansi);
        this.myCharset.addItem(CHARSET_macosroman);
        this.myCharset.addItem(CHARSET_utf8);
        this.myIsEnabled.setSelected(settings.ENABLED);
        this.myCharset.setSelectedItem(settings.CHARSET);
        this.reenableConnectPanel();
        this.reenableIgnorePanel();
    }

    public void applyTo(PerforceSettings settings) {
        this.applyImpl(settings);
        if (settings.ENABLED != this.myIsEnabled.isSelected()) {
            if (this.myIsEnabled.isSelected()) {
                settings.enable();
            } else {
                settings.disable(true);
            }
        }
    }

    private void applyImpl(PerforceSettings settings) {
        settings.useP4CONFIG = this.myUseP4CONFIGOrDefaultRadioButton.isSelected();
        settings.useP4IGNORE = this.myUseP4IGNOREOrDefaultRadioButton.isSelected();
        settings.port = this.m_port.getText();
        settings.client = this.m_client.getText();
        settings.user = this.m_user.getText();
        settings.showCmds = this.m_showCmds.isSelected();
        settings.pathToIgnore = this.m_pathToIgnore.getText();
        boolean execChanged = !Objects.equals(settings.pathToExec, this.m_pathToExec.getText());
        settings.pathToExec = this.m_pathToExec.getText();
        if (execChanged) {
            PerforceManager.getInstance(this.myProject).resetClientVersion();
        }
        settings.PATH_TO_P4VC = this.myP4VCPathField.getText();
        settings.CHARSET = (String)this.myCharset.getSelectedItem();
        settings.SHOW_BRANCHES_HISTORY = this.myShowBranchingHistory.isSelected();
        settings.USE_LOGIN = this.myUseLogin.isSelected();
        try {
            settings.SERVER_TIMEOUT = Integer.parseInt(this.myServerTimeoutField.getText()) * 1000;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        settings.USE_PERFORCE_JOBS = this.myUsePerforceJobs.isSelected();
        settings.myCanGoOffline = this.mySwitchToOffline.isSelected();
        settings.SHOW_INTEGRATED_IN_COMMITTED_CHANGES = this.myShowIntegratedChangelistsInCheckBox.isSelected();
    }

    public boolean equalsToSettings(PerforceSettings settings) {
        if (this.connectionPartDiffer(settings)) {
            return false;
        }
        if (!Integer.toString(settings.SERVER_TIMEOUT / 1000).equals(this.myServerTimeoutField.getText())) {
            return false;
        }
        if (settings.showCmds != this.m_showCmds.isSelected()) {
            return false;
        }
        if (settings.SHOW_BRANCHES_HISTORY != this.myShowBranchingHistory.isSelected()) {
            return false;
        }
        if (!Objects.equals(settings.pathToExec, this.m_pathToExec.getText().trim())) {
            return false;
        }
        if (!Objects.equals(settings.pathToIgnore, this.m_pathToIgnore.getText().trim())) {
            return false;
        }
        if (settings.useP4IGNORE != this.myUseP4IGNOREOrDefaultRadioButton.isSelected()) {
            return false;
        }
        if (!Objects.equals(settings.PATH_TO_P4VC, this.myP4VCPathField.getText().trim())) {
            return false;
        }
        if (!Comparing.equal((Object)settings.USE_PERFORCE_JOBS, (Object)this.myUsePerforceJobs.isSelected())) {
            return false;
        }
        if (!Comparing.equal((Object)settings.myCanGoOffline, (Object)this.mySwitchToOffline.isSelected())) {
            return false;
        }
        if (!Comparing.equal((Object)settings.SHOW_INTEGRATED_IN_COMMITTED_CHANGES, (Object)this.myShowIntegratedChangelistsInCheckBox.isSelected())) {
            return false;
        }
        return Comparing.equal((Object)settings.CHARSET, (Object)this.myCharset.getSelectedItem());
    }

    private boolean connectionPartDiffer(PerforceSettings settings) {
        if (settings.useP4CONFIG != this.myUseP4CONFIGOrDefaultRadioButton.isSelected()) {
            return true;
        }
        if (settings.USE_LOGIN != this.myUseLogin.isSelected()) {
            return true;
        }
        if (!Objects.equals(settings.port, this.m_port.getText().trim())) {
            return true;
        }
        if (!Objects.equals(settings.client, this.m_client.getText().trim())) {
            return true;
        }
        if (!Objects.equals(settings.user, this.m_user.getText().trim())) {
            return true;
        }
        return settings.ENABLED != this.myIsEnabled.isSelected();
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JRadioButton jRadioButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JBLabel jBLabel;
        JRadioButton jRadioButton2;
        JPanel jPanel;
        JBLabel jBLabel2;
        JRadioButton jRadioButton3;
        JComboBox jComboBox;
        JLabel jLabel2;
        JTextField jTextField;
        JLabel jLabel3;
        JTextField jTextField2;
        JLabel jLabel4;
        JTextField jTextField3;
        JLabel jLabel5;
        JRadioButton jRadioButton4;
        JPanel jPanel2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JTextField jTextField4;
        JCheckBox jCheckBox4;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JButton jButton;
        JCheckBox jCheckBox5;
        HyperlinkLabel hyperlinkLabel;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myIsEnabled = jCheckBox7 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox7, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("checkbox.configure.perforce.is.enabled"));
        jPanel4.add((Component)jCheckBox7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel5).setVisible(true);
        jPanel4.add((Component)jPanel5, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.m_showCmds = jCheckBox6 = new JCheckBox();
        jCheckBox6.setHorizontalAlignment(2);
        this.$$$loadButtonText$$$(jCheckBox6, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("checkbox.configure.perforce.log.commands"));
        jPanel6.add((Component)jCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputFileLabel = hyperlinkLabel = new HyperlinkLabel();
        jPanel6.add((Component)hyperlinkLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel7).setVisible(true);
        jPanel4.add((Component)jPanel7, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myUseLogin = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("checkbox.configure.perforce.use.login.authentication"));
        jPanel7.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTestConnectionButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("button.text.test.connection"));
        jPanel7.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 5, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel8, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        this.$$$loadLabelText$$$(jLabel6, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("label.configure.perforce.path.to.p4.exe"));
        jPanel8.add((Component)jLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel7 = new JLabel();
        this.$$$loadLabelText$$$(jLabel7, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("label.configure.perforce.path.to.p4vc.exe"));
        jPanel8.add((Component)jLabel7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.m_pathToExec = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel8.add((Component)textFieldWithBrowseButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myP4VCPathField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel8.add((Component)textFieldWithBrowseButton2, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myShowBranchingHistory = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("checkbox.configure.perforce.show.branching.history"));
        ((Component)jCheckBox4).setVisible(true);
        jPanel4.add((Component)jCheckBox4, new GridConstraints(7, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 5, 0, 0), -1, -1, false, false));
        ((Component)jPanel9).setVisible(true);
        jPanel4.add((Component)jPanel9, new GridConstraints(9, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel8 = new JLabel();
        this.$$$loadLabelText$$$(jLabel8, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("server.timeout"));
        jPanel9.add((Component)jLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel9.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myServerTimeoutField = jTextField4 = new JTextField();
        jTextField4.setColumns(8);
        jPanel9.add((Component)jTextField4, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        this.$$$loadLabelText$$$(jLabel9, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("configure.perforce.timeout.seconds"));
        jPanel9.add((Component)jLabel9, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myShowIntegratedChangelistsInCheckBox = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("checkbox.configure.perforce.show.integrated.changelists"));
        jPanel4.add((Component)jCheckBox3, new GridConstraints(8, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.mySwitchToOffline = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("checkbox.switch.offline"));
        ((Component)jCheckBox2).setVisible(true);
        jPanel4.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myConfigSettingsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("border.configure.perforce.config.settings"), (int)0, (int)0, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel10, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseConnectionParametersRadioButton = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("connection.params"));
        jPanel10.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel11, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 3));
        this.myPOrtLabel = jLabel5 = new JLabel();
        jLabel5.setHorizontalAlignment(10);
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("label.configure.perforce.port"));
        jPanel11.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.m_port = jTextField3 = new JTextField();
        jPanel11.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        this.myClientLabel = jLabel4 = new JLabel();
        jLabel4.setHorizontalAlignment(10);
        jLabel4.setHorizontalTextPosition(11);
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("label.configure.perforce.client"));
        jPanel11.add((Component)jLabel4, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.m_client = jTextField2 = new JTextField();
        jPanel11.add((Component)jTextField2, new GridConstraints(0, 3, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        this.myUserLabel = jLabel3 = new JLabel();
        jLabel3.setHorizontalAlignment(10);
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("label.configure.perforce.user"));
        jPanel11.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.m_user = jTextField = new JTextField();
        jPanel11.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(150, -1), null));
        this.myCharsetLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("combobox.configure.perforce.charset"));
        jPanel11.add((Component)jLabel2, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCharset = jComboBox = new JComboBox();
        jPanel11.add(jComboBox, new GridConstraints(1, 3, 1, 1, 8, 1, 7, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel10.add((Component)spacer3, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel12, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseP4CONFIGOrDefaultRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("checkbox.configure.perforce.use.p4config"));
        jRadioButton3.setToolTipText(ResourceBundle.getBundle("messages/PerforceBundle").getString("checkbox.configure.perforce.use.p4config.tooltip"));
        jPanel12.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myP4ConfigWarningLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("radio.no.p4config.env"));
        jPanel12.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        this.myIgnoreSettingsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("border.configure.ignore.settings"), (int)0, (int)0, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel13, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseP4IGNOREOrDefaultRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("checkbox.configure.ignore.use.p4ignore"));
        jPanel13.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myP4IgnoreWarningLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("radio.no.p4ignore.env"));
        jPanel13.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel14, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null, 3));
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel14.add((Component)jPanel15, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myIgnoreLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("ignore.path.to.file"));
        jPanel15.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.m_pathToIgnore = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel15.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myUseIgnoreSettingsRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("ignore.settings"));
        jPanel.add((Component)jRadioButton, new GridConstraints(1, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel3.add((Component)spacer4, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel3.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myUsePerforceJobs = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PerforceBundle", ConfigPanel.class).getString("perforce.use.perforce.jobs"));
        ((Component)jCheckBox).setVisible(true);
        jPanel3.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel5.setLabelFor(jTextField3);
        jLabel4.setLabelFor(jTextField2);
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class TestPerforceConnectionManager
    implements PerforceConnectionManagerI {
        private final Project myProject;
        private SingletonConnection mySingletonConnection;
        private final boolean mySingleton;
        private PerforceMultipleConnections myMc;

        TestPerforceConnectionManager(Project project, boolean singleton) {
            this.myProject = project;
            this.mySingleton = singleton;
        }

        public void setSingletonConnection(SingletonConnection singletonConnection) {
            this.mySingletonConnection = singletonConnection;
        }

        public void setMc(PerforceMultipleConnections mc) {
            this.myMc = mc;
        }

        @Override
        public PerforceMultipleConnections getMultipleConnectionObject() {
            return this.myMc;
        }

        @Override
        @NotNull
        public Map<VirtualFile, P4Connection> getAllConnections() {
            if (this.mySingleton) {
                LinkedHashMap<VirtualFile, P4Connection> result = new LinkedHashMap<VirtualFile, P4Connection>();
                for (VirtualFile root : ProjectLevelVcsManager.getInstance((Project)this.myProject).getRootsUnderVcs((AbstractVcs)PerforceVcs.getInstance(this.myProject))) {
                    result.put(root, this.mySingletonConnection);
                }
                LinkedHashMap<VirtualFile, P4Connection> linkedHashMap = result;
                if (linkedHashMap == null) {
                    TestPerforceConnectionManager.$$$reportNull$$$0(0);
                }
                return linkedHashMap;
            }
            Map<VirtualFile, P4Connection> map = this.myMc.getAllConnections();
            if (map == null) {
                TestPerforceConnectionManager.$$$reportNull$$$0(1);
            }
            return map;
        }

        @Override
        public P4Connection getConnectionForFile(@NotNull File file) {
            if (file == null) {
                TestPerforceConnectionManager.$$$reportNull$$$0(2);
            }
            if (this.mySingleton) {
                return this.mySingletonConnection;
            }
            VirtualFile vf = PerforceConnectionManager.findNearestLiveParentFor(file);
            if (vf == null) {
                return null;
            }
            return this.myMc.getConnection(vf);
        }

        @Override
        public P4Connection getConnectionForFile(@NotNull P4File file) {
            if (file == null) {
                TestPerforceConnectionManager.$$$reportNull$$$0(3);
            }
            if (this.mySingleton) {
                return this.mySingletonConnection;
            }
            return this.getConnectionForFile(file.getLocalFile());
        }

        @Override
        public P4Connection getConnectionForFile(@NotNull VirtualFile file) {
            if (file == null) {
                TestPerforceConnectionManager.$$$reportNull$$$0(4);
            }
            if (this.mySingleton) {
                return this.mySingletonConnection;
            }
            return this.myMc.getConnection(file);
        }

        @Override
        public boolean isSingletonConnectionUsed() {
            return this.mySingleton;
        }

        @Override
        public void updateConnections() {
        }

        @Override
        public boolean isUnderProjectConnections(@NotNull File file) {
            if (file == null) {
                TestPerforceConnectionManager.$$$reportNull$$$0(5);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/perforce/perforce/ConfigPanel$TestPerforceConnectionManager";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllConnections";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/perforce/perforce/ConfigPanel$TestPerforceConnectionManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getConnectionForFile";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isUnderProjectConnections";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class TestLoginManager
    implements LoginSupport {
        private final Project myProject;
        private final PerforceSettings mySettings;
        private final PerforceConnectionManagerI myConnectionManagerI;

        private TestLoginManager(Project project, PerforceSettings settings, PerforceConnectionManagerI connectionManagerI) {
            this.myProject = project;
            this.mySettings = settings;
            this.myConnectionManagerI = connectionManagerI;
        }

        @Override
        public boolean silentLogin(P4Connection connection) throws VcsException {
            LoginState login;
            String password = connection instanceof P4ParametersConnection ? ((P4ParametersConnection)connection).getParameters().getPassword() : this.mySettings.getPasswd();
            LoginPerformerImpl loginPerformer = new LoginPerformerImpl(this.myProject, connection, this.myConnectionManagerI);
            if (password != null && loginPerformer.login(password).isSuccess()) {
                return true;
            }
            do {
                if ((password = this.mySettings.requestForPassword(this.mySettings.useP4CONFIG ? connection : null)) != null) continue;
                return false;
            } while (!(login = loginPerformer.login(password)).isSuccess());
            PerforceConnectionManager.getInstance(this.myProject).updateConnections();
            return true;
        }

        @Override
        public void notLogged(P4Connection connection) {
        }
    }

    private static class ConnectionTestDataProvider
    implements ConnectionDiagnoseRefresher {
        private final Project myProject;
        private final TestPerforceConnectionManager myConnectionManager;
        private final PerforceRunner myRunner;
        private PerforceClientRootsChecker myChecker = new PerforceClientRootsChecker();
        private Map<P4Connection, ConnectionInfo> myInfo = Collections.emptyMap();
        private PerforceMultipleConnections myMc;

        ConnectionTestDataProvider(Project project, TestPerforceConnectionManager connectionManager, PerforceRunner runner) {
            this.myProject = project;
            this.myConnectionManager = connectionManager;
            this.myRunner = runner;
        }

        @Override
        public void refresh() {
            P4ConnectionCalculator calculator = new P4ConnectionCalculator(this.myProject);
            calculator.execute();
            this.myMc = calculator.getMultipleConnections();
            Map<VirtualFile, P4Connection> map = this.myMc.getAllConnections();
            this.myConnectionManager.setMc(this.myMc);
            this.myInfo = PerforceInfoAndClient.recalculateInfos(this.myInfo, map.values(), (PerforceRunner)this.myRunner, (ClientRootsCache)ClientRootsCache.getClientRootsCache((Project)this.myProject)).newInfo;
            this.myChecker = new PerforceClientRootsChecker(this.myInfo, map);
        }

        @Override
        public PerforceMultipleConnections getMultipleConnections() {
            return this.myMc;
        }

        @Override
        public P4RootsInformation getP4RootsInformation() {
            return this.myChecker;
        }
    }
}

