/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig;

import com.intellij.BundleBase;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.editorconfig.EditorConfigNotifier;
import org.editorconfig.EditorConfigRegistry;
import org.editorconfig.configmanagement.ConfigEncodingManager;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.language.messages.EditorConfigBundle;
import org.editorconfig.plugincomponents.SettingsProviderComponent;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class Utils {
    public static final String EDITOR_CONFIG_NAME = "EditorConfig";
    public static final String EDITOR_CONFIG_FILE_NAME = ".editorconfig";
    public static final String FULL_SETTINGS_SUPPORT_REG_KEY = "editor.config.full.settings.support";
    public static final String PLUGIN_ID = "org.editorconfig.editorconfigjetbrains";
    private static boolean ourIsFullSettingsSupportEnabledInTest;

    public static String configValueForKey(List<? extends EditorConfig.OutPair> outPairs, String key) {
        for (EditorConfig.OutPair outPair : outPairs) {
            if (!outPair.getKey().equals(key)) continue;
            String val = outPair.getVal();
            return "none".equals(val) || "unset".equals(val) ? "" : val;
        }
        return "";
    }

    public static boolean isEnabled(CodeStyleSettings currentSettings) {
        if (currentSettings == null) {
            return false;
        }
        EditorConfigSettings settings = (EditorConfigSettings)currentSettings.getCustomSettingsIfCreated(EditorConfigSettings.class);
        return settings != null && settings.ENABLED;
    }

    public static boolean isEnabled(@NotNull Project project) {
        if (project == null) {
            Utils.$$$reportNull$$$0(0);
        }
        return Utils.isEnabled(CodeStyle.getSettings((Project)project));
    }

    public static boolean isFullIntellijSettingsSupport() {
        return ourIsFullSettingsSupportEnabledInTest || Registry.is((String)FULL_SETTINGS_SUPPORT_REG_KEY) && !EditorConfigRegistry.shouldSupportDotNet();
    }

    @TestOnly
    public static void setFullIntellijSettingsSupportEnabledInTest(boolean enabled) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ourIsFullSettingsSupportEnabledInTest = enabled;
        }
    }

    public static void invalidConfigMessage(Project project, String configValue, String configKey, String filePath) {
        Object[] params = new Object[]{configValue, !configKey.isEmpty() ? configKey : "?", filePath};
        String message2 = configValue != null ? BundleBase.messageOrDefault((ResourceBundle)EditorConfigBundle.INSTANCE.getResourceBundle(), (String)"invalid.config.value", null, (Object[])params) : EditorConfigBundle.message("read.failure");
        configValue = configValue != null ? configValue : "ioError";
        EditorConfigNotifier.error(project, configValue, message2);
    }

    public static String getFilePath(Project project, VirtualFile file) {
        if (!file.isInLocalFileSystem()) {
            return project.getBasePath() + "/" + file.getNameWithoutExtension() + "." + file.getFileType().getDefaultExtension();
        }
        return file.getCanonicalPath();
    }

    public static String exportToString(Project project) {
        CodeStyleSettings settings = CodeStyle.getSettings((Project)project);
        CommonCodeStyleSettings.IndentOptions commonIndentOptions = settings.getIndentOptions();
        StringBuilder result2 = new StringBuilder();
        Utils.addIndentOptions(result2, "*", commonIndentOptions, Utils.getEncodingLine(project) + Utils.getLineEndings(project) + Utils.getTrailingSpacesLine() + Utils.getEndOfFileLine());
        for (FileType fileType : FileTypeManager.getInstance().getRegisteredFileTypes()) {
            CommonCodeStyleSettings.IndentOptions options;
            if (!FileTypeIndex.containsFileOfType((FileType)fileType, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)) || Utils.equalIndents(commonIndentOptions, options = settings.getIndentOptions(fileType))) continue;
            Utils.addIndentOptions(result2, Utils.buildPattern(fileType), options, "");
        }
        return result2.toString();
    }

    public static void export(Project project) {
        String message2;
        VirtualFile baseDir = project.getBaseDir();
        VirtualFile child = baseDir.findChild(EDITOR_CONFIG_FILE_NAME);
        if (child != null && Messages.showYesNoDialog((Project)project, (String)(message2 = EditorConfigBundle.message("dialog.message.editorconfig.already.present.in.overwrite", baseDir.getPath())), (String)EditorConfigBundle.message("dialog.title.editorconfig.exists"), null) == 1) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                VirtualFile editorConfig = baseDir.findOrCreateChildData(Utils.class, EDITOR_CONFIG_FILE_NAME);
                VfsUtil.saveText((VirtualFile)editorConfig, (String)Utils.exportToString(project));
            }
            catch (IOException e) {
                Logger.getInstance(Utils.class).error((Throwable)e);
            }
        });
    }

    @NotNull
    private static String getEndOfFileLine() {
        String string = "insert_final_newline=" + EditorSettingsExternalizable.getInstance().isEnsureNewLineAtEOF() + "\n";
        if (string == null) {
            Utils.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String getTrailingSpacesLine() {
        Boolean trimTrailingSpaces = Utils.getTrimTrailingSpaces();
        return trimTrailingSpaces != null ? "trim_trailing_whitespace=" + trimTrailingSpaces + "\n" : "";
    }

    @Nullable
    public static Boolean getTrimTrailingSpaces() {
        String spaces = EditorSettingsExternalizable.getInstance().getStripTrailingSpaces();
        if ("None".equals(spaces)) {
            return false;
        }
        if ("Whole".equals(spaces)) {
            return true;
        }
        return null;
    }

    @NotNull
    private static String getLineEndings(@NotNull Project project) {
        String separator;
        String s;
        if (project == null) {
            Utils.$$$reportNull$$$0(2);
        }
        if ((s = Utils.getLineSeparatorString(separator = CodeStyle.getSettings((Project)project).getLineSeparator())) != null) {
            String string = "end_of_line=" + s + "\n";
            if (string == null) {
                Utils.$$$reportNull$$$0(3);
            }
            return string;
        }
        return "";
    }

    @Nullable
    public static String getLineSeparatorString(@NotNull String separator) {
        if (separator == null) {
            Utils.$$$reportNull$$$0(4);
        }
        for (LineSeparator s : LineSeparator.values()) {
            if (!separator.equals(s.getSeparatorString())) continue;
            return StringUtil.toLowerCase((String)s.name());
        }
        return null;
    }

    @NotNull
    public static String getEncodingLine(@NotNull Project project) {
        String encoding;
        if (project == null) {
            Utils.$$$reportNull$$$0(5);
        }
        return (encoding = Utils.getEncoding(project)) != null ? "charset=" + encoding + "\n" : "";
    }

    @Nullable
    public static String getEncoding(@NotNull Project project) {
        if (project == null) {
            Utils.$$$reportNull$$$0(6);
        }
        EncodingProjectManager encodingManager = EncodingProjectManager.getInstance((Project)project);
        return ConfigEncodingManager.toString(encodingManager.getDefaultCharset(), encodingManager.shouldAddBOMForNewUtf8File());
    }

    @NotNull
    public static String buildPattern(FileType fileType) {
        List associations = FileTypeManager.getInstance().getAssociations(fileType);
        String result2 = associations.stream().map(matcher -> matcher.getPresentableString()).sorted().collect(Collectors.joining(","));
        if (associations.size() > 1) {
            String string = "{" + result2 + "}";
            if (string == null) {
                Utils.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = result2;
        if (string == null) {
            Utils.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static boolean equalIndents(CommonCodeStyleSettings.IndentOptions commonIndentOptions, CommonCodeStyleSettings.IndentOptions options) {
        return options.USE_TAB_CHARACTER == commonIndentOptions.USE_TAB_CHARACTER && options.TAB_SIZE == commonIndentOptions.TAB_SIZE && options.INDENT_SIZE == commonIndentOptions.INDENT_SIZE;
    }

    private static void addIndentOptions(StringBuilder result2, String pattern, CommonCodeStyleSettings.IndentOptions options, String additionalText) {
        if (pattern.isEmpty()) {
            return;
        }
        result2.append("[").append(pattern).append("]").append("\n");
        result2.append(additionalText);
        result2.append("indent_style").append("=");
        if (options.USE_TAB_CHARACTER) {
            result2.append("tab\n");
            result2.append("tab_width").append("=").append(options.TAB_SIZE).append("\n");
        } else {
            result2.append("space\n");
            result2.append("indent_size").append("=").append(options.INDENT_SIZE).append("\n");
        }
        result2.append("\n");
    }

    public static boolean editorConfigExists(@NotNull Project project) {
        if (project == null) {
            Utils.$$$reportNull$$$0(9);
        }
        SettingsProviderComponent settingsProvider = SettingsProviderComponent.getInstance();
        String basePath = project.getBasePath();
        if (basePath == null) {
            return false;
        }
        File projectDir = new File(basePath);
        Set<String> rootDirs = settingsProvider.getRootDirs(project);
        if (rootDirs.isEmpty()) {
            rootDirs = Collections.singleton(basePath);
        }
        block0: for (String rootDir : rootDirs) {
            for (File currRoot = new File(rootDir); currRoot != null; currRoot = currRoot.getParentFile()) {
                if (Utils.containsEditorConfig(currRoot)) {
                    return true;
                }
                if (EditorConfigRegistry.shouldStopAtProjectRoot() && FileUtil.filesEqual((File)currRoot, (File)projectDir)) continue block0;
            }
        }
        return false;
    }

    private static boolean containsEditorConfig(@NotNull File dir) {
        if (dir == null) {
            Utils.$$$reportNull$$$0(10);
        }
        return dir.exists() && dir.isDirectory() && FileUtil.exists((String)(dir.getPath() + File.separator + EDITOR_CONFIG_FILE_NAME));
    }

    @NotNull
    public static List<VirtualFile> pathsToFiles(@NotNull List<String> paths) {
        if (paths == null) {
            Utils.$$$reportNull$$$0(11);
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (String path : paths) {
            VirtualFile file = VfsUtil.findFile((Path)Paths.get(path, new String[0]), (boolean)true);
            if (file == null) continue;
            files.add(file);
        }
        ArrayList<VirtualFile> arrayList = files;
        if (arrayList == null) {
            Utils.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    public static boolean isApplicableTo(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            Utils.$$$reportNull$$$0(13);
        }
        return virtualFile.isInLocalFileSystem() && virtualFile.isValid();
    }

    public static boolean isEditorConfigFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            Utils.$$$reportNull$$$0(14);
        }
        return EDITOR_CONFIG_FILE_NAME.equalsIgnoreCase(virtualFile.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/Utils";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/Utils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndOfFileLine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineEndings";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPattern";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "pathsToFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineEndings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLineSeparatorString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getEncodingLine";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEncoding";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "editorConfigExists";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "containsEditorConfig";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "pathsToFiles";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableTo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isEditorConfigFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

