/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\b\u0010\u000e\u001a\u00020\fH\u0002J\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005J\u0006\u0010\u0014\u001a\u00020\u0005J\b\u0010\u0015\u001a\u00020\u0005H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lkotlinx/serialization/protobuf/internal/ByteArrayInput;", "", "array", "", "endIndex", "", "([BI)V", "availableBytes", "getAvailableBytes", "()I", "position", "ensureEnoughBytes", "", "bytesCount", "eof", "read", "readExactNBytes", "readString", "", "length", "readVarint32", "readVarint32SlowPath", "readVarint64", "", "eofAllowed", "", "readVarint64SlowPath", "slice", "size", "kotlinx-serialization-protobuf"})
public final class ByteArrayInput {
    @NotNull
    private byte[] array;
    private final int endIndex;
    private int position;

    public ByteArrayInput(@NotNull byte[] array, int endIndex) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.array = array;
        this.endIndex = endIndex;
    }

    public /* synthetic */ ByteArrayInput(byte[] byArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = byArray.length;
        }
        this(byArray, n);
    }

    public final int getAvailableBytes() {
        return this.endIndex - this.position;
    }

    @NotNull
    public final ByteArrayInput slice(int size) {
        this.ensureEnoughBytes(size);
        ByteArrayInput result = new ByteArrayInput(this.array, this.position + size);
        result.position = this.position;
        this.position += size;
        return result;
    }

    public final int read() {
        int n;
        if (this.position < this.endIndex) {
            int n2 = this.position;
            this.position = n2 + 1;
            n = this.array[n2] & 0xFF;
        } else {
            n = -1;
        }
        return n;
    }

    @NotNull
    public final byte[] readExactNBytes(int bytesCount) {
        this.ensureEnoughBytes(bytesCount);
        byte[] b = new byte[bytesCount];
        int length = b.length;
        int copied = this.endIndex - this.position < length ? this.endIndex - this.position : length;
        ArraysKt.copyInto((byte[])this.array, (byte[])b, (int)0, (int)this.position, (int)(this.position + copied));
        this.position += copied;
        return b;
    }

    private final void ensureEnoughBytes(int bytesCount) {
        if (bytesCount > this.getAvailableBytes()) {
            throw new SerializationException("Unexpected EOF, available " + this.getAvailableBytes() + " bytes, requested: " + bytesCount);
        }
    }

    @NotNull
    public final String readString(int length) {
        String result = StringsKt.decodeToString$default((byte[])this.array, (int)this.position, (int)(this.position + length), (boolean)false, (int)4, null);
        this.position += length;
        return result;
    }

    public final int readVarint32() {
        int result;
        if (this.position == this.endIndex) {
            this.eof();
        }
        int currentPosition = this.position;
        if ((result = this.array[currentPosition++]) >= 0) {
            this.position = currentPosition;
            return result;
        }
        if (this.endIndex - this.position > 1 && (result ^= this.array[currentPosition++] << 7) < 0) {
            this.position = currentPosition;
            return result ^ 0xFFFFFF80;
        }
        return this.readVarint32SlowPath();
    }

    public final long readVarint64(boolean eofAllowed) {
        long result;
        if (this.position == this.endIndex) {
            if (eofAllowed) {
                return -1L;
            }
            this.eof();
        }
        int currentPosition = this.position;
        if ((result = (long)this.array[currentPosition++]) >= 0L) {
            this.position = currentPosition;
            return result;
        }
        if (this.endIndex - this.position > 1 && (result ^= (long)this.array[currentPosition++] << 7) < 0L) {
            this.position = currentPosition;
            return result ^ 0xFFFFFFFFFFFFFF80L;
        }
        return this.readVarint64SlowPath();
    }

    private final void eof() {
        throw new SerializationException("Unexpected EOF");
    }

    private final long readVarint64SlowPath() {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            int n = this.read();
            result |= (long)(n & 0x7F) << shift;
            if ((n & 0x80) != 0) continue;
            return result;
        }
        throw new SerializationException("Input stream is malformed: Varint too long (exceeded 64 bits)");
    }

    private final int readVarint32SlowPath() {
        int result = 0;
        for (int shift = 0; shift < 32; shift += 7) {
            int n = this.read();
            result |= (n & 0x7F) << shift;
            if ((n & 0x80) != 0) continue;
            return result;
        }
        throw new SerializationException("Input stream is malformed: Varint too long (exceeded 32 bits)");
    }
}

