/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.common.statistics;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.common.statistics.DoubleValue;
import org.jetbrains.projector.common.statistics.LongValue;
import org.jetbrains.projector.common.statistics.RoundingStrategy;
import org.jetbrains.projector.common.statistics.StatsValue;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u0014*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0003\u0014\u0015\u0016B/\b\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\f0\u0013R\b\u0012\u0004\u0012\u00028\u00000\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/projector/common/statistics/Average;", "ValueType", "", "", "value", "Lorg/jetbrains/projector/common/statistics/StatsValue;", "unit", "", "name", "roundingStrategy", "Lorg/jetbrains/projector/common/statistics/RoundingStrategy;", "(Lorg/jetbrains/projector/common/statistics/StatsValue;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/projector/common/statistics/RoundingStrategy;)V", "iterations", "", "add", "", "measurement", "(Ljava/lang/Number;)V", "reset", "Lorg/jetbrains/projector/common/statistics/Average$ResetResult;", "Companion", "Data", "ResetResult", "projector-common"})
public final class Average<ValueType extends Number> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StatsValue<ValueType> value;
    @Nullable
    private final String unit;
    @NotNull
    private final String name;
    @NotNull
    private final RoundingStrategy roundingStrategy;
    private long iterations;

    private Average(StatsValue<ValueType> value, String unit, String name, RoundingStrategy roundingStrategy) {
        this.value = value;
        this.unit = unit;
        this.name = name;
        this.roundingStrategy = roundingStrategy;
    }

    public final void add(@NotNull ValueType measurement) {
        Intrinsics.checkNotNullParameter(measurement, (String)"measurement");
        ++this.iterations;
        this.value.add(measurement);
    }

    @NotNull
    public final ResetResult reset() {
        Data data;
        if (this.iterations == 0L) {
            data = Data.Empty.INSTANCE;
        } else {
            Data.Success success;
            ValueType resetValue = this.value.reset();
            Data.Success it = success = new Data.Success(((Number)resetValue).doubleValue() / (double)this.iterations, this.iterations);
            boolean bl = false;
            this.iterations = 0L;
            data = success;
        }
        Data data2 = data;
        return new ResetResult(data2);
    }

    public /* synthetic */ Average(StatsValue value, String unit, String name, RoundingStrategy roundingStrategy, DefaultConstructorMarker $constructor_marker) {
        this(value, unit, name, roundingStrategy);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/projector/common/statistics/Average$ResetResult;", "", "data", "Lorg/jetbrains/projector/common/statistics/Average$Data;", "(Lorg/jetbrains/projector/common/statistics/Average;Lorg/jetbrains/projector/common/statistics/Average$Data;)V", "getData", "()Lorg/jetbrains/projector/common/statistics/Average$Data;", "generateString", "", "separator", "projector-common"})
    public final class ResetResult {
        @NotNull
        private final Data data;

        public ResetResult(Data data) {
            Intrinsics.checkNotNullParameter((Object)Average.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
        }

        @NotNull
        public final Data getData() {
            return this.data;
        }

        @NotNull
        public final String generateString(@NotNull String separator) {
            Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
            return Average.this.name + " average:" + separator + this.data.generateString(Average.this.roundingStrategy, Average.this.unit, separator);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\t\nB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0004H&\u0082\u0001\u0002\u000b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/projector/common/statistics/Average$Data;", "", "()V", "generateString", "", "roundingStrategy", "Lorg/jetbrains/projector/common/statistics/RoundingStrategy;", "unit", "separator", "Empty", "Success", "Lorg/jetbrains/projector/common/statistics/Average$Data$Empty;", "Lorg/jetbrains/projector/common/statistics/Average$Data$Success;", "projector-common"})
    public static abstract class Data {
        private Data() {
        }

        @NotNull
        public abstract String generateString(@NotNull RoundingStrategy var1, @Nullable String var2, @NotNull String var3);

        public /* synthetic */ Data(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/projector/common/statistics/Average$Data$Empty;", "Lorg/jetbrains/projector/common/statistics/Average$Data;", "()V", "generateString", "", "roundingStrategy", "Lorg/jetbrains/projector/common/statistics/RoundingStrategy;", "unit", "separator", "projector-common"})
        public static final class Empty
        extends Data {
            @NotNull
            public static final Empty INSTANCE = new Empty();

            private Empty() {
                super(null);
            }

            @Override
            @NotNull
            public String generateString(@NotNull RoundingStrategy roundingStrategy, @Nullable String unit, @NotNull String separator) {
                Intrinsics.checkNotNullParameter((Object)roundingStrategy, (String)"roundingStrategy");
                Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
                return "no data" + separator + "(no iterations data)";
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/projector/common/statistics/Average$Data$Success;", "Lorg/jetbrains/projector/common/statistics/Average$Data;", "average", "", "iterations", "", "(DJ)V", "getAverage", "()D", "getIterations", "()J", "component1", "component2", "copy", "equals", "", "other", "", "generateString", "", "roundingStrategy", "Lorg/jetbrains/projector/common/statistics/RoundingStrategy;", "unit", "separator", "hashCode", "", "toString", "projector-common"})
        public static final class Success
        extends Data {
            private final double average;
            private final long iterations;

            public Success(double average, long iterations) {
                super(null);
                this.average = average;
                this.iterations = iterations;
            }

            public final double getAverage() {
                return this.average;
            }

            public final long getIterations() {
                return this.iterations;
            }

            @Override
            @NotNull
            public String generateString(@NotNull RoundingStrategy roundingStrategy, @Nullable String unit, @NotNull String separator) {
                Intrinsics.checkNotNullParameter((Object)roundingStrategy, (String)"roundingStrategy");
                Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
                String postfix = unit == null ? "" : " " + ((Object)StringsKt.trim((CharSequence)unit)).toString();
                return roundingStrategy.round(this.average) + postfix + separator + "(" + this.iterations + " iterations)";
            }

            public final double component1() {
                return this.average;
            }

            public final long component2() {
                return this.iterations;
            }

            @NotNull
            public final Success copy(double average, long iterations) {
                return new Success(average, iterations);
            }

            public static /* synthetic */ Success copy$default(Success success, double d, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    d = success.average;
                }
                if ((n & 2) != 0) {
                    l = success.iterations;
                }
                return success.copy(d, l);
            }

            @NotNull
            public String toString() {
                return "Success(average=" + this.average + ", iterations=" + this.iterations + ")";
            }

            public int hashCode() {
                int result = Double.hashCode(this.average);
                result = result * 31 + Long.hashCode(this.iterations);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Success)) {
                    return false;
                }
                Success success = (Success)other;
                if (!Intrinsics.areEqual((Object)this.average, (Object)success.average)) {
                    return false;
                }
                return this.iterations == success.iterations;
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0007J(\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/projector/common/statistics/Average$Companion;", "", "()V", "createForDouble", "Lorg/jetbrains/projector/common/statistics/Average;", "", "name", "", "roundingStrategy", "Lorg/jetbrains/projector/common/statistics/RoundingStrategy;", "unit", "createForLong", "", "projector-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Average<Double> createForDouble(@NotNull String name, @NotNull RoundingStrategy roundingStrategy, @Nullable String unit) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)roundingStrategy, (String)"roundingStrategy");
            return new Average<Double>(new DoubleValue(), unit, name, roundingStrategy, null);
        }

        public static /* synthetic */ Average createForDouble$default(Companion companion, String string, RoundingStrategy roundingStrategy, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            return companion.createForDouble(string, roundingStrategy, string2);
        }

        @NotNull
        public final Average<Long> createForLong(@NotNull String name, @NotNull RoundingStrategy roundingStrategy, @Nullable String unit) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)roundingStrategy, (String)"roundingStrategy");
            return new Average<Long>(new LongValue(), unit, name, roundingStrategy, null);
        }

        public static /* synthetic */ Average createForLong$default(Companion companion, String string, RoundingStrategy roundingStrategy, String string2, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            return companion.createForLong(string, roundingStrategy, string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

