/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.util.threading;

import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.LoggerKt;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reflection.ReflectionUtilKt;
import com.jetbrains.rd.util.threading.SchedulerUtilKt;
import com.jetbrains.rd.util.threading.SpinWait;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0007"}, d2={"asRdScheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "Ljava/util/concurrent/Executor;", "getAsRdScheduler", "(Ljava/util/concurrent/Executor;)Lcom/jetbrains/rd/util/reactive/IScheduler;", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lkotlinx/coroutines/CoroutineDispatcher;)Lcom/jetbrains/rd/util/reactive/IScheduler;", "rd-core"})
public final class SchedulerUtilKt {
    @NotNull
    public static final IScheduler getAsRdScheduler(@NotNull Executor $this$asRdScheduler) {
        IScheduler iScheduler;
        Intrinsics.checkNotNullParameter((Object)$this$asRdScheduler, (String)"$this$asRdScheduler");
        Executor executor2 = $this$asRdScheduler;
        Executor executor3 = executor2;
        if (!(executor3 instanceof IScheduler)) {
            executor3 = null;
        }
        if ((iScheduler = (IScheduler)((Object)executor3)) == null) {
            iScheduler = new IScheduler(executor2){
                static final /* synthetic */ KProperty[] $$delegatedProperties;
                private final AtomicInteger tasksInQueue;
                private final ReadWriteProperty active$delegate;
                final /* synthetic */ Executor $executor;

                static {
                    $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(asRdScheduler.1.class, "active", "getActive()I", 0))};
                }

                private final int getActive() {
                    return ((Number)this.active$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
                }

                private final void setActive(int n) {
                    this.active$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
                }

                public boolean isActive() {
                    return this.getActive() > 0;
                }

                public void queue(@NotNull Function0<Unit> action) {
                    Intrinsics.checkNotNullParameter(action, (String)"action");
                    this.tasksInQueue.incrementAndGet();
                    this.$executor.execute(new Runnable(this, action){
                        final /* synthetic */ asRdScheduler.1 this$0;
                        final /* synthetic */ Function0 $action;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void run() {
                            asRdScheduler.1 v0 = this.this$0;
                            int n = asRdScheduler.1.access$getActive$p(v0);
                            asRdScheduler.1.access$setActive$p(v0, n + 1);
                            try {
                                this.$action.invoke();
                            }
                            catch (Throwable e) {
                                LoggerKt.error((Logger)Logger.Companion.getRoot(), e);
                            }
                            finally {
                                asRdScheduler.1 v1 = this.this$0;
                                n = asRdScheduler.1.access$getActive$p(v1);
                                asRdScheduler.1.access$setActive$p(v1, n + -1);
                                asRdScheduler.1.access$getTasksInQueue$p(this.this$0).decrementAndGet();
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$action = function0;
                        }
                    });
                }

                public void flush() {
                    boolean bl = !this.isActive();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    if (!bl) {
                        boolean bl4 = false;
                        String string = "Can't flush this scheduler in a reentrant way: we are inside queued item's execution";
                        throw (Throwable)new IllegalArgumentException(string.toString());
                    }
                    boolean $i$f$spinUntil = false;
                    SpinWait.Companion this_$iv$iv = SpinWait.Companion;
                    boolean $i$f$spinUntil2 = false;
                    long spins$iv$iv = 0L;
                    while (true) {
                        boolean bl5 = false;
                        if (this.tasksInQueue.get() == 0) break;
                        long l = spins$iv$iv;
                        spins$iv$iv = l + 1L;
                        if (l < (long)100) {
                            Thread.yield();
                            continue;
                        }
                        Thread.sleep(spins$iv$iv / (long)100);
                    }
                }
                {
                    this.$executor = $captured_local_variable$0;
                    this.tasksInQueue = new AtomicInteger();
                    this.active$delegate = ReflectionUtilKt.threadLocal(asRdScheduler.active.2.INSTANCE);
                }

                public void assertThread(@Nullable Object debugInfo) {
                    IScheduler.DefaultImpls.assertThread(this, debugInfo);
                }

                public boolean getOutOfOrderExecution() {
                    return IScheduler.DefaultImpls.getOutOfOrderExecution(this);
                }

                public void invokeOrQueue(@NotNull Function0<Unit> action) {
                    Intrinsics.checkNotNullParameter(action, (String)"action");
                    IScheduler.DefaultImpls.invokeOrQueue(this, action);
                }

                public static final /* synthetic */ int access$getActive$p(asRdScheduler.1 $this) {
                    return $this.getActive();
                }

                public static final /* synthetic */ void access$setActive$p(asRdScheduler.1 $this, int n) {
                    $this.setActive(n);
                }

                public static final /* synthetic */ AtomicInteger access$getTasksInQueue$p(asRdScheduler.1 $this) {
                    return $this.tasksInQueue;
                }
            };
        }
        return iScheduler;
    }

    @NotNull
    public static final IScheduler getAsRdScheduler(@NotNull CoroutineDispatcher $this$asRdScheduler) {
        IScheduler iScheduler;
        Intrinsics.checkNotNullParameter((Object)$this$asRdScheduler, (String)"$this$asRdScheduler");
        CoroutineDispatcher coroutineDispatcher = $this$asRdScheduler;
        if (!(coroutineDispatcher instanceof IScheduler)) {
            coroutineDispatcher = null;
        }
        if ((iScheduler = (IScheduler)coroutineDispatcher) == null) {
            iScheduler = SchedulerUtilKt.getAsRdScheduler(ExecutorsKt.asExecutor((CoroutineDispatcher)$this$asRdScheduler));
        }
        return iScheduler;
    }
}

