/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit5;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.NestedClassSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TagFilter;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;

public class JUnit5TestRunnerUtil {
    private static final String[] DISABLED_ANNO = new String[]{"org.junit.jupiter.api.Disabled"};
    private static final String[] DISABLED_COND_ANNO = new String[]{"org.junit.jupiter.api.condition.DisabledOnJre", "org.junit.jupiter.api.condition.DisabledIfEnvironmentVariable", "org.junit.jupiter.api.condition.DisabledIfSystemProperty", "org.junit.jupiter.api.condition.DisabledOnOs"};
    private static final String[] SCRIPT_COND_ANNO = new String[]{"org.junit.jupiter.api.condition.DisabledIf", "org.junit.jupiter.api.condition.EnabledIf"};
    private static final String[] ENABLED_COND_ANNO = new String[]{"org.junit.jupiter.api.condition.EnabledOnJre", "org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable", "org.junit.jupiter.api.condition.EnabledIfSystemProperty", "org.junit.jupiter.api.condition.EnabledOnOs"};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LauncherDiscoveryRequest buildRequest(String[] suiteClassNames, String[] packageNameRef) {
        DiscoverySelector selector;
        if (suiteClassNames.length == 0) {
            return null;
        }
        LauncherDiscoveryRequestBuilder builder = LauncherDiscoveryRequestBuilder.request();
        if (suiteClassNames.length == 1 && suiteClassNames[0].charAt(0) == '@') {
            try (BufferedReader reader = new BufferedReader(new FileReader(suiteClassNames[0].substring(1)));){
                String line;
                String packageName222 = reader.readLine();
                if (packageName222 == null) {
                    LauncherDiscoveryRequest launcherDiscoveryRequest = null;
                    return launcherDiscoveryRequest;
                }
                String tags222 = reader.readLine();
                String filters = reader.readLine();
                ArrayList<DiscoverySelector> selectors = new ArrayList<DiscoverySelector>();
                while ((line = reader.readLine()) != null) {
                    DiscoverySelector selector2 = JUnit5TestRunnerUtil.createSelector(line, null);
                    if (selector2 == null) continue;
                    selectors.add(selector2);
                }
                if (JUnit5TestRunnerUtil.hasBrokenSelector(selectors)) {
                    builder.filters(new Filter[]{JUnit5TestRunnerUtil.createMethodFilter(new ArrayList<DiscoverySelector>(selectors))});
                    for (int i = 0; i < selectors.size(); ++i) {
                        DiscoverySelector selector3 = (DiscoverySelector)selectors.get(i);
                        if (!(selector3 instanceof MethodSelector)) continue;
                        selectors.set(i, JUnit5TestRunnerUtil.createClassSelector(((MethodSelector)selector3).getClassName()));
                    }
                }
                String string = packageNameRef[0] = packageName222.length() == 0 ? "<default package>" : packageName222;
                if (selectors.isEmpty()) {
                    builder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectPackage((String)packageName222)});
                } else {
                    builder.selectors(selectors);
                    if (!packageName222.isEmpty()) {
                        builder.filters(new Filter[]{PackageNameFilter.includePackageNames((String[])new String[]{packageName222})});
                    }
                }
                if (filters != null && !filters.isEmpty()) {
                    String[] classNames;
                    for (String className : classNames = filters.split("\\|\\|")) {
                        if (className.contains("*")) continue;
                        try {
                            Class.forName(className, false, JUnit5TestRunnerUtil.class.getClassLoader());
                        }
                        catch (ClassNotFoundException e) {
                            System.err.println(MessageFormat.format(ResourceBundle.getBundle("messages.RuntimeBundle").getString("junit.class.not.found"), className));
                        }
                    }
                    builder.filters(new Filter[]{ClassNameFilter.includeClassNamePatterns((String[])classNames)});
                }
                if (tags222 != null && !tags222.isEmpty()) {
                    builder.filters(new Filter[]{TagFilter.includeTags((String[])tags222.split(" "))});
                }
                LauncherDiscoveryRequest launcherDiscoveryRequest = builder.filters(new Filter[]{ClassNameFilter.excludeClassNamePatterns((String[])new String[]{"com\\.intellij\\.rt.*", "com\\.intellij\\.junit3.*"})}).build();
                return launcherDiscoveryRequest;
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
                return null;
            }
        }
        String disableDisabledCondition = JUnit5TestRunnerUtil.getDisabledConditionValue(suiteClassNames[0]);
        if (disableDisabledCondition != null) {
            builder = builder.configurationParameter("junit.jupiter.conditions.deactivate", disableDisabledCondition);
        }
        if ((selector = JUnit5TestRunnerUtil.createSelector(suiteClassNames[0], packageNameRef)) instanceof MethodSelector && !JUnit5TestRunnerUtil.loadMethodByReflection((MethodSelector)selector)) {
            DiscoverySelector classSelector = JUnit5TestRunnerUtil.createClassSelector(((MethodSelector)selector).getClassName());
            DiscoverySelector methodSelector = classSelector instanceof NestedClassSelector ? DiscoverySelectors.selectMethod((String)((NestedClassSelector)classSelector).getNestedClassName(), (String)((MethodSelector)selector).getMethodName()) : selector;
            builder.filters(new Filter[]{JUnit5TestRunnerUtil.createMethodFilter(Collections.singletonList(methodSelector))});
            selector = classSelector;
        }
        assert (selector != null) : "selector by class name is never null";
        return builder.selectors(new DiscoverySelector[]{selector}).build();
    }

    private static boolean loadMethodByReflection(MethodSelector selector) {
        try {
            Class<?> aClass = Class.forName(selector.getClassName());
            return ReflectionSupport.findMethod(aClass, (String)selector.getMethodName(), (String)selector.getMethodParameterTypes()).isPresent();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean hasBrokenSelector(List<DiscoverySelector> selectors) {
        for (DiscoverySelector selector : selectors) {
            if (!(selector instanceof MethodSelector) || JUnit5TestRunnerUtil.loadMethodByReflection((MethodSelector)selector)) continue;
            return true;
        }
        return false;
    }

    private static PostDiscoveryFilter createMethodFilter(final List<DiscoverySelector> selectors) {
        return new PostDiscoveryFilter(){

            public FilterResult apply(TestDescriptor descriptor) {
                return FilterResult.includedIf((boolean)this.shouldRun(descriptor), () -> descriptor.getDisplayName() + " matches", () -> descriptor.getDisplayName() + " doesn't match");
            }

            private boolean shouldRun(TestDescriptor descriptor) {
                TestSource source = descriptor.getSource().orElse(null);
                if (source instanceof MethodSource) {
                    for (DiscoverySelector selector : selectors) {
                        if (!(selector instanceof MethodSelector) || !((MethodSelector)selector).getMethodName().equals(((MethodSource)source).getMethodName()) || !((MethodSelector)selector).getClassName().equals(((MethodSource)source).getClassName()) && !this.inNestedClass((MethodSource)source, JUnit5TestRunnerUtil.createClassSelector(((MethodSelector)selector).getClassName()))) continue;
                        return true;
                    }
                    for (DiscoverySelector selector : selectors) {
                        if ((!(selector instanceof ClassSelector) || !((ClassSelector)selector).getClassName().equals(((MethodSource)source).getClassName())) && !this.inNestedClass((MethodSource)source, selector)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }

            private boolean inNestedClass(MethodSource source, DiscoverySelector selector) {
                return selector instanceof NestedClassSelector && ((NestedClassSelector)selector).getNestedClassName().equals(source.getClassName());
            }
        };
    }

    public static String getDisabledConditionValue(String name) {
        int commaIdx = name.indexOf(",");
        String className = name.substring(0, commaIdx < 0 ? name.length() : commaIdx);
        String methodName = commaIdx > 0 ? name.substring(commaIdx + 1) : null;
        try {
            ClassLoader loader = JUnit5TestRunnerUtil.class.getClassLoader();
            Class<?> testClass = Class.forName(className, false, loader);
            String disabledCondition = JUnit5TestRunnerUtil.getDisabledCondition(loader, testClass);
            if (disabledCondition != null) {
                return disabledCondition;
            }
            if (methodName != null) {
                Method m;
                int paramIdx = methodName.indexOf("(");
                if (paramIdx < 0) {
                    m = testClass.getDeclaredMethod(methodName, new Class[0]);
                } else {
                    if (!methodName.endsWith(")")) {
                        return null;
                    }
                    String paramsString = methodName.substring(paramIdx + 1, methodName.length() - 1);
                    String[] params = paramsString.split(",");
                    Class[] paramTypes = new Class[params.length];
                    for (int i = 0; i < params.length; ++i) {
                        paramTypes[i] = Class.forName(params[i], false, loader);
                    }
                    m = testClass.getDeclaredMethod(methodName.substring(0, paramIdx), paramTypes);
                }
                disabledCondition = JUnit5TestRunnerUtil.getDisabledCondition(loader, m);
                if (disabledCondition != null) {
                    return disabledCondition;
                }
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static String getDisabledCondition(ClassLoader loader, AnnotatedElement annotatedElement) {
        if (JUnit5TestRunnerUtil.isDisabledCondition(DISABLED_COND_ANNO, loader, annotatedElement)) {
            return "org.junit.*Disabled*Condition";
        }
        if (JUnit5TestRunnerUtil.isDisabledCondition(ENABLED_COND_ANNO, loader, annotatedElement)) {
            return "org.junit.*Enabled*Condition";
        }
        if (JUnit5TestRunnerUtil.isDisabledCondition(SCRIPT_COND_ANNO, loader, annotatedElement)) {
            return "org.junit.*DisabledIfCondition";
        }
        if (JUnit5TestRunnerUtil.isDisabledCondition(DISABLED_ANNO, loader, annotatedElement)) {
            return "org.junit.*DisabledCondition";
        }
        return null;
    }

    private static boolean isDisabledCondition(String[] anno, ClassLoader loader, AnnotatedElement annotatedElement) {
        for (String disabledAnnotationName : anno) {
            try {
                Class<?> disabledAnnotation = Class.forName(disabledAnnotationName, false, loader);
                if (!AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, disabledAnnotation).isPresent()) continue;
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    protected static DiscoverySelector createSelector(String line, String[] packageNameRef) {
        if (line.startsWith("\u001b")) {
            String uniqueId = line.substring("\u001b".length());
            return DiscoverySelectors.selectUniqueId((String)uniqueId);
        }
        if (line.startsWith("+")) {
            String directory = line.substring("+".length());
            List selectors = DiscoverySelectors.selectClasspathRoots(Collections.singleton(Paths.get(directory, new String[0])));
            if (selectors.isEmpty()) {
                return null;
            }
            return (DiscoverySelector)selectors.iterator().next();
        }
        if (line.contains(",")) {
            MethodSelector selector = DiscoverySelectors.selectMethod((String)line.replaceFirst(",", "#"));
            if (packageNameRef != null) {
                packageNameRef[0] = selector.getClassName();
            }
            return selector;
        }
        if (packageNameRef != null) {
            packageNameRef[0] = line;
        }
        return JUnit5TestRunnerUtil.createClassSelector(line);
    }

    private static DiscoverySelector createClassSelector(String line) {
        int nestedClassIdx = line.lastIndexOf("$");
        if (nestedClassIdx > 0) {
            AtomicReference nestedClassSelector = new AtomicReference();
            ReflectionUtils.tryToLoadClass((String)line).ifFailure(__ -> nestedClassSelector.set(JUnit5TestRunnerUtil.getNestedSelector(line, nestedClassIdx)));
            if (nestedClassSelector.get() != null) {
                return (DiscoverySelector)nestedClassSelector.get();
            }
        }
        return DiscoverySelectors.selectClass((String)line);
    }

    private static NestedClassSelector getNestedSelector(String line, int nestedClassIdx) {
        String enclosingClass = line.substring(0, nestedClassIdx);
        String nestedClassName = line.substring(nestedClassIdx + 1);
        DiscoverySelector enclosingClassSelector = JUnit5TestRunnerUtil.createClassSelector(enclosingClass);
        Class klass = enclosingClassSelector instanceof NestedClassSelector ? ((NestedClassSelector)enclosingClassSelector).getNestedClass() : ((ClassSelector)enclosingClassSelector).getJavaClass();
        for (Class superclass = klass.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            for (Class<?> nested : superclass.getDeclaredClasses()) {
                List<Class> enclosingClasses;
                if (!nested.getSimpleName().equals(nestedClassName)) continue;
                if (enclosingClassSelector instanceof NestedClassSelector) {
                    enclosingClasses = new ArrayList<Class>(((NestedClassSelector)enclosingClassSelector).getEnclosingClasses());
                    enclosingClasses.add(klass);
                } else {
                    enclosingClasses = Collections.singletonList(klass);
                }
                return DiscoverySelectors.selectNestedClass(enclosingClasses, nested);
            }
        }
        return null;
    }
}

