/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.psi.impl;

import com.intellij.debugger.streams.psi.ChainDetector;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0012\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\u000e\u001a\u00020\u0006*\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/debugger/streams/psi/impl/InheritanceBasedChainDetector;", "Lcom/intellij/debugger/streams/psi/ChainDetector;", "baseClassName", "", "(Ljava/lang/String;)V", "isIntermediateCall", "", "callExpression", "Lcom/intellij/psi/PsiMethodCallExpression;", "isStreamType", "type", "Lcom/intellij/psi/PsiClass;", "Lcom/intellij/psi/PsiType;", "isTerminationCall", "isStatic", "Lcom/intellij/psi/PsiMethod;", "intellij.java.debugger.streams"})
public final class InheritanceBasedChainDetector
implements ChainDetector {
    private final String baseClassName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isTerminationCall(@NotNull PsiMethodCallExpression callExpression) {
        PsiType qualifierType;
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        PsiMethod psiMethod = callExpression.resolveMethod();
        if (psiMethod == null) return false;
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"callExpression.resolveMethod() ?: return false");
        PsiMethod method = psiMethod;
        PsiReferenceExpression psiReferenceExpression = callExpression.getMethodExpression();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceExpression, (String)"callExpression.methodExpression");
        PsiExpression psiExpression = psiReferenceExpression.getQualifierExpression();
        Object object = qualifierType = psiExpression != null ? psiExpression.getType() : null;
        if (!this.isStreamType(qualifierType)) {
            PsiElement psiElement = method.getParent();
            if (!(psiElement instanceof PsiClass)) {
                psiElement = null;
            }
            if (!this.isStreamType((PsiClass)psiElement)) return false;
        }
        if (this.isStreamType(method.getReturnType())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isIntermediateCall(@NotNull PsiMethodCallExpression callExpression) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        PsiMethod psiMethod = callExpression.resolveMethod();
        if (psiMethod == null) return false;
        Intrinsics.checkNotNullExpressionValue((Object)psiMethod, (String)"callExpression.resolveMethod() ?: return false");
        PsiMethod method = psiMethod;
        if (this.isStatic(method)) return false;
        PsiElement psiElement = method.getParent();
        if (!(psiElement instanceof PsiClass)) {
            psiElement = null;
        }
        if (!this.isStreamType((PsiClass)psiElement)) return false;
        PsiMethod psiMethod2 = callExpression.resolveMethod();
        if (!this.isStreamType((PsiType)(psiMethod2 != null ? psiMethod2.getReturnType() : null))) return false;
        return true;
    }

    private final boolean isStreamType(PsiType type) {
        return InheritanceUtil.isInheritor((PsiType)type, (String)this.baseClassName);
    }

    private final boolean isStreamType(PsiClass type) {
        return InheritanceUtil.isInheritor((PsiClass)type, (String)this.baseClassName);
    }

    private final boolean isStatic(PsiMethod $this$isStatic) {
        return $this$isStatic.hasModifier(JvmModifier.STATIC);
    }

    public InheritanceBasedChainDetector(@NotNull String baseClassName) {
        Intrinsics.checkNotNullParameter((Object)baseClassName, (String)"baseClassName");
        this.baseClassName = baseClassName;
    }

    @Override
    public boolean isStreamCall(@NotNull PsiMethodCallExpression callExpression) {
        Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
        return ChainDetector.DefaultImpls.isStreamCall(this, callExpression);
    }
}

