/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J$\u0010\u0007\u001a\u00020\u000e*\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmInconsistentOperatorFromJavaCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "()V", "CONCURRENT_HASH_MAP_CALLABLE_ID", "Lorg/jetbrains/kotlin/name/CallableId;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkers.jvm"})
public final class FirJvmInconsistentOperatorFromJavaCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirJvmInconsistentOperatorFromJavaCallChecker INSTANCE = new FirJvmInconsistentOperatorFromJavaCallChecker();
    @NotNull
    private static final CallableId CONCURRENT_HASH_MAP_CALLABLE_ID;

    private FirJvmInconsistentOperatorFromJavaCallChecker() {
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirCallableSymbol<?> firCallableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(expression2.getCalleeReference());
        FirNamedFunctionSymbol firNamedFunctionSymbol = firCallableSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firCallableSymbol : null;
        if (firNamedFunctionSymbol == null) {
            return;
        }
        FirNamedFunctionSymbol callableSymbol = firNamedFunctionSymbol;
        if (!Intrinsics.areEqual(callableSymbol.getName(), OperatorNameConventions.CONTAINS)) {
            return;
        }
        FirValueParameterSymbol firValueParameterSymbol = CollectionsKt.singleOrNull(callableSymbol.getValueParameterSymbols());
        if (firValueParameterSymbol == null) {
            return;
        }
        FirValueParameterSymbol valueParameterSymbol = firValueParameterSymbol;
        ConeSimpleKotlinType type2 = ConeTypeUtilsKt.lowerBoundIfFlexible(FirTypeUtilsKt.getConeType(valueParameterSymbol.getResolvedReturnTypeRef()));
        if (!ConeBuiltinTypeUtilsKt.isAny(type2) && !ConeBuiltinTypeUtilsKt.isNullableAny(type2)) {
            return;
        }
        if (expression2.getOrigin() != FirFunctionCallOrigin.Operator || expression2.getOrigin().ordinal() != 2) {
            return;
        }
        this.check(callableSymbol, expression2.getCalleeReference().getSource(), context, reporter);
    }

    public final boolean check(@NotNull FirNamedFunctionSymbol $this$check, @Nullable KtSourceElement source, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter($this$check, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (Intrinsics.areEqual($this$check.getCallableId(), CONCURRENT_HASH_MAP_CALLABLE_ID)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirJvmErrors.INSTANCE.getCONCURRENT_HASH_MAP_CONTAINS_OPERATOR(), (DiagnosticContext)context, null, 8, null);
            return true;
        }
        Object object = ClassMembersKt.containingClass($this$check);
        if (object == null || (object = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)object, context.getSession())) == null) {
            return false;
        }
        Object containingClass = object;
        List<FirFunctionSymbol<?>> overriddenFunctions2 = FirHelpersKt.overriddenFunctions($this$check, (FirClassSymbol)containingClass, context);
        for (FirFunctionSymbol<?> overriddenFunction : overriddenFunctions2) {
            if (!(overriddenFunction instanceof FirNamedFunctionSymbol) || !this.check((FirNamedFunctionSymbol)overriddenFunction, source, context, reporter)) continue;
            return true;
        }
        return false;
    }

    static {
        ClassId classId = ClassId.fromString("java/util/concurrent/ConcurrentHashMap");
        Intrinsics.checkNotNullExpressionValue(classId, "fromString(\"java/util/co\u2026rrent/ConcurrentHashMap\")");
        Name name = Name.identifier("contains");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(\"contains\")");
        CONCURRENT_HASH_MAP_CALLABLE_ID = new CallableId(classId, name);
    }
}

