/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.lower;

import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.interpreter.IrTreeBuildUtilsKt;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/lower/BuiltInsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "irBuiltins", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "symbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "transformCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "builder", "Lorg/jetbrains/kotlin/backend/common/lower/DeclarationIrBuilder;", "findEqualsMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "backend.wasm"})
public final class BuiltInsLowering
implements FileLoweringPass {
    @NotNull
    private final WasmBackendContext context;
    @NotNull
    private final IrBuiltIns irBuiltins;
    @NotNull
    private final WasmSymbols symbols;

    public BuiltInsLowering(@NotNull WasmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.irBuiltins = this.context.getIrBuiltIns();
        this.symbols = this.context.getWasmSymbols();
    }

    @NotNull
    public final WasmBackendContext getContext() {
        return this.context;
    }

    private final IrSimpleFunction findEqualsMethod(IrType $this$findEqualsMethod) {
        IrClass irClass = IrTypesKt.getClass((IrType)$this$findEqualsMethod);
        if (irClass == null) {
            irClass = (IrClass)this.irBuiltins.getAnyClass().getOwner();
        }
        IrClass klass = irClass;
        Sequence $this$single$iv = IrUtilsKt.getFunctions((IrClass)klass);
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!MiscKt.isEqualsInheritedFromAny((IrFunction)it)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        return single$iv;
    }

    @NotNull
    public final IrExpression transformCall(@NotNull IrCall call2, @NotNull DeclarationIrBuilder builder2) {
        IrSimpleFunctionSymbol symbol2;
        block32: {
            block34: {
                block33: {
                    block29: {
                        block31: {
                            block30: {
                                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                                Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
                                symbol2 = call2.getSymbol();
                                if (!Intrinsics.areEqual((Object)symbol2, this.irBuiltins.getIeee754equalsFunByOperandType().get(this.irBuiltins.getFloatClass()))) break block29;
                                IrExpression irExpression = call2.getValueArgument(0);
                                Intrinsics.checkNotNull((Object)irExpression);
                                if (IrTypeUtilsKt.isNullable((IrType)irExpression.getType())) break block30;
                                IrExpression irExpression2 = call2.getValueArgument(1);
                                Intrinsics.checkNotNull((Object)irExpression2);
                                if (!IrTypeUtilsKt.isNullable((IrType)irExpression2.getType())) break block31;
                            }
                            return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call2), (IrSimpleFunctionSymbol)this.symbols.getNullableFloatIeee754Equals(), (boolean)false, (boolean)false, null, null, (int)60, null);
                        }
                        return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call2), (IrSimpleFunctionSymbol)((IrSimpleFunctionSymbol)MapsKt.getValue(this.symbols.getFloatEqualityFunctions(), (Object)this.irBuiltins.getFloatType())), (boolean)false, (boolean)false, null, null, (int)60, null);
                    }
                    if (!Intrinsics.areEqual((Object)symbol2, this.irBuiltins.getIeee754equalsFunByOperandType().get(this.irBuiltins.getDoubleClass()))) break block32;
                    IrExpression irExpression = call2.getValueArgument(0);
                    Intrinsics.checkNotNull((Object)irExpression);
                    if (IrTypeUtilsKt.isNullable((IrType)irExpression.getType())) break block33;
                    IrExpression irExpression3 = call2.getValueArgument(1);
                    Intrinsics.checkNotNull((Object)irExpression3);
                    if (!IrTypeUtilsKt.isNullable((IrType)irExpression3.getType())) break block34;
                }
                return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call2), (IrSimpleFunctionSymbol)this.symbols.getNullableDoubleIeee754Equals(), (boolean)false, (boolean)false, null, null, (int)60, null);
            }
            return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call2), (IrSimpleFunctionSymbol)((IrSimpleFunctionSymbol)MapsKt.getValue(this.symbols.getFloatEqualityFunctions(), (Object)this.irBuiltins.getDoubleType())), (boolean)false, (boolean)false, null, null, (int)60, null);
        }
        if (Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getEqeqSymbol())) {
            IrSimpleFunctionSymbol newSymbol;
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            IrExpression lhs = irExpression;
            IrExpression irExpression4 = call2.getValueArgument(1);
            Intrinsics.checkNotNull((Object)irExpression4);
            IrExpression rhs = irExpression4;
            IrType lhsType = lhs.getType();
            IrType rhsType = rhs.getType();
            if (Intrinsics.areEqual((Object)lhsType, (Object)rhsType) && (newSymbol = this.symbols.getEqualityFunctions().get(lhsType)) != null) {
                return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call2), (IrSimpleFunctionSymbol)newSymbol, (boolean)false, (boolean)false, null, null, (int)60, null);
            }
            if (IrUtilsKt.isNullConst((IrExpression)lhs)) {
                IrSimpleFunctionSymbol $this$transformCall_u24lambda_u2d1 = newSymbol = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)builder2), (IrSimpleFunctionSymbol)this.symbols.getRefIsNull());
                boolean bl = false;
                $this$transformCall_u24lambda_u2d1.putValueArgument(0, rhs);
                return (IrExpression)newSymbol;
            }
            if (IrUtilsKt.isNullConst((IrExpression)rhs)) {
                IrSimpleFunctionSymbol $this$transformCall_u24lambda_u2d2 = newSymbol = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)builder2), (IrSimpleFunctionSymbol)this.symbols.getRefIsNull());
                boolean bl = false;
                $this$transformCall_u24lambda_u2d2.putValueArgument(0, lhs);
                return (IrExpression)newSymbol;
            }
            if (!IrTypeUtilsKt.isNullable((IrType)lhsType)) {
                return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call2), (IrSimpleFunctionSymbol)this.findEqualsMethod(lhsType).getSymbol(), (boolean)false, (boolean)true, null, null, (int)52, null);
            }
            return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call2), (IrSimpleFunctionSymbol)this.symbols.getNullableEquals(), (boolean)false, (boolean)false, null, null, (int)60, null);
        }
        if (Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getEqeqeqSymbol())) {
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            IrType type2 = irExpression.getType();
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.symbols.getEqualityFunctions().get(type2);
            if (irSimpleFunctionSymbol == null && (irSimpleFunctionSymbol = this.symbols.getFloatEqualityFunctions().get(type2)) == null) {
                irSimpleFunctionSymbol = this.symbols.getRefEq();
            }
            IrSimpleFunctionSymbol newSymbol = irSimpleFunctionSymbol;
            return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call2), (IrSimpleFunctionSymbol)newSymbol, (boolean)false, (boolean)false, null, null, (int)60, null);
        }
        if (Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getCheckNotNullSymbol())) {
            IrCall type2;
            BuiltInsLowering $this$transformCall_u24lambda_u2d3 = this;
            boolean bl = false;
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            IrExpression arg = irExpression;
            if (IrUtilsKt.isNullConst((IrExpression)arg)) {
                return (IrExpression)ExpressionHelpersKt.irCall$default((IrBuilderWithScope)((IrBuilderWithScope)builder2), (IrSimpleFunctionSymbol)$this$transformCall_u24lambda_u2d3.symbols.getWasmUnreachable(), (IrType)$this$transformCall_u24lambda_u2d3.irBuiltins.getNothingType(), (int)0, (int)0, null, (int)28, null);
            }
            IrCall it = type2 = IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call2), (IrSimpleFunctionSymbol)this.symbols.getEnsureNotNull(), (boolean)false, (boolean)false, null, null, (int)60, null);
            boolean bl2 = false;
            it.putTypeArgument(0, call2.getType());
            return (IrExpression)type2;
        }
        if (this.symbols.getComparisonBuiltInsToWasmIntrinsics().keySet().contains(symbol2)) {
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.symbols.getComparisonBuiltInsToWasmIntrinsics().get(symbol2);
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
            IrSimpleFunctionSymbol newSymbol = irSimpleFunctionSymbol;
            return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call2), (IrSimpleFunctionSymbol)newSymbol, (boolean)false, (boolean)false, null, null, (int)60, null);
        }
        if (Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getNoWhenBranchMatchedExceptionSymbol())) {
            return (IrExpression)ExpressionHelpersKt.irCall$default((IrBuilderWithScope)((IrBuilderWithScope)builder2), (IrSimpleFunctionSymbol)this.symbols.getThrowNoBranchMatchedException(), (IrType)this.irBuiltins.getNothingType(), (int)0, (int)0, null, (int)28, null);
        }
        if (Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getIllegalArgumentExceptionSymbol())) {
            IrCall newSymbol;
            IrCall $this$transformCall_u24lambda_u2d5 = newSymbol = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)((IrBuilderWithScope)builder2), (IrSimpleFunctionSymbol)this.symbols.getThrowIAE(), (IrType)this.irBuiltins.getNothingType(), (int)1, (int)0, null, (int)24, null);
            boolean bl = false;
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            $this$transformCall_u24lambda_u2d5.putValueArgument(0, irExpression);
            return (IrExpression)newSymbol;
        }
        if (Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getDataClassArrayMemberHashCodeSymbol()) ? true : Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getDataClassArrayMemberToStringSymbol())) {
            IrCall newSymbol;
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            IrExpression argument2 = irExpression;
            IrType argumentType = argument2.getType();
            IrSimpleFunctionSymbol overloadSymbol = null;
            IrType returnType = null;
            if (Intrinsics.areEqual((Object)symbol2, (Object)this.irBuiltins.getDataClassArrayMemberHashCodeSymbol())) {
                overloadSymbol = this.symbols.findContentHashCodeOverload(argumentType);
                returnType = this.irBuiltins.getIntType();
            } else {
                overloadSymbol = this.symbols.findContentToStringOverload(argumentType);
                returnType = this.irBuiltins.getStringType();
            }
            IrCall $this$transformCall_u24lambda_u2d6 = newSymbol = ExpressionHelpersKt.irCall$default((IrBuilderWithScope)((IrBuilderWithScope)builder2), (IrSimpleFunctionSymbol)overloadSymbol, (IrType)returnType, (int)0, (int)0, null, (int)28, null);
            boolean bl = false;
            $this$transformCall_u24lambda_u2d6.setExtensionReceiver(argument2);
            if (Intrinsics.areEqual((Object)IrTypesKt.getClassOrNull((IrType)argumentType), (Object)this.irBuiltins.getArrayClass())) {
                $this$transformCall_u24lambda_u2d6.putTypeArgument(0, IrTypeUtilsKt.getArrayElementType((IrType)argumentType, (IrBuiltIns)this.irBuiltins));
            }
            return (IrExpression)newSymbol;
        }
        if (this.symbols.getStartCoroutineUninterceptedOrReturnIntrinsics().contains(symbol2)) {
            int arity = this.symbols.getStartCoroutineUninterceptedOrReturnIntrinsics().indexOf(symbol2);
            IrSimpleFunctionSymbol irSimpleFunctionSymbol = AdditionalIrUtilsKt.getSimpleFunction((IrClass)this.irBuiltins.suspendFunctionN(arity), (String)"invoke");
            Intrinsics.checkNotNull((Object)irSimpleFunctionSymbol);
            IrSimpleFunctionSymbol newSymbol = irSimpleFunctionSymbol;
            return (IrExpression)IrUtilsKt.irCall$default((IrFunctionAccessExpression)((IrFunctionAccessExpression)call2), (IrSimpleFunctionSymbol)newSymbol, (boolean)false, (boolean)true, null, null, (int)52, null);
        }
        if (Intrinsics.areEqual((Object)symbol2, (Object)this.symbols.getReflectionSymbols$backend_wasm().getGetClassData())) {
            IrCall irCall;
            String string2;
            IrConstructorSymbol infoDataCtor = (IrConstructorSymbol)SequencesKt.first((Sequence)IrUtilsKt.getConstructors((IrClassSymbol)this.symbols.getReflectionSymbols$backend_wasm().getWasmTypeInfoData()));
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrType type3 = irType;
            boolean isInterface = org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isInterface((IrType)type3);
            FqName fqName2 = IrTypesKt.getClassFqName((IrType)type3);
            Intrinsics.checkNotNull((Object)fqName2);
            FqName fqName3 = fqName2;
            boolean fqnShouldBeEmitted = (Boolean)CommonConfigurationKeysKt.getLanguageVersionSettings(this.context.getConfiguration()).getFlag(AnalysisFlags.getAllowFullyQualifiedNameInKClass());
            if (fqnShouldBeEmitted) {
                string2 = FqNamesUtilKt.parentOrNull((FqName)fqName3);
                if (string2 == null || (string2 = string2.asString()) == null) {
                    string2 = "";
                }
            } else {
                string2 = "";
            }
            String packageName = string2;
            String string3 = fqName3.shortName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"fqName.shortName().asString()");
            String typeName = string3;
            DeclarationIrBuilder $this$transformCall_u24lambda_u2d9 = builder2;
            boolean bl = false;
            IrSimpleFunctionSymbol wasmIdGetter = org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isInterface((IrType)type3) ? this.symbols.getWasmInterfaceId() : this.symbols.getWasmClassId();
            IrCall it = irCall = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$transformCall_u24lambda_u2d9), (IrSimpleFunctionSymbol)wasmIdGetter);
            boolean bl3 = false;
            it.putTypeArgument(0, type3);
            IrCall typeId = irCall;
            it = irCall = ExpressionHelpersKt.irCallConstructor((IrBuilderWithScope)((IrBuilderWithScope)$this$transformCall_u24lambda_u2d9), (IrConstructorSymbol)infoDataCtor, (List)CollectionsKt.emptyList());
            boolean bl4 = false;
            it.putValueArgument(0, (IrExpression)typeId);
            it.putValueArgument(1, (IrExpression)IrTreeBuildUtilsKt.toIrConst$default((Object)isInterface, (IrType)$this$transformCall_u24lambda_u2d9.getContext().getIrBuiltIns().getBooleanType(), (int)0, (int)0, (int)6, null));
            it.putValueArgument(2, (IrExpression)IrTreeBuildUtilsKt.toIrConst$default((Object)packageName, (IrType)$this$transformCall_u24lambda_u2d9.getContext().getIrBuiltIns().getStringType(), (int)0, (int)0, (int)6, null));
            it.putValueArgument(3, (IrExpression)IrTreeBuildUtilsKt.toIrConst$default((Object)typeName, (IrType)$this$transformCall_u24lambda_u2d9.getContext().getIrBuiltIns().getStringType(), (int)0, (int)0, (int)6, null));
            return (IrExpression)irCall;
        }
        return (IrExpression)call2;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.context), (IrSymbol)((IrSymbol)irFile.getSymbol()), (int)0, (int)0, (int)6, null);
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irFile), (IrElementTransformerVoid)((IrElementTransformerVoid)new IrElementTransformerVoidWithContext(this, builder2){
            final /* synthetic */ BuiltInsLowering this$0;
            final /* synthetic */ DeclarationIrBuilder $builder;
            {
                this.this$0 = $receiver;
                this.$builder = $builder;
            }

            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression newExpression = this.this$0.transformCall(expression2, this.$builder);
                IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)newExpression), (IrElementTransformerVoid)((IrElementTransformerVoid)this));
                return newExpression;
            }
        }));
    }
}

