/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.FunctionWithJsFuncAnnotationInliner;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsCodeKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContextKt;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsCompositeBlock;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsMultiLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsSingleLineComment;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsCallTransformer;", "", "jsOrJsFuncCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;)V", "statements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "generateExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "generateStatement", "getJsStatements", "backend.js"})
public final class JsCallTransformer {
    @NotNull
    private final IrCall jsOrJsFuncCall;
    @NotNull
    private final JsGenerationContext context;
    @NotNull
    private final List<JsStatement> statements;

    public JsCallTransformer(@NotNull IrCall jsOrJsFuncCall, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)jsOrJsFuncCall, (String)"jsOrJsFuncCall");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.jsOrJsFuncCall = jsOrJsFuncCall;
        this.context = context;
        this.statements = this.getJsStatements();
    }

    @NotNull
    public final JsStatement generateStatement() {
        JsStatement jsStatement;
        JsExpression jsExpression;
        List list2;
        if (this.statements.isEmpty()) {
            return JsEmpty.INSTANCE;
        }
        List $this$generateStatement_u24lambda_u2d0 = list2 = CollectionsKt.toMutableList((Collection)this.statements);
        boolean bl = false;
        Object object = CollectionsKt.last((List)$this$generateStatement_u24lambda_u2d0);
        JsReturn jsReturn = object instanceof JsReturn ? (JsReturn)object : null;
        JsExpression jsExpression2 = jsExpression = jsReturn != null ? jsReturn.getExpression() : null;
        if (jsExpression2 != null) {
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"(last() as? JsReturn)?.expression ?: return@apply");
            JsExpression expression2 = jsExpression;
            if (expression2 instanceof JsPrefixOperation && ((JsPrefixOperation)expression2).getOperator() == JsUnaryOperator.VOID) {
                CollectionsKt.removeLastOrNull((List)$this$generateStatement_u24lambda_u2d0);
            } else {
                int n = CollectionsKt.getLastIndex((List)$this$generateStatement_u24lambda_u2d0);
                JsStatement jsStatement2 = expression2.makeStmt();
                Intrinsics.checkNotNullExpressionValue((Object)jsStatement2, (String)"expression.makeStmt()");
                $this$generateStatement_u24lambda_u2d0.set(n, jsStatement2);
            }
        }
        List newStatements = list2;
        switch (newStatements.size()) {
            case 0: {
                jsStatement = JsEmpty.INSTANCE;
                break;
            }
            case 1: {
                jsStatement = (JsStatement)JsAstUtilsKt.withSource((JsNode)CollectionsKt.single((List)newStatements), (IrElement)this.jsOrJsFuncCall, this.context);
                break;
            }
            default: {
                JsCompositeBlock jsCompositeBlock;
                JsCompositeBlock $this$generateStatement_u24lambda_u2d1 = jsCompositeBlock = new JsCompositeBlock(null, 1, null);
                boolean bl2 = false;
                List<JsStatement> list3 = $this$generateStatement_u24lambda_u2d1.getStatements();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"statements");
                CollectionsKt.addAll((Collection)list3, (Iterable)newStatements);
                jsStatement = jsCompositeBlock;
            }
        }
        return jsStatement;
    }

    @NotNull
    public final JsExpression generateExpression() {
        JsExpression lastExpression;
        JsStatement jsStatement;
        Object object;
        Object object2;
        block6: {
            if (this.statements.isEmpty()) {
                return new JsPrefixOperation(JsUnaryOperator.VOID, new JsIntLiteral(3));
            }
            object2 = this.statements;
            object = object2.listIterator(object2.size());
            while (object.hasPrevious()) {
                JsStatement jsStatement2;
                JsStatement it = jsStatement2 = object.previous();
                boolean bl = false;
                if (!(!(it instanceof JsSingleLineComment) && !(it instanceof JsMultiLineComment))) continue;
                jsStatement = jsStatement2;
                break block6;
            }
            jsStatement = null;
        }
        JsStatement lastStatement = jsStatement;
        object2 = lastStatement;
        JsExpression jsExpression = object2 instanceof JsReturn ? ((JsReturn)lastStatement).getExpression() : (lastExpression = object2 instanceof JsExpressionStatement ? ((JsExpressionStatement)lastStatement).getExpression() : null);
        if (this.statements.size() == 1 && lastExpression != null) {
            return (JsExpression)JsAstUtilsKt.withSource((JsNode)lastExpression, (IrElement)this.jsOrJsFuncCall, this.context);
        }
        List newStatements = CollectionsKt.toMutableList((Collection)this.statements);
        object = lastStatement;
        if (!(object instanceof JsReturn)) {
            if (object instanceof JsExpressionStatement) {
                newStatements.set(CollectionsKt.getLastIndex(this.statements), new JsReturn(((JsExpressionStatement)lastStatement).getExpression()));
            } else {
                ((Collection)newStatements).add(new JsReturn(new JsPrefixOperation(JsUnaryOperator.VOID, new JsIntLiteral(3))));
            }
        }
        JsFunction syntheticFunction = new JsFunction(JsGenerationContextKt.getEmptyScope(), new JsBlock(newStatements), "");
        return (JsExpression)JsAstUtilsKt.withSource((JsNode)new JsInvocation((JsExpression)syntheticFunction, new JsExpression[0]), (IrElement)this.jsOrJsFuncCall, this.context);
    }

    private final List<JsStatement> getJsStatements() {
        List<JsStatement> list2;
        if (this.context.checkIfJsCode((IrFunctionSymbol)this.jsOrJsFuncCall.getSymbol())) {
            IrExpression irExpression = this.jsOrJsFuncCall.getValueArgument(0);
            if (irExpression == null) {
                CompilationExceptionKt.compilationException((String)"JsCode is expected", (IrElement)((IrElement)this.jsOrJsFuncCall));
                throw null;
            }
            list2 = JsCodeKt.translateJsCodeIntoStatementList(irExpression, this.context.getStaticContext().getBackendContext());
            if (list2 == null) {
                CompilationExceptionKt.compilationException((String)"Cannot compute js code", (IrElement)((IrElement)this.jsOrJsFuncCall));
                throw null;
            }
        } else if (this.context.checkIfAnnotatedWithJsFunc((IrFunctionSymbol)this.jsOrJsFuncCall.getSymbol())) {
            list2 = new FunctionWithJsFuncAnnotationInliner(this.jsOrJsFuncCall, this.context).generateResultStatement();
        } else {
            CompilationExceptionKt.compilationException((String)"`js` function call or function with @JsFunc annotation expected", (IrElement)((IrElement)this.jsOrJsFuncCall));
            throw null;
        }
        return list2;
    }
}

