/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsManglerIr;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTable;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.common.IdentifierPolicyKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001b\u0010\t\u001a\u00020\u0001\"\u0004\b\u0000\u0010\n2\u0006\u0010\u0005\u001a\u0002H\nH\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u00012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a\u0010\u0010\u0010\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020\u00120\u0011\u001a&\u0010\u0013\u001a\u00020\u0014*\u00020\u00142\u0017\u0010\u0015\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f0\u0016\u00a2\u0006\u0002\b\u0017H\u0082\b\u001a\f\u0010\u0018\u001a\u0004\u0018\u00010\u0001*\u00020\u0019\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u001b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"RESERVED_MEMBER_NAME_SUFFIX", "", "SYNTHETIC_BLOCK_LABEL", "SYNTHETIC_LOOP_LABEL", "jsFunctionSignature", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "mapToKey", "T", "(Ljava/lang/Object;)Ljava/lang/String;", "sanitizeName", "name", "withHash", "", "dump", "Lorg/jetbrains/kotlin/ir/backend/js/utils/NameTable;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "mangleIfNot", "", "predicate", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "nameIfPropertyAccessor", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "toJsIdentifier", "", "backend.js"})
public final class NameTablesKt {
    @NotNull
    private static final String RESERVED_MEMBER_NAME_SUFFIX = "_k$";
    @NotNull
    private static final String SYNTHETIC_LOOP_LABEL = "$l$loop";
    @NotNull
    private static final String SYNTHETIC_BLOCK_LABEL = "$l$block";

    /*
     * WARNING - void declaration
     */
    private static final <T> String mapToKey(T declaration) {
        String string2;
        JsManglerIr $this$mapToKey_u24lambda_u2d1 = JsManglerIr.INSTANCE;
        boolean bl = false;
        if (declaration instanceof IrDeclaration) {
            String string3;
            try {
                string3 = String.valueOf($this$mapToKey_u24lambda_u2d1.hashedMangle(declaration, false));
            }
            catch (Throwable e) {
                string3 = "wrong_key";
            }
            string2 = string3;
        } else if (declaration instanceof String) {
            string2 = String.valueOf($this$mapToKey_u24lambda_u2d1.getHashMangle((String)declaration));
        } else {
            String string4;
            StringBuilder stringBuilder2 = new StringBuilder().append("Key is not generated for ");
            T t = declaration;
            if (t != null) {
                void it;
                T e = t;
                StringBuilder stringBuilder3 = stringBuilder2;
                boolean bl2 = false;
                string4 = Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName();
                stringBuilder2 = stringBuilder3;
            } else {
                string4 = null;
            }
            String string5 = stringBuilder2.append(string4).toString();
            throw new IllegalStateException(string5.toString());
        }
        return string2;
    }

    @NotNull
    public static final String dump(@NotNull NameTable<IrDeclaration> $this$dump) {
        Intrinsics.checkNotNullParameter($this$dump, (String)"<this>");
        return "Names: \n" + CollectionsKt.joinToString$default((Iterable)MapsKt.toList($this$dump.getNames()), (CharSequence)"\n", null, null, (int)0, null, (Function1)dump.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String toJsIdentifier(int $this$toJsIdentifier) {
        String string2;
        String first = String.valueOf((char)(97 + $this$toJsIdentifier % 26));
        int other = $this$toJsIdentifier / 26;
        if (other == 0) {
            string2 = first;
        } else {
            StringBuilder stringBuilder2 = new StringBuilder().append(first);
            String string3 = Integer.toString(other, CharsKt.checkRadix((int)36));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this, checkRadix(radix))");
            string2 = stringBuilder2.append(string3).toString();
        }
        return string2;
    }

    @NotNull
    public static final String jsFunctionSignature(@NotNull IrFunction declaration, @NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(!IrDeclarationsKt.isStaticMethodOfClass((IrFunction)declaration))) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!(declaration.getDispatchReceiverParameter() != null)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        String declarationName = null;
        String string4 = AnnotationUtilsKt.getJsNameOrKotlinName((IrDeclarationWithName)declaration).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"declaration.getJsNameOrKotlinName().asString()");
        declarationName = string4;
        if (MiscKt.hasStableJsName(declaration, context)) {
            if (!(!StringsKt.endsWith$default((String)declarationName, (String)RESERVED_MEMBER_NAME_SUFFIX, (boolean)false, (int)2, null))) {
                boolean $i$a$-require-NameTablesKt$jsFunctionSignature$22 = false;
                String $i$a$-require-NameTablesKt$jsFunctionSignature$22 = "Function " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration)) + " uses reserved name suffix \"_k$\"";
                throw new IllegalArgumentException($i$a$-require-NameTablesKt$jsFunctionSignature$22.toString());
            }
            return declarationName;
        }
        String string5 = NameTablesKt.nameIfPropertyAccessor((IrDeclarationWithName)declaration);
        if (string5 != null) {
            String it = string5;
            boolean bl = false;
            declarationName = it;
        }
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(declarationName);
        Collection $this$ifNotEmpty$iv = declaration.getTypeParameters();
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$jsFunctionSignature_u24lambda_u2d4 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            nameBuilder.append("_$t");
            StringBuilder cfr_ignored_0 = (StringBuilder)CollectionsKt.joinTo$default((Iterable)$this$jsFunctionSignature_u24lambda_u2d4, (Appendable)nameBuilder, (CharSequence)"", null, null, (int)0, null, (Function1)jsFunctionSignature.3.1.INSTANCE, (int)60, null);
        }
        IrValueParameter irValueParameter = declaration.getExtensionReceiverParameter();
        if (irValueParameter != null) {
            IrValueParameter it = irValueParameter;
            boolean bl = false;
            nameBuilder.append("_r$" + IrTypeUtilsKt.asString(it.getType()));
        }
        $this$ifNotEmpty$iv = declaration.getValueParameters();
        $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$jsFunctionSignature_u24lambda_u2d6 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            StringBuilder cfr_ignored_1 = (StringBuilder)CollectionsKt.joinTo$default((Iterable)$this$jsFunctionSignature_u24lambda_u2d6, (Appendable)nameBuilder, (CharSequence)"", null, null, (int)0, null, (Function1)jsFunctionSignature.5.1.INSTANCE, (int)60, null);
        }
        IrType it = declaration.getReturnType();
        boolean bl = false;
        if (context.getInlineClassesUtils().isTypeInlined(it) || IrTypePredicatesKt.isUnit((IrType)it)) {
            nameBuilder.append("_ret$" + IrTypeUtilsKt.asString(it));
        }
        String string6 = nameBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"nameBuilder.toString()");
        String signature = string6;
        StringBuilder stringBuilder2 = new StringBuilder().append(NameTablesKt.sanitizeName(declarationName, false)).append('_');
        String string7 = Integer.toString(Math.abs(signature.hashCode()), CharsKt.checkRadix((int)36));
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(this, checkRadix(radix))");
        return stringBuilder2.append(string7).append(RESERVED_MEMBER_NAME_SUFFIX).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String sanitizeName(@NotNull String name, boolean withHash) {
        String string2;
        void p0;
        char first;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (IdentifierPolicyKt.isValidES5Identifier(name)) {
            return name;
        }
        if (((CharSequence)name).length() == 0) {
            return "_";
        }
        StringBuilder builder2 = new StringBuilder();
        char $this$mangleIfNot$iv = first = StringsKt.first((CharSequence)name);
        boolean $i$f$mangleIfNot = false;
        char c = $this$mangleIfNot$iv;
        StringBuilder stringBuilder2 = builder2;
        boolean bl = false;
        boolean bl2 = IdentifierPolicyKt.isES5IdentifierStart((char)p0);
        stringBuilder2.append(bl2 ? $this$mangleIfNot$iv : (char)'_');
        int idx = 1;
        int n = StringsKt.getLastIndex((CharSequence)name);
        if (idx <= n) {
            while (true) {
                void p02;
                char c2;
                char $this$mangleIfNot$iv2 = c2 = name.charAt(idx);
                boolean $i$f$mangleIfNot2 = false;
                char c3 = $this$mangleIfNot$iv2;
                stringBuilder2 = builder2;
                boolean bl3 = false;
                bl2 = IdentifierPolicyKt.isES5IdentifierPart((char)p02);
                stringBuilder2.append(bl2 ? $this$mangleIfNot$iv2 : (char)'_');
                if (idx == n) break;
                ++idx;
            }
        }
        if (withHash) {
            StringBuilder stringBuilder3 = new StringBuilder().append((Object)builder2).append('_');
            String string3 = Integer.toString(Math.abs(name.hashCode()), CharsKt.checkRadix((int)36));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this, checkRadix(radix))");
            string2 = stringBuilder3.append(string3).toString();
        } else {
            String string4 = builder2.toString();
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n        builder.toString()\n    }");
        }
        return string2;
    }

    public static /* synthetic */ String sanitizeName$default(String string2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return NameTablesKt.sanitizeName(string2, bl);
    }

    @Nullable
    public static final String nameIfPropertyAccessor(@NotNull IrDeclarationWithName $this$nameIfPropertyAccessor) {
        Intrinsics.checkNotNullParameter((Object)$this$nameIfPropertyAccessor, (String)"<this>");
        if ($this$nameIfPropertyAccessor instanceof IrSimpleFunction) {
            String string2;
            if (((IrSimpleFunction)$this$nameIfPropertyAccessor).getCorrespondingPropertySymbol() != null) {
                String string3;
                IrPropertySymbol irPropertySymbol = ((IrSimpleFunction)$this$nameIfPropertyAccessor).getCorrespondingPropertySymbol();
                Intrinsics.checkNotNull((Object)irPropertySymbol);
                IrProperty property = (IrProperty)irPropertySymbol.getOwner();
                String string4 = AnnotationUtilsKt.getJsNameOrKotlinName((IrDeclarationWithName)property).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"property.getJsNameOrKotlinName().asString()");
                String name = string4;
                IrDeclarationWithName irDeclarationWithName = $this$nameIfPropertyAccessor;
                if (Intrinsics.areEqual((Object)irDeclarationWithName, (Object)property.getGetter())) {
                    string3 = "get_";
                } else if (Intrinsics.areEqual((Object)irDeclarationWithName, (Object)property.getSetter())) {
                    string3 = "set_";
                } else {
                    throw new IllegalStateException("".toString());
                }
                String prefix = string3;
                string2 = prefix + name;
            } else if (Intrinsics.areEqual((Object)$this$nameIfPropertyAccessor.getOrigin(), (Object)((Object)JsLoweredDeclarationOrigin.BRIDGE_PROPERTY_ACCESSOR.INSTANCE))) {
                String string5 = AnnotationUtilsKt.getJsNameOrKotlinName($this$nameIfPropertyAccessor).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this.getJsNameOrKotlinName().asString()");
                string2 = StringsKt.replaceFirst$default((String)StringsKt.replaceFirst$default((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string5, (CharSequence)"<"), (CharSequence)">"), (String)"get-", (String)"get_", (boolean)false, (int)4, null), (String)"set-", (String)"set_", (boolean)false, (int)4, null);
            } else {
                string2 = null;
            }
            return string2;
        }
        return null;
    }

    private static final char mangleIfNot(char $this$mangleIfNot, Function1<? super Character, Boolean> predicate) {
        boolean $i$f$mangleIfNot = false;
        return (Boolean)predicate.invoke((Object)Character.valueOf($this$mangleIfNot)) != false ? $this$mangleIfNot : (char)'_';
    }

    public static final /* synthetic */ String access$mapToKey(Object declaration) {
        return NameTablesKt.mapToKey(declaration);
    }
}

