/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.operation;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsIntLiteral;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.general.AbstractTranslator;
import org.jetbrains.kotlin.js.translate.operation.BinaryOperationTranslator;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.ErrorReportingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

public final class CompareToTranslator
extends AbstractTranslator {
    @NotNull
    private final KtBinaryExpression expression;

    public static boolean isCompareToCall(@NotNull KtToken operationToken, @Nullable CallableDescriptor operationDescriptor) {
        if (operationToken == null) {
            CompareToTranslator.$$$reportNull$$$0(0);
        }
        if (!OperatorConventions.COMPARISON_OPERATIONS.contains((Object)operationToken) || operationDescriptor == null) {
            return false;
        }
        return JsDescriptorUtils.isCompareTo(operationDescriptor);
    }

    @NotNull
    public static JsExpression translate(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            CompareToTranslator.$$$reportNull$$$0(1);
        }
        if (context == null) {
            CompareToTranslator.$$$reportNull$$$0(2);
        }
        return new CompareToTranslator(expression2, context).translate();
    }

    private CompareToTranslator(@NotNull KtBinaryExpression expression2, @NotNull TranslationContext context) {
        if (expression2 == null) {
            CompareToTranslator.$$$reportNull$$$0(3);
        }
        if (context == null) {
            CompareToTranslator.$$$reportNull$$$0(4);
        }
        super(context);
        this.expression = expression2;
        CallableDescriptor descriptor2 = BindingUtils.getCallableDescriptorForOperationExpression(context.bindingContext(), (KtOperationExpression)expression2);
        assert (descriptor2 != null) : "CompareTo should always have a descriptor";
        assert (OperatorConventions.COMPARISON_OPERATIONS.contains((Object)PsiUtils.getOperationToken((KtOperationExpression)expression2))) : ErrorReportingUtils.message((PsiElement)expression2, "CompareToTranslator supported only expressions with operation token from COMPARISON_OPERATIONS, expression: " + expression2.getText());
    }

    @NotNull
    private JsExpression translate() {
        JsBinaryOperator correspondingOperator = OperatorTable.getBinaryOperator(PsiUtils.getOperationToken((KtOperationExpression)this.expression));
        JsExpression methodCall = BinaryOperationTranslator.translateAsOverloadedCall(this.expression, this.context());
        return new JsBinaryOperation(correspondingOperator, methodCall, new JsIntLiteral(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationToken";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/js/translate/operation/CompareToTranslator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompareToCall";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "translate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

