/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.client.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.client.common.DrawEvent;
import org.jetbrains.projector.client.common.RenderingQueue;
import org.jetbrains.projector.client.common.SingleRenderingSurfaceProcessor;
import org.jetbrains.projector.client.common.window.Window;
import org.jetbrains.projector.client.common.window.WindowManager;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawCommandsEvent;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0006\u0010\u000e\u001a\u00020\nJ\u0006\u0010\u000f\u001a\u00020\nJ\u001c\u0010\u0010\u001a\u00020\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n0\u0012H\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0013*\u00020\u0015H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/projector/client/common/RenderingQueue;", "", "windowManager", "Lorg/jetbrains/projector/client/common/window/WindowManager;", "(Lorg/jetbrains/projector/client/common/window/WindowManager;)V", "newDrawEvents", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/projector/client/common/RenderingQueue$Companion$ShrunkDrawEvents;", "pendingDrawEvents", "add", "", "drawCommands", "", "Lorg/jetbrains/projector/common/protocol/toClient/ServerDrawCommandsEvent;", "drawNewEvents", "drawPendingEvents", "forEachRenderingSurface", "op", "Lkotlin/Function1;", "Lorg/jetbrains/projector/client/common/SingleRenderingSurfaceProcessor;", "getCommandProcessor", "Lorg/jetbrains/projector/common/protocol/toClient/ServerDrawCommandsEvent$Target;", "Companion", "projector-client-common"})
public final class RenderingQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WindowManager<?> windowManager;
    @NotNull
    private final ArrayDeque<Companion.ShrunkDrawEvents> pendingDrawEvents;
    @NotNull
    private final ArrayDeque<Companion.ShrunkDrawEvents> newDrawEvents;
    @NotNull
    private static final Logger logger;

    public RenderingQueue(@NotNull WindowManager<?> windowManager) {
        Intrinsics.checkNotNullParameter(windowManager, (String)"windowManager");
        this.windowManager = windowManager;
        this.pendingDrawEvents = new ArrayDeque();
        this.newDrawEvents = new ArrayDeque();
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull Iterable<ServerDrawCommandsEvent> drawCommands) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(drawCommands, (String)"drawCommands");
        Iterable<ServerDrawCommandsEvent> iterable = drawCommands;
        ArrayDeque<Companion.ShrunkDrawEvents> arrayDeque = this.newDrawEvents;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ServerDrawCommandsEvent serverDrawCommandsEvent = (ServerDrawCommandsEvent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Companion.ShrunkDrawEvents(it.getTarget(), SingleRenderingSurfaceProcessor.Companion.shrinkByPaintEvents(it.getDrawEvents())));
        }
        arrayDeque.addAll((Collection)((List)destination$iv$iv));
    }

    private final SingleRenderingSurfaceProcessor getCommandProcessor(ServerDrawCommandsEvent.Target $this$getCommandProcessor) {
        SingleRenderingSurfaceProcessor singleRenderingSurfaceProcessor;
        ServerDrawCommandsEvent.Target target = $this$getCommandProcessor;
        if (target instanceof ServerDrawCommandsEvent.Target.Onscreen) {
            Object window = this.windowManager.get(((ServerDrawCommandsEvent.Target.Onscreen)$this$getCommandProcessor).getWindowId());
            if (window == null) {
                Logger.DefaultImpls.error$default((Logger)logger, null, (Function0)((Function0)new Function0<String>($this$getCommandProcessor){
                    final /* synthetic */ ServerDrawCommandsEvent.Target $this_getCommandProcessor;
                    {
                        this.$this_getCommandProcessor = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Skipping nonexistent window: " + ((ServerDrawCommandsEvent.Target.Onscreen)this.$this_getCommandProcessor).getWindowId();
                    }
                }), (int)1, null);
                singleRenderingSurfaceProcessor = null;
            } else {
                singleRenderingSurfaceProcessor = window.getCommandProcessor();
            }
        } else if (target instanceof ServerDrawCommandsEvent.Target.Offscreen) {
            singleRenderingSurfaceProcessor = this.windowManager.getImageCacher().getOffscreenProcessor((ServerDrawCommandsEvent.Target.Offscreen)$this$getCommandProcessor);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return singleRenderingSurfaceProcessor;
    }

    private final void forEachRenderingSurface(Function1<? super SingleRenderingSurfaceProcessor, Unit> op) {
        Iterable $this$forEach$iv = this.windowManager;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Window it = (Window)element$iv;
            boolean bl = false;
            op.invoke((Object)it.getCommandProcessor());
        }
    }

    public final void drawNewEvents() {
        Iterable $this$forEach$iv = (Iterable)this.newDrawEvents;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SingleRenderingSurfaceProcessor commandProcessor;
            Companion.ShrunkDrawEvents shrunk = (Companion.ShrunkDrawEvents)element$iv;
            boolean bl = false;
            if (this.getCommandProcessor(shrunk.getTarget()) == null) continue;
            Integer firstUnsuccessful = commandProcessor.processNew((Iterable<? extends DrawEvent>)shrunk.getEvents());
            if (!((Collection)this.pendingDrawEvents).isEmpty()) {
                this.pendingDrawEvents.add((Object)shrunk);
                continue;
            }
            if (firstUnsuccessful == null) continue;
            if (!((Collection)this.pendingDrawEvents).isEmpty()) {
                Logger.DefaultImpls.error$default((Logger)logger, null, (Function0)drawNewEvents.1.1.INSTANCE, (int)1, null);
            }
            this.pendingDrawEvents.add((Object)Companion.ShrunkDrawEvents.copy$default(shrunk, null, shrunk.getEvents().subList(firstUnsuccessful, shrunk.getEvents().size()), 1, null));
            this.forEachRenderingSurface((Function1<? super SingleRenderingSurfaceProcessor, Unit>)((Function1)drawNewEvents.1.2.INSTANCE));
        }
        this.newDrawEvents.clear();
    }

    /*
     * WARNING - void declaration
     */
    public final void drawPendingEvents() {
        block5: {
            Unit unit;
            Unit unit2;
            int i;
            Pair firstUnsuccessful = null;
            this.forEachRenderingSurface((Function1<? super SingleRenderingSurfaceProcessor, Unit>)((Function1)drawPendingEvents.1.INSTANCE));
            Iterable $this$forEachIndexed$iv = (Iterable)this.pendingDrawEvents;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                SingleRenderingSurfaceProcessor commandProcessor;
                void shrunk;
                int n = index$iv;
                index$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Companion.ShrunkDrawEvents shrunkDrawEvents = (Companion.ShrunkDrawEvents)item$iv;
                i = n;
                boolean bl = false;
                if (this.getCommandProcessor(shrunk.getTarget()) == null) continue;
                Integer firstUnsuccessfulItem = commandProcessor.processNew((Iterable<? extends DrawEvent>)shrunk.getEvents());
                if (firstUnsuccessful != null || firstUnsuccessfulItem == null) continue;
                firstUnsuccessful = TuplesKt.to((Object)i, (Object)firstUnsuccessfulItem);
            }
            Pair pair = firstUnsuccessful;
            if (pair == null) {
                unit2 = null;
            } else {
                Pair $dstr$i0$i1 = pair;
                boolean bl = false;
                int i0 = ((Number)$dstr$i0$i1.component1()).intValue();
                int i1 = ((Number)$dstr$i0$i1.component2()).intValue();
                i = 0;
                while (i < i0) {
                    int n;
                    int it = n = i++;
                    boolean bl2 = false;
                    this.pendingDrawEvents.removeFirst();
                }
                Companion.ShrunkDrawEvents first = (Companion.ShrunkDrawEvents)this.pendingDrawEvents.removeFirst();
                this.pendingDrawEvents.addFirst((Object)Companion.ShrunkDrawEvents.copy$default(first, null, first.getEvents().subList(i1, first.getEvents().size()), 1, null));
                unit2 = unit = Unit.INSTANCE;
            }
            if (unit != null) break block5;
            this.pendingDrawEvents.clear();
        }
    }

    static {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(RenderingQueue.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger((String)string);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/projector/client/common/RenderingQueue$Companion;", "", "()V", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "ShrunkDrawEvents", "projector-client-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/projector/client/common/RenderingQueue$Companion$ShrunkDrawEvents;", "", "target", "Lorg/jetbrains/projector/common/protocol/toClient/ServerDrawCommandsEvent$Target;", "events", "", "Lorg/jetbrains/projector/client/common/DrawEvent;", "(Lorg/jetbrains/projector/common/protocol/toClient/ServerDrawCommandsEvent$Target;Ljava/util/List;)V", "getEvents", "()Ljava/util/List;", "getTarget", "()Lorg/jetbrains/projector/common/protocol/toClient/ServerDrawCommandsEvent$Target;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "projector-client-common"})
        private static final class ShrunkDrawEvents {
            @NotNull
            private final ServerDrawCommandsEvent.Target target;
            @NotNull
            private final List<DrawEvent> events;

            public ShrunkDrawEvents(@NotNull ServerDrawCommandsEvent.Target target, @NotNull List<? extends DrawEvent> events) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                Intrinsics.checkNotNullParameter(events, (String)"events");
                this.target = target;
                this.events = events;
            }

            @NotNull
            public final ServerDrawCommandsEvent.Target getTarget() {
                return this.target;
            }

            @NotNull
            public final List<DrawEvent> getEvents() {
                return this.events;
            }

            @NotNull
            public final ServerDrawCommandsEvent.Target component1() {
                return this.target;
            }

            @NotNull
            public final List<DrawEvent> component2() {
                return this.events;
            }

            @NotNull
            public final ShrunkDrawEvents copy(@NotNull ServerDrawCommandsEvent.Target target, @NotNull List<? extends DrawEvent> events) {
                Intrinsics.checkNotNullParameter((Object)target, (String)"target");
                Intrinsics.checkNotNullParameter(events, (String)"events");
                return new ShrunkDrawEvents(target, events);
            }

            public static /* synthetic */ ShrunkDrawEvents copy$default(ShrunkDrawEvents shrunkDrawEvents, ServerDrawCommandsEvent.Target target, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    target = shrunkDrawEvents.target;
                }
                if ((n & 2) != 0) {
                    list = shrunkDrawEvents.events;
                }
                return shrunkDrawEvents.copy(target, list);
            }

            @NotNull
            public String toString() {
                return "ShrunkDrawEvents(target=" + this.target + ", events=" + this.events + ")";
            }

            public int hashCode() {
                int result = this.target.hashCode();
                result = result * 31 + ((Object)this.events).hashCode();
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ShrunkDrawEvents)) {
                    return false;
                }
                ShrunkDrawEvents shrunkDrawEvents = (ShrunkDrawEvents)other;
                if (!Intrinsics.areEqual((Object)this.target, (Object)shrunkDrawEvents.target)) {
                    return false;
                }
                return Intrinsics.areEqual(this.events, shrunkDrawEvents.events);
            }
        }
    }
}

