/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.nio.file.Path;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.internal.TypeHolder;
import org.assertj.core.util.DoubleComparator;
import org.assertj.core.util.FloatComparator;
import org.assertj.core.util.PathNaturalOrderComparator;

public class TypeComparators
extends TypeHolder<Comparator<?>> {
    private static final double DOUBLE_COMPARATOR_PRECISION = 1.0E-15;
    private static final DoubleComparator DEFAULT_DOUBLE_COMPARATOR = new DoubleComparator(1.0E-15);
    private static final float FLOAT_COMPARATOR_PRECISION = 1.0E-6f;
    private static final FloatComparator DEFAULT_FLOAT_COMPARATOR = new FloatComparator(1.0E-6f);
    private static final Comparator<Path> DEFAULT_PATH_COMPARATOR = PathNaturalOrderComparator.INSTANCE;

    public static TypeComparators defaultTypeComparators() {
        TypeComparators comparatorByType = new TypeComparators();
        comparatorByType.registerComparator(Double.class, DEFAULT_DOUBLE_COMPARATOR);
        comparatorByType.registerComparator(Float.class, DEFAULT_FLOAT_COMPARATOR);
        comparatorByType.registerComparator(Path.class, DEFAULT_PATH_COMPARATOR);
        return comparatorByType;
    }

    public Comparator<?> getComparatorForType(Class<?> clazz) {
        return (Comparator)super.get(clazz);
    }

    public boolean hasComparatorForType(Class<?> type2) {
        return super.hasEntity(type2);
    }

    public <T> void registerComparator(Class<T> clazz, Comparator<? super T> comparator) {
        super.put(clazz, comparator);
    }

    public Stream<Map.Entry<Class<?>, Comparator<?>>> comparatorByTypes() {
        return super.entityByTypes();
    }
}

