/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.table.JTableHeader;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.exception.LocationUnavailableException;
import org.assertj.swing.util.Pair;
import org.assertj.swing.util.TextMatcher;

public class JTableHeaderLocation {
    @Nonnull
    @RunsInCurrentThread
    public Pair<Integer, Point> pointAt(@Nonnull JTableHeader tableHeader, @Nonnull TextMatcher matcher2) {
        int index = this.indexOf(tableHeader, matcher2);
        if (this.isValidIndex(tableHeader, index)) {
            return Pair.of(index, JTableHeaderLocation.point(tableHeader, index));
        }
        String format = "Unable to find column with name matching %s %s";
        String msg = String.format(format, matcher2.description(), matcher2.formattedValues());
        throw new LocationUnavailableException(msg);
    }

    @RunsInCurrentThread
    private boolean isValidIndex(@Nonnull JTableHeader tableHeader, int index) {
        int itemCount = this.columnCount(tableHeader);
        return index >= 0 && index < itemCount;
    }

    @Nonnull
    @RunsInCurrentThread
    public Point pointAt(@Nonnull JTableHeader tableHeader, int index) {
        return JTableHeaderLocation.point(tableHeader, this.checkIndexInBounds(tableHeader, index));
    }

    @Nonnull
    @RunsInCurrentThread
    private static Point point(@Nonnull JTableHeader tableHeader, int index) {
        Rectangle r = tableHeader.getHeaderRect(index);
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    @RunsInCurrentThread
    private int checkIndexInBounds(@Nonnull JTableHeader tableHeader, int index) {
        int itemCount = this.columnCount(tableHeader);
        if (index >= 0 && index < itemCount) {
            return index;
        }
        String msg = String.format("Item index <%d> should be between <0> and <%d>", index, itemCount - 1);
        throw new IndexOutOfBoundsException(msg);
    }

    @RunsInCurrentThread
    public int indexOf(@Nonnull JTableHeader tableHeader, @Nonnull TextMatcher matcher2) {
        int size = this.columnCount(tableHeader);
        for (int i = 0; i < size; ++i) {
            if (!matcher2.isMatching(this.columnName(tableHeader, i))) continue;
            return tableHeader.getTable().convertColumnIndexToView(i);
        }
        return -1;
    }

    @RunsInCurrentThread
    private int columnCount(@Nonnull JTableHeader header) {
        return header.getColumnModel().getColumnCount();
    }

    @RunsInCurrentThread
    private String columnName(@Nonnull JTableHeader tableHeader, int index) {
        return tableHeader.getTable().getModel().getColumnName(index);
    }
}

