/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.format;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JList;
import javax.swing.ListModel;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Strings;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.format.ComponentFormatterTemplate;
import org.assertj.swing.format.SwingIntEnums;
import org.assertj.swing.util.Arrays;

public class JListFormatter
extends ComponentFormatterTemplate {
    @Override
    @Nonnull
    @RunsInCurrentThread
    protected String doFormat(@Nonnull Component c) {
        JList list2 = (JList)c;
        String format = "%s[name=%s, selectedValues=%s, contents=%s, selectionMode=%s, enabled=%b, visible=%b, showing=%b]";
        return String.format(format, this.getRealClassName(c), Strings.quote(list2.getName()), Arrays.format(list2.getSelectedValues()), Arrays.format(this.contentsOf(list2)), SwingIntEnums.SELECTION_MODES.get(list2.getSelectionMode()), list2.isEnabled(), list2.isVisible(), list2.isShowing());
    }

    @Nonnull
    private Object[] contentsOf(JList<?> list2) {
        ArrayList contents = Lists.newArrayList();
        ListModel<?> model = list2.getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            contents.add(model.getElementAt(i));
        }
        return contents.toArray();
    }

    @Override
    @Nonnull
    public Class<? extends Component> targetType() {
        return JList.class;
    }
}

