/*
 * Decompiled with CFR 0.152.
 */
package training.dsl;

import com.intellij.openapi.util.text.StringUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.ui.LearningUiManager;
import training.util.UtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0016J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a8\u0006\r"}, d2={"Ltraining/dsl/LearningDslBase;", "", "action", "", "actionId", "code", "sourceSample", "icon", "Ljavax/swing/Icon;", "shortcut", "key", "strong", "text", "intellij.featuresTrainer"})
public interface LearningDslBase {
    @NotNull
    public String action(@NotNull String var1);

    @NotNull
    public String code(@NotNull String var1);

    @NotNull
    public String strong(@NotNull String var1);

    @NotNull
    public String icon(@NotNull Icon var1);

    @NotNull
    public String shortcut(@NotNull String var1);

    @Metadata(mv={1, 5, 1}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static String action(@NotNull LearningDslBase $this, @NotNull String actionId) {
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            return " <action>" + actionId + "</action> ";
        }

        @NotNull
        public static String code(@NotNull LearningDslBase $this, @NotNull String sourceSample) {
            Intrinsics.checkNotNullParameter((Object)sourceSample, (String)"sourceSample");
            String string = StringUtil.escapeXmlEntities((String)sourceSample);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.escapeXmlEntities(sourceSample)");
            return " <code>" + UtilsKt.replaceSpacesWithNonBreakSpace(string) + "</code> ";
        }

        @NotNull
        public static String strong(@NotNull LearningDslBase $this, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return "<strong>" + StringUtil.escapeXmlEntities((String)text2) + "</strong>";
        }

        @NotNull
        public static String icon(@NotNull LearningDslBase $this, @NotNull Icon icon) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            String index = LearningUiManager.INSTANCE.getIconIndex(icon);
            return "<icon_idx>" + index + "</icon_idx>";
        }

        @NotNull
        public static String shortcut(@NotNull LearningDslBase $this, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return "<shortcut>" + key + "</shortcut>";
        }
    }
}

