/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.asJava.builder;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.asJava.builder.ClsWrapperStubPsiFactory;
import org.jetbrains.kotlin.asJava.classes.KtLightClassForSourceDeclarationKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.debugText.DebugTextUtilKt;
import org.jetbrains.kotlin.utils.KotlinExceptionWithAttachments;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"collectClassNames", "", "javaFileStub", "Lcom/intellij/psi/impl/java/stubs/PsiJavaFileStub;", "findDelegate", "Lcom/intellij/psi/PsiClass;", "classFqName", "Lorg/jetbrains/kotlin/name/FqName;", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "light-classes"})
public final class LightClassDataHolderKt {
    @NotNull
    public static final PsiClass findDelegate(@NotNull PsiJavaFileStub $this$findDelegate, @NotNull KtClassOrObject classOrObject) {
        String it2;
        Intrinsics.checkNotNullParameter((Object)$this$findDelegate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        PsiClass psiClass = LightClassUtil.INSTANCE.findClass((StubElement)$this$findDelegate, (Function1)new Function1<PsiClassStub<?>, Boolean>(classOrObject){
            final /* synthetic */ KtClassOrObject $classOrObject;
            {
                this.$classOrObject = $classOrObject;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PsiClassStub<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return Intrinsics.areEqual((Object)ClsWrapperStubPsiFactory.getOriginalElement((StubElement)it), (Object)this.$classOrObject);
            }
        });
        if (psiClass != null) {
            PsiClass it2 = psiClass;
            boolean bl = false;
            return it2;
        }
        KtClassOrObject outermostClassOrObject = KtLightClassForSourceDeclarationKt.getOutermostClassOrObject(classOrObject);
        try {
            it2 = outermostClassOrObject.getContainingFile().getText();
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            it2 = "Can't get text for outermost class";
        }
        String ktFileText = it2;
        String string = DebugUtil.stubTreeToString((Stub)((Stub)$this$findDelegate));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stubTreeToString(this)");
        String stubFileText = string;
        KotlinExceptionWithAttachments kotlinExceptionWithAttachments = new KotlinExceptionWithAttachments("Couldn't get delegate for class");
        String string2 = classOrObject.getName();
        if (string2 == null) {
            string2 = "unnamed class or object";
        }
        throw kotlinExceptionWithAttachments.withAttachment(string2, DebugTextUtilKt.getDebugText((KtElement)classOrObject)).withAttachment("file.kt", ktFileText).withAttachment("stub text", stubFileText);
    }

    @NotNull
    public static final PsiClass findDelegate(@NotNull PsiJavaFileStub $this$findDelegate, @NotNull FqName classFqName) {
        Intrinsics.checkNotNullParameter((Object)$this$findDelegate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)classFqName, (String)"classFqName");
        PsiClass psiClass = LightClassUtil.INSTANCE.findClass((StubElement)$this$findDelegate, (Function1)new Function1<PsiClassStub<?>, Boolean>(classFqName){
            final /* synthetic */ FqName $classFqName;
            {
                this.$classFqName = $classFqName;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PsiClassStub<?> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return Intrinsics.areEqual((Object)this.$classFqName.asString(), (Object)it.getQualifiedName());
            }
        });
        if (psiClass == null) {
            throw new IllegalStateException("Facade class " + classFqName + " not found; classes in Java file stub: " + LightClassDataHolderKt.collectClassNames($this$findDelegate));
        }
        return psiClass;
    }

    private static final String collectClassNames(PsiJavaFileStub javaFileStub) {
        List names = new ArrayList();
        LightClassUtil.INSTANCE.findClass((StubElement)javaFileStub, (Function1)new Function1<PsiClassStub<?>, Boolean>(names){
            final /* synthetic */ List<String> $names;
            {
                this.$names = $names;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull PsiClassStub<?> cls) {
                Intrinsics.checkNotNullParameter(cls, (String)"cls");
                String string = cls.getQualifiedName();
                if (string == null) {
                    string = "<null>";
                }
                this.$names.add(string);
                return false;
            }
        });
        return CollectionsKt.joinToString$default((Iterable)names, null, (CharSequence)"[", (CharSequence)"]", (int)0, null, null, (int)57, null);
    }
}

