/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilityUtils;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016JB\u0010\u000b\u001a&\u0012\u0004\u0012\u00020\r\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000f0\u000e0\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/ProtectedSyntheticExtensionCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "computeSuitableDescriptorAndError", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory3;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/descriptors/DescriptorVisibility;", "descriptor", "Lorg/jetbrains/kotlin/synthetic/SyntheticJavaPropertyDescriptor;", "frontend.java"})
public final class ProtectedSyntheticExtensionCallChecker
implements CallChecker {
    @NotNull
    public static final ProtectedSyntheticExtensionCallChecker INSTANCE = new ProtectedSyntheticExtensionCallChecker();

    private ProtectedSyntheticExtensionCallChecker() {
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Pair<FunctionDescriptor, DiagnosticFactory3<PsiElement, DeclarationDescriptor, DescriptorVisibility, DeclarationDescriptor>> computeSuitableDescriptorAndError(@NotNull SyntheticJavaPropertyDescriptor descriptor, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        v0 = context.getResolutionContext().callPosition;
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"context.resolutionContext.callPosition");
        callPosition = v0;
        if (!(callPosition instanceof CallPosition.PropertyAssignment)) ** GOTO lbl-1000
        var7_5 = ((CallPosition.PropertyAssignment)callPosition).getLeftPart();
        v1 = var7_5 instanceof KtDotQualifiedExpression != false ? (KtDotQualifiedExpression)var7_5 : null;
        if (Intrinsics.areEqual((Object)(v1 != null ? v1.getSelectorExpression() : null), (Object)reportOn)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        isLeftSide = v2;
        getMethod = descriptor.getGetMethod();
        setMethod = descriptor.getSetMethod();
        isImprovingDiagnosticsEnabled = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ImproveReportingDiagnosticsOnProtectedMembersOfBaseClass);
        needToTakeSetter = isImprovingDiagnosticsEnabled != false && isLeftSide != false;
        suitableDescriptor = needToTakeSetter != false && setMethod != null ? setMethod : getMethod;
        return TuplesKt.to((Object)suitableDescriptor, (Object)(needToTakeSetter != false && setMethod != null ? Errors.INVISIBLE_SETTER : Errors.INVISIBLE_MEMBER));
    }

    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        boolean bl;
        DeclarationDescriptor from;
        DiagnosticFactory3 error;
        CallableDescriptor descriptor2;
        block7: {
            Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
            Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            descriptor2 = resolvedCall.getResultingDescriptor();
            if (!(descriptor2 instanceof SyntheticJavaPropertyDescriptor)) {
                return;
            }
            Pair<FunctionDescriptor, DiagnosticFactory3<PsiElement, DeclarationDescriptor, DescriptorVisibility, DeclarationDescriptor>> pair = this.computeSuitableDescriptorAndError((SyntheticJavaPropertyDescriptor)descriptor2, reportOn, context);
            FunctionDescriptor sourceFunction = (FunctionDescriptor)pair.component1();
            error = (DiagnosticFactory3)pair.component2();
            from = context.getScope().getOwnerDescriptor();
            if (!DescriptorVisibilityUtils.isVisibleIgnoringReceiver((DeclarationDescriptorWithVisibility)((DeclarationDescriptorWithVisibility)descriptor2), (DeclarationDescriptor)from, (LanguageVersionSettings)context.getLanguageVersionSettings())) {
                return;
            }
            if (resolvedCall.getDispatchReceiver() != null && resolvedCall.getExtensionReceiver() == null) {
                return;
            }
            ReceiverValue receiverValue = resolvedCall.getExtensionReceiver();
            Intrinsics.checkNotNull((Object)receiverValue, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue");
            ReceiverValue receiverValue2 = receiverValue;
            Collection collection = CollectionsKt.listOf((Object)receiverValue2.getType());
            DataFlowInfo dataFlowInfo = context.getDataFlowInfo();
            DataFlowValueFactory dataFlowValueFactory = context.getDataFlowValueFactory();
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
            List receiverTypes = CollectionsKt.plus((Collection)collection, (Iterable)dataFlowInfo.getStableTypes(dataFlowValueFactory.createDataFlowValue(receiverValue2, bindingContext, context.getScope().getOwnerDescriptor()), context.getLanguageVersionSettings()));
            Iterable $this$none$iv = receiverTypes;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!DescriptorVisibilityUtils.isVisible((ReceiverValue)SmartCastUtilKt.getReceiverValueWithSmartCast(null, (KotlinType)it), (DeclarationDescriptorWithVisibility)((DeclarationDescriptorWithVisibility)sourceFunction), (DeclarationDescriptor)from, (LanguageVersionSettings)context.getLanguageVersionSettings())) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        if (bl) {
            context.getTrace().report((Diagnostic)error.on(reportOn, (Object)descriptor2, (Object)((SyntheticJavaPropertyDescriptor)descriptor2).getVisibility(), (Object)from));
        }
    }
}

