/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.pom.Navigatable;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.xml.AnnotatedElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.JavaMethodSignature;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.impl.Invocation;
import com.intellij.util.xml.impl.StaticGenericInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class InvocationCache {
    private static final Map<JavaMethodSignature, Invocation> ourCoreInvocations = new HashMap<JavaMethodSignature, Invocation>();
    private final Map<Method, Invocation> myInvocations = ConcurrentFactoryMap.createMap(key -> ourCoreInvocations.get(new JavaMethodSignature(key)));
    private final Map<Method, JavaMethod> myJavaMethods;
    private final Map<JavaMethod, Boolean> myGetters = ConcurrentFactoryMap.createMap(key -> DomImplUtil.isTagValueGetter(key));
    private final Map<JavaMethod, Boolean> mySetters = ConcurrentFactoryMap.createMap(key -> DomImplUtil.isTagValueSetter(key));
    private final Map<JavaMethod, Map<Class<? extends Annotation>, Object>> myMethodAnnotations = ConcurrentFactoryMap.createMap(method -> ConcurrentFactoryMap.createMap(annoClass -> method.getAnnotation(annoClass)));
    private final Map<Class, Object> myClassAnnotations;
    private final Class myType;
    final StaticGenericInfo genericInfo;

    private static void addCoreInvocations(Class<?> aClass) {
        for (Method method : ReflectionUtil.getClassDeclaredMethods(aClass)) {
            if ("equals".equals(method.getName())) {
                ourCoreInvocations.put(new JavaMethodSignature(method), (handler, args) -> {
                    Object arg;
                    DomElement proxy = handler.getProxy();
                    if (proxy == (arg = args[0])) {
                        return true;
                    }
                    if (arg == null) {
                        return false;
                    }
                    if (arg instanceof DomElement) {
                        DomInvocationHandler handler1 = DomManagerImpl.getDomInvocationHandler(proxy);
                        return handler1 != null && handler1.equals((Object)DomManagerImpl.getDomInvocationHandler((DomElement)arg));
                    }
                    return false;
                });
                continue;
            }
            if ("hashCode".equals(method.getName())) {
                ourCoreInvocations.put(new JavaMethodSignature(method), (handler, args) -> handler.hashCode());
                continue;
            }
            ourCoreInvocations.put(new JavaMethodSignature(method), (handler, args) -> method.invoke((Object)handler, args));
        }
    }

    InvocationCache(Class type) {
        this.myType = type;
        this.myJavaMethods = ConcurrentFactoryMap.createMap(key -> JavaMethod.getMethod((Class)this.myType, (Method)key));
        this.myClassAnnotations = ConcurrentFactoryMap.createMap(annoClass -> this.myType.getAnnotation(annoClass));
        this.genericInfo = new StaticGenericInfo(type);
    }

    @Nullable
    Invocation getInvocation(Method method) {
        Invocation invocation = this.myInvocations.get(method);
        if (invocation == null && (invocation = this.genericInfo.createInvocation(this.getInternedMethod(method))) != null) {
            this.myInvocations.put(method, invocation);
        }
        return invocation;
    }

    JavaMethod getInternedMethod(Method method) {
        return this.myJavaMethods.get(method);
    }

    boolean isTagValueGetter(JavaMethod method) {
        return this.myGetters.get(method);
    }

    boolean isTagValueSetter(JavaMethod method) {
        return this.mySetters.get(method);
    }

    @Nullable
    <T extends Annotation> T getMethodAnnotation(JavaMethod method, Class<T> annoClass) {
        return (T)((Annotation)this.myMethodAnnotations.get(method).get(annoClass));
    }

    @Nullable
    <T extends Annotation> T getClassAnnotation(Class<T> annoClass) {
        return (T)((Annotation)this.myClassAnnotations.get(annoClass));
    }

    static {
        InvocationCache.addCoreInvocations(DomElement.class);
        InvocationCache.addCoreInvocations(Navigatable.class);
        InvocationCache.addCoreInvocations(AnnotatedElement.class);
        InvocationCache.addCoreInvocations(Object.class);
        ourCoreInvocations.put(new JavaMethodSignature("getUserData", new Class[]{Key.class}), (handler, args) -> handler.getUserData((Key)args[0]));
        ourCoreInvocations.put(new JavaMethodSignature("putUserData", new Class[]{Key.class, Object.class}), (handler, args) -> {
            handler.putUserData((Key)args[0], args[1]);
            return null;
        });
        ourCoreInvocations.put(new JavaMethodSignature("getXmlElement", new Class[0]), (handler, args) -> handler.getXmlElement());
        ourCoreInvocations.put(new JavaMethodSignature("getXmlTag", new Class[0]), (handler, args) -> handler.getXmlTag());
        ourCoreInvocations.put(new JavaMethodSignature("getParent", new Class[0]), (handler, args) -> handler.getParent());
        ourCoreInvocations.put(new JavaMethodSignature("accept", new Class[]{DomElementVisitor.class}), (handler, args) -> {
            handler.accept((DomElementVisitor)args[0]);
            return null;
        });
        ourCoreInvocations.put(new JavaMethodSignature("acceptChildren", new Class[]{DomElementVisitor.class}), (handler, args) -> {
            handler.acceptChildren((DomElementVisitor)args[0]);
            return null;
        });
        ourCoreInvocations.put(new JavaMethodSignature("getAnnotation", new Class[]{Class.class}), (handler, args) -> handler.getAnnotation((Class)args[0]));
        ourCoreInvocations.put(new JavaMethodSignature("getRawText", new Class[0]), (handler, args) -> handler.getValue());
        ourCoreInvocations.put(new JavaMethodSignature("getXmlAttribute", new Class[0]), (handler, args) -> handler.getXmlElement());
        ourCoreInvocations.put(new JavaMethodSignature("getXmlAttributeValue", new Class[0]), (handler, args) -> {
            XmlAttribute attribute = (XmlAttribute)handler.getXmlElement();
            return attribute != null ? attribute.getValueElement() : null;
        });
        ourCoreInvocations.put(new JavaMethodSignature("getConverter", new Class[0]), (handler, args) -> {
            try {
                return handler.getScalarConverter();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                Throwable cause = e.getCause();
                if (cause instanceof ProcessCanceledException) {
                    throw cause;
                }
                throw new RuntimeException(e);
            }
        });
    }
}

