/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.impl.references;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.intellij.lang.xpath.xslt.quickfix.DownloadResourceFix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExternalResourceReference
implements PsiReference,
LocalQuickFixProvider {
    private final XmlAttribute myAttribute;
    private final ExternalResourceManager myResourceManager = ExternalResourceManager.getInstance();

    ExternalResourceReference(XmlAttribute attribute) {
        this.myAttribute = attribute;
    }

    public LocalQuickFix @Nullable [] getQuickFixes() {
        return new LocalQuickFix[]{new DownloadResourceFix(this.myAttribute.getValue())};
    }

    @NotNull
    public PsiElement getElement() {
        XmlAttributeValue xmlAttributeValue = this.myAttribute.getValueElement();
        if (xmlAttributeValue == null) {
            ExternalResourceReference.$$$reportNull$$$0(0);
        }
        return xmlAttributeValue;
    }

    @NotNull
    public TextRange getRangeInElement() {
        XmlAttributeValue value = this.myAttribute.getValueElement();
        TextRange textRange = value != null ? TextRange.from((int)1, (int)(value.getTextLength() - 2)) : TextRange.from((int)0, (int)0);
        if (textRange == null) {
            ExternalResourceReference.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @Nullable
    public PsiElement resolve() {
        String value = this.myAttribute.getValue();
        String resourceLocation = this.myResourceManager.getResourceLocation(value);
        if (resourceLocation != value) {
            VirtualFile file;
            try {
                file = VfsUtil.findFileByURL((URL)new URL(resourceLocation));
            }
            catch (MalformedURLException e) {
                try {
                    file = VfsUtil.findFileByURL((URL)new File(resourceLocation).toURI().toURL());
                }
                catch (MalformedURLException e1) {
                    file = null;
                }
            }
            if (file != null) {
                return this.myAttribute.getManager().findFile(file);
            }
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myAttribute.getValue();
        if (string == null) {
            ExternalResourceReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            ExternalResourceReference.$$$reportNull$$$0(3);
        }
        this.myAttribute.setValue(newElementName);
        XmlAttributeValue value = this.myAttribute.getValueElement();
        assert (value != null);
        return value;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            ExternalResourceReference.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            ExternalResourceReference.$$$reportNull$$$0(5);
        }
        return element == this.resolve();
    }

    public Object @NotNull [] getVariants() {
        Object[] objectArray = this.myResourceManager.getResourceUrls(null, false);
        if (objectArray == null) {
            ExternalResourceReference.$$$reportNull$$$0(6);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/impl/references/ExternalResourceReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/impl/references/ExternalResourceReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

