/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.i18n;

import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.batch.I18nizeMultipleStringsDialog;
import com.intellij.codeInspection.i18n.batch.I18nizedPropertyData;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.ResourceBundleManager;
import com.intellij.lang.properties.references.I18nizeQuickFixDialog;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.LoaderFactory;
import com.intellij.uiDesigner.ModuleProvider;
import com.intellij.uiDesigner.XmlReader;
import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.i18n.FormPropertyStringDescriptorAccessor;
import com.intellij.uiDesigner.i18n.I18nizeFormQuickFix;
import com.intellij.uiDesigner.i18n.TabTitleStringDescriptorAccessor;
import com.intellij.uiDesigner.inspections.FormElementProblemDescriptor;
import com.intellij.uiDesigner.lw.CompiledClassPropertiesProvider;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.lw.IContainer;
import com.intellij.uiDesigner.lw.IProperty;
import com.intellij.uiDesigner.lw.ITabbedPane;
import com.intellij.uiDesigner.lw.LwRootContainer;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import com.intellij.uiDesigner.lw.StringDescriptor;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.uiDesigner.radComponents.RadContainer;
import com.intellij.uiDesigner.radComponents.RadRootContainer;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import icons.UIDesignerIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UExpression;

public class I18nizeFormBatchFix
implements LocalQuickFix,
BatchQuickFix {
    private static final Logger LOG = Logger.getInstance(I18nizeFormBatchFix.class);
    private static final List<DefaultPrefixSuggestion> PREFIX_SUGGESTIONS = Arrays.asList(new DefaultPrefixSuggestion(LinkLabel.class, "text", "link"), new DefaultPrefixSuggestion(JLabel.class, "text", "label"), new DefaultPrefixSuggestion(JLabel.class, "toolTipText", "tooltip"), new DefaultPrefixSuggestion(JRadioButton.class, "text", "radio.button"), new DefaultPrefixSuggestion(JCheckBox.class, "text", "checkbox"), new DefaultPrefixSuggestion(JButton.class, "text", "button"), new DefaultPrefixSuggestion(TitledSeparator.class, "text", "separator.title"));

    public void applyFix(@NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        if (project == null) {
            I18nizeFormBatchFix.$$$reportNull$$$0(0);
        }
        if (psiElementsToIgnore == null) {
            I18nizeFormBatchFix.$$$reportNull$$$0(1);
        }
        if (descriptors == null) {
            I18nizeFormBatchFix.$$$reportNull$$$0(2);
        }
        ArrayList dataList = new ArrayList();
        HashSet contextFiles = new HashSet();
        HashMap containerMap = new HashMap();
        HashMap duplicates = new HashMap();
        ReadAction.nonBlocking(() -> {
            this.fillDuplicates(project, descriptors, dataList, contextFiles, containerMap, duplicates);
            return I18nizeMultipleStringsDialog.getResourceBundleManager((Project)project, (Set)contextFiles);
        }).finishOnUiThread(ModalityState.NON_MODAL, bundleManager -> this.showI18nizeMultipleStringsDialog(project, dataList, contextFiles, (ResourceBundleManager)bundleManager, containerMap, duplicates)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private void showI18nizeMultipleStringsDialog(@NotNull Project project, @NotNull List<I18nizedPropertyData<HardcodedStringInFormData>> dataList, @NotNull HashSet<PsiFile> contextFiles, @NotNull ResourceBundleManager bundleManager, @NotNull Map<VirtualFile, RadRootContainer> containerMap, @NotNull Map<String, List<I18nizedPropertyData<HardcodedStringInFormData>>> duplicates) {
        I18nizeMultipleStringsDialog dialog;
        if (project == null) {
            I18nizeFormBatchFix.$$$reportNull$$$0(3);
        }
        if (dataList == null) {
            I18nizeFormBatchFix.$$$reportNull$$$0(4);
        }
        if (contextFiles == null) {
            I18nizeFormBatchFix.$$$reportNull$$$0(5);
        }
        if (bundleManager == null) {
            I18nizeFormBatchFix.$$$reportNull$$$0(6);
        }
        if (containerMap == null) {
            I18nizeFormBatchFix.$$$reportNull$$$0(7);
        }
        if (duplicates == null) {
            I18nizeFormBatchFix.$$$reportNull$$$0(8);
        }
        if ((dialog = new I18nizeMultipleStringsDialog(project, dataList, contextFiles, bundleManager, I18nizeFormBatchFix::createUsageInfo, UIDesignerIcons.InspectionSuppression, false)).showAndGet()) {
            PropertiesFile propertiesFile = dialog.getPropertiesFile();
            PsiManager manager = PsiManager.getInstance((Project)project);
            HashSet<PsiFile> files = new HashSet<PsiFile>();
            for (VirtualFile file : containerMap.keySet()) {
                ContainerUtil.addIfNotNull(files, (Object)manager.findFile(file));
            }
            if (files.isEmpty()) {
                return;
            }
            files.add(propertiesFile.getContainingFile());
            String bundleName = I18nizeFormQuickFix.getBundleName(project, propertiesFile);
            if (bundleName == null) {
                return;
            }
            WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getFamilyName(), null, () -> {
                for (I18nizedPropertyData i18nizedPropertyData : dataList) {
                    StringDescriptor valueDescriptor;
                    if (!i18nizedPropertyData.isMarkAsNonNls()) {
                        JavaI18nUtil.DEFAULT_PROPERTY_CREATION_HANDLER.createProperty(project, Collections.singletonList(propertiesFile), i18nizedPropertyData.getKey(), i18nizedPropertyData.getValue(), new UExpression[0]);
                        valueDescriptor = new StringDescriptor(bundleName, i18nizedPropertyData.getKey());
                    } else {
                        valueDescriptor = StringDescriptor.create((String)i18nizedPropertyData.getValue());
                        valueDescriptor.setNoI18n(true);
                    }
                    I18nizeFormBatchFix.setPropertyValue(((HardcodedStringInFormData)i18nizedPropertyData.getContextData()).getComponent(), ((HardcodedStringInFormData)i18nizedPropertyData.getContextData()).getPropertyName(), valueDescriptor);
                    List duplicateValues = (List)duplicates.get(i18nizedPropertyData.getValue());
                    if (duplicateValues == null) continue;
                    for (I18nizedPropertyData duplicateBean : duplicateValues) {
                        I18nizeFormBatchFix.setPropertyValue(((HardcodedStringInFormData)duplicateBean.getContextData()).getComponent(), ((HardcodedStringInFormData)duplicateBean.getContextData()).getPropertyName(), valueDescriptor);
                    }
                }
                for (Map.Entry entry : containerMap.entrySet()) {
                    try {
                        XmlWriter writer = new XmlWriter();
                        ((RadRootContainer)entry.getValue()).write(writer);
                        VfsUtil.saveText((VirtualFile)((VirtualFile)entry.getKey()), (String)writer.getText());
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            }, (PsiFile[])files.toArray(PsiFile.EMPTY_ARRAY));
        }
    }

    private void fillDuplicates(final @NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors, List<I18nizedPropertyData<HardcodedStringInFormData>> dataList, HashSet<PsiFile> contextFiles, Map<VirtualFile, RadRootContainer> containerMap, Map<String, List<I18nizedPropertyData<HardcodedStringInFormData>>> duplicates) {
        if (project == null) {
            I18nizeFormBatchFix.$$$reportNull$$$0(9);
        }
        if (descriptors == null) {
            I18nizeFormBatchFix.$$$reportNull$$$0(10);
        }
        UniqueNameGenerator uniqueNameGenerator = new UniqueNameGenerator();
        for (CommonProblemDescriptor descriptor : descriptors) {
            String propertyName;
            String value;
            RadComponent component;
            FormElementProblemDescriptor formElementProblemDescriptor = (FormElementProblemDescriptor)descriptor;
            PsiFile containingFile = formElementProblemDescriptor.getPsiElement().getContainingFile();
            contextFiles.add(containingFile);
            VirtualFile virtualFile = containingFile.getVirtualFile();
            RadRootContainer rootContainer = containerMap.computeIfAbsent(virtualFile, f -> {
                try {
                    ClassLoader classLoader = LoaderFactory.getInstance(project).getLoader(virtualFile);
                    LwRootContainer lwRootContainer = Utils.getRootContainer((String)containingFile.getText(), (PropertiesProvider)new CompiledClassPropertiesProvider(classLoader));
                    final Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
                    ModuleProvider moduleProvider = new ModuleProvider(){

                        @Override
                        public Module getModule() {
                            return module;
                        }

                        @Override
                        public Project getProject() {
                            return project;
                        }
                    };
                    return XmlReader.createRoot(moduleProvider, lwRootContainer, LoaderFactory.getInstance(project).getLoader(virtualFile), null);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    return null;
                }
            });
            if (rootContainer == null || (component = (RadComponent)FormEditingUtil.findComponent(rootContainer, formElementProblemDescriptor.getComponentId())) == null || (value = I18nizeFormBatchFix.getValue(component, propertyName = formElementProblemDescriptor.getPropertyName())) == null) continue;
            String keyPrefix = I18nizeFormBatchFix.suggestPropertyKeyPrefix(component, propertyName);
            String defaultKey = keyPrefix != null ? keyPrefix + "." + I18nizeQuickFixDialog.generateDefaultPropertyKey((String)value) : null;
            String key = uniqueNameGenerator.generateUniqueName(I18nizeQuickFixDialog.suggestUniquePropertyKey((String)value, (String)defaultKey, null));
            I18nizedPropertyData data = new I18nizedPropertyData(key, value, (Object)new HardcodedStringInFormData(component, propertyName, containingFile));
            if (duplicates.containsKey(value)) {
                duplicates.computeIfAbsent(value, k -> new ArrayList(1)).add(data);
                continue;
            }
            dataList.add((I18nizedPropertyData<HardcodedStringInFormData>)data);
            duplicates.put(value, null);
        }
    }

    @Nullable
    private static String suggestPropertyKeyPrefix(@NotNull RadComponent component, @NotNull String propertyName) {
        if (component == null) {
            I18nizeFormBatchFix.$$$reportNull$$$0(11);
        }
        if (propertyName == null) {
            I18nizeFormBatchFix.$$$reportNull$$$0(12);
        }
        Class componentClass = component.getComponentClass();
        for (DefaultPrefixSuggestion suggestion : PREFIX_SUGGESTIONS) {
            if (!suggestion.getPropertyName().equals(propertyName) || !suggestion.getComponentClass().isAssignableFrom(componentClass)) continue;
            return suggestion.getDefaultPrefix();
        }
        if ("border".equals(propertyName)) {
            return "border.title";
        }
        if ("Tab Title".equals(propertyName)) {
            return "tab.title";
        }
        return null;
    }

    private static List<UsageInfo> createUsageInfo(HardcodedStringInFormData data) {
        PsiFile file;
        RadComponent component = data.getComponent();
        TextRange range = I18nizeFormBatchFix.getComponentRange(component, file = data.getContainingFile());
        UsageInfo usageInfo = range != null ? new UsageInfo((PsiElement)file, range.getStartOffset(), range.getEndOffset()) : new UsageInfo(file);
        return Collections.singletonList(usageInfo);
    }

    private static TextRange getComponentRange(RadComponent component, PsiFile file) {
        CharSequence contents = file.getViewProvider().getContents();
        int componentId = StringUtil.indexOf((CharSequence)contents, (CharSequence)("id=\"" + component.getId() + "\""));
        if (componentId == -1) {
            return null;
        }
        PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)file.getProject());
        XmlFile xmlFile = (XmlFile)fileFactory.createFileFromText("form.xml", (FileType)XmlFileType.INSTANCE, contents);
        XmlTag componentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)xmlFile.findElementAt(componentId), XmlTag.class);
        return componentTag != null ? componentTag.getTextRange() : null;
    }

    private static void setPropertyValue(RadComponent component, String propertyName, StringDescriptor stringDescriptor) {
        if ("border".equals(propertyName)) {
            ((RadContainer)component).setBorderTitle(stringDescriptor);
        } else if (propertyName.equals("Tab Title") || propertyName.equals("Tab Tooltip")) {
            try {
                new TabTitleStringDescriptorAccessor(component, propertyName).setStringDescriptorValue(stringDescriptor);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        } else {
            IProperty property = (IProperty)ContainerUtil.find((Object[])component.getModifiedProperties(), p -> propertyName.equals(p.getName()));
            if (property != null) {
                try {
                    new FormPropertyStringDescriptorAccessor(component, (IntrospectedProperty)property).setStringDescriptorValue(stringDescriptor);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            } else {
                LOG.error("Property '" + propertyName + "' not found in modified properties for component " + component.getId());
            }
        }
    }

    private static String getValue(IComponent component, String propertyName) {
        if ("border".equals(propertyName)) {
            return ((IContainer)component).getBorderTitle().getValue();
        }
        if (propertyName.equals("Tab Title") || propertyName.equals("Tab Tooltip")) {
            return ((ITabbedPane)component.getParentContainer()).getTabProperty(component, propertyName).getValue();
        }
        for (IProperty property : component.getModifiedProperties()) {
            if (!property.getName().equals(propertyName)) continue;
            return ((StringDescriptor)property.getPropertyValue(component)).getValue();
        }
        return null;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaI18nBundle.message((String)"inspection.i18n.quickfix", (Object[])new Object[0]);
        if (string == null) {
            I18nizeFormBatchFix.$$$reportNull$$$0(13);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            I18nizeFormBatchFix.$$$reportNull$$$0(14);
        }
        if (descriptor == null) {
            I18nizeFormBatchFix.$$$reportNull$$$0(15);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementsToIgnore";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataList";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFiles";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bundleManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerMap";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/i18n/I18nizeFormBatchFix";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/i18n/I18nizeFormBatchFix";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showI18nizeMultipleStringsDialog";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fillDuplicates";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "suggestPropertyKeyPrefix";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DefaultPrefixSuggestion {
        private final Class<?> myComponentClass;
        private final String myPropertyName;
        private final String myDefaultPrefix;

        private DefaultPrefixSuggestion(Class<?> componentClass, String propertyName, String defaultPrefix) {
            this.myComponentClass = componentClass;
            this.myPropertyName = propertyName;
            this.myDefaultPrefix = defaultPrefix;
        }

        private Class<?> getComponentClass() {
            return this.myComponentClass;
        }

        private String getPropertyName() {
            return this.myPropertyName;
        }

        private String getDefaultPrefix() {
            return this.myDefaultPrefix;
        }
    }

    private static final class HardcodedStringInFormData {
        private final RadComponent myComponent;
        private final String myPropertyName;
        private final PsiFile myContainingFile;

        private HardcodedStringInFormData(@NotNull RadComponent component, @NotNull String propertyName, @NotNull PsiFile containingFile) {
            if (component == null) {
                HardcodedStringInFormData.$$$reportNull$$$0(0);
            }
            if (propertyName == null) {
                HardcodedStringInFormData.$$$reportNull$$$0(1);
            }
            if (containingFile == null) {
                HardcodedStringInFormData.$$$reportNull$$$0(2);
            }
            this.myComponent = component;
            this.myPropertyName = propertyName;
            this.myContainingFile = containingFile;
        }

        private RadComponent getComponent() {
            return this.myComponent;
        }

        private String getPropertyName() {
            return this.myPropertyName;
        }

        private PsiFile getContainingFile() {
            return this.myContainingFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "propertyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "containingFile";
                    break;
                }
            }
            objectArray[1] = "com/intellij/uiDesigner/i18n/I18nizeFormBatchFix$HardcodedStringInFormData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

