/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.propertyInspector.properties;

import com.intellij.uiDesigner.XmlWriter;
import com.intellij.uiDesigner.propertyInspector.IntrospectedProperty;
import com.intellij.uiDesigner.propertyInspector.PropertyEditor;
import com.intellij.uiDesigner.propertyInspector.PropertyRenderer;
import com.intellij.uiDesigner.propertyInspector.editors.ListModelEditor;
import com.intellij.uiDesigner.propertyInspector.renderers.LabelPropertyRenderer;
import com.intellij.uiDesigner.radComponents.RadComponent;
import com.intellij.util.ArrayUtilRt;
import java.lang.reflect.Method;
import javax.swing.DefaultComboBoxModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class IntroListModelProperty
extends IntrospectedProperty<String[]> {
    private LabelPropertyRenderer<String[]> myRenderer;
    private ListModelEditor myEditor;
    @NonNls
    private static final String CLIENT_PROPERTY_KEY_PREFIX = "IntroListModelProperty_";

    public IntroListModelProperty(String name, Method readMethod, Method writeMethod, boolean storeAsClient) {
        super(name, readMethod, writeMethod, storeAsClient);
    }

    @Override
    public void write(String[] value, XmlWriter writer) {
        for (String s : value) {
            writer.startElement("item");
            writer.addAttribute("value", s);
            writer.endElement();
        }
    }

    @Override
    @NotNull
    public PropertyRenderer<String[]> getRenderer() {
        if (this.myRenderer == null) {
            this.myRenderer = new MyRenderer();
        }
        LabelPropertyRenderer<String[]> labelPropertyRenderer = this.myRenderer;
        if (labelPropertyRenderer == null) {
            IntroListModelProperty.$$$reportNull$$$0(0);
        }
        return labelPropertyRenderer;
    }

    @Override
    public PropertyEditor<String[]> getEditor() {
        if (this.myEditor == null) {
            this.myEditor = new ListModelEditor(this.getName());
        }
        return this.myEditor;
    }

    @Override
    public String[] getValue(RadComponent component) {
        String[] strings = (String[])component.getDelegee().getClientProperty(CLIENT_PROPERTY_KEY_PREFIX + this.getName());
        if (strings == null) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        return strings;
    }

    @Override
    protected void setValueImpl(RadComponent component, String[] value) throws Exception {
        component.getDelegee().putClientProperty(CLIENT_PROPERTY_KEY_PREFIX + this.getName(), value);
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (String s : value) {
            model.addElement(s);
        }
        this.invokeSetter(component, model);
    }

    @Override
    public void resetValue(RadComponent component) throws Exception {
        super.resetValue(component);
        component.getDelegee().putClientProperty(CLIENT_PROPERTY_KEY_PREFIX + this.getName(), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/propertyInspector/properties/IntroListModelProperty", "getRenderer"));
    }

    private static class MyRenderer
    extends LabelPropertyRenderer<String[]> {
        private MyRenderer() {
        }

        @Override
        protected void customize(String[] value) {
            this.setText(ListModelEditor.listValueToString(value));
        }
    }
}

