/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.ObjectObjectAssociativeContainer;
import com.carrotsearch.hppc.ObjectObjectHashMap;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;

public class ObjectObjectIdentityHashMap<KType, VType>
extends ObjectObjectHashMap<KType, VType> {
    public ObjectObjectIdentityHashMap() {
        this(4);
    }

    public ObjectObjectIdentityHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectObjectIdentityHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.randomized());
    }

    public ObjectObjectIdentityHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public ObjectObjectIdentityHashMap(ObjectObjectAssociativeContainer<? extends KType, ? extends VType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public int hashKey(KType key) {
        assert (key != null);
        return BitMixer.mix(System.identityHashCode(key), this.keyMixer);
    }

    @Override
    public boolean equals(Object v1, Object v2) {
        return v1 == v2;
    }

    @Override
    protected boolean equalElements(ObjectObjectHashMap<?, ?> other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (ObjectObjectCursor<?, ?> objectObjectCursor : other) {
            Object key = objectObjectCursor.key;
            if (this.containsKey(key) && this.equals(this.get(key), objectObjectCursor.value)) continue;
            return false;
        }
        return true;
    }

    public static <KType, VType> ObjectObjectIdentityHashMap<KType, VType> from(KType[] keys, VType[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectObjectIdentityHashMap<KType, VType> map2 = new ObjectObjectIdentityHashMap<KType, VType>(keys.length);
        for (int i2 = 0; i2 < keys.length; ++i2) {
            map2.put(keys[i2], values[i2]);
        }
        return map2;
    }
}

