/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.diagnostic.PluginException;
import com.intellij.grazie.grammar.strategy.GrammarCheckingStrategy;
import com.intellij.grazie.ide.language.LanguageGrammarChecking;
import com.intellij.grazie.text.StrategyTextExtractor;
import com.intellij.grazie.text.TextContent;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class TextExtractor {
    private static final Logger LOG = Logger.getInstance(TextExtractor.class);
    @VisibleForTesting
    static final LanguageExtension<TextExtractor> EP = new LanguageExtension("com.intellij.grazie.textExtractor");
    private static final Key<CachedValue<Cache>> COMMON_PARENT_CACHE = Key.create((String)"TextExtractor common parent cache");
    private static final Key<CachedValue<Cache>> QUERY_CACHE = Key.create((String)"TextExtractor query cache");
    private static final Key<Boolean> IGNORED = Key.create((String)"TextExtractor ignored");
    private static final Pattern SUPPRESSION = Pattern.compile("\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*");

    @Nullable
    protected TextContent buildTextContent(@NotNull PsiElement element, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (element == null) {
            TextExtractor.$$$reportNull$$$0(0);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(1);
        }
        throw new UnsupportedOperationException("Please implement either buildTextContent or buildTextContents");
    }

    @NotNull
    protected List<TextContent> buildTextContents(@NotNull PsiElement element, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (element == null) {
            TextExtractor.$$$reportNull$$$0(2);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(3);
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)this.buildTextContent(element, allowedDomains));
        if (list == null) {
            TextExtractor.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public static TextContent findTextAt(@NotNull PsiFile file2, int offset, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        PsiElement leaf;
        TextContent result;
        if (file2 == null) {
            TextExtractor.$$$reportNull$$$0(5);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(6);
        }
        TextContent textContent = result = (leaf = file2.findElementAt(offset)) == null ? null : (TextContent)ContainerUtil.find(TextExtractor.findTextsAt(leaf, allowedDomains), c -> c.fileOffsetToText(offset) != null);
        if (result != null) {
            return result;
        }
        if ((leaf == null || offset == leaf.getTextRange().getStartOffset()) && (leaf = file2.findElementAt(offset - 1)) != null) {
            return (TextContent)ContainerUtil.find(TextExtractor.findTextsAt(leaf, allowedDomains), c -> c.fileOffsetToText(offset) != null);
        }
        return null;
    }

    @Deprecated
    @Nullable
    public static TextContent findTextAt(@NotNull PsiElement psi, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (psi == null) {
            TextExtractor.$$$reportNull$$$0(7);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(8);
        }
        return (TextContent)ContainerUtil.getFirstItem(TextExtractor.findTextsAt(psi, allowedDomains));
    }

    @NotNull
    public static List<TextContent> findTextsAt(@NotNull PsiElement psi, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (psi == null) {
            TextExtractor.$$$reportNull$$$0(9);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(10);
        }
        TextRange psiRange = psi.getTextRange();
        JBIterable hierarchy = SyntaxTraverser.psiApi().parents((Object)psi);
        for (PsiElement each : hierarchy) {
            List cached;
            CachedValue cache = (CachedValue)each.getUserData(COMMON_PARENT_CACHE);
            if (cache == null || (cached = ContainerUtil.filter(((Cache)cache.getValue()).getCached(allowedDomains), c -> c.getUserData(IGNORED) == null && c.intersectsRange(psiRange))).isEmpty()) continue;
            List list = cached;
            if (list == null) {
                TextExtractor.$$$reportNull$$$0(11);
            }
            return list;
        }
        Language fileLanguage = psi.getContainingFile().getLanguage();
        for (PsiElement each : hierarchy) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            List<TextContent> contents = TextExtractor.obtainContents(allowedDomains, fileLanguage, each);
            if (stamp.mayCacheNow() && !contents.isEmpty()) {
                StreamEx.of(contents).groupingBy(TextContent::getCommonParent).forEach((commonParent, group) -> TextExtractor.obtainCache(commonParent, COMMON_PARENT_CACHE).register(allowedDomains, (List<TextContent>)group));
            }
            if (contents.isEmpty()) continue;
            List list = ContainerUtil.filter(contents, c -> c.getUserData(IGNORED) == null && allowedDomains.contains((Object)c.getDomain()) && c.intersectsRange(psiRange));
            if (list == null) {
                TextExtractor.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<TextContent> list = Collections.emptyList();
        if (list == null) {
            TextExtractor.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static Cache obtainCache(PsiElement psi, Key<CachedValue<Cache>> key) {
        CachedValue cache = CachedValuesManager.getManager((Project)psi.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)new Cache(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        cache = (CachedValue)((UserDataHolderEx)psi).putUserDataIfAbsent(key, (Object)cache);
        return (Cache)cache.getValue();
    }

    private static List<TextContent> obtainContents(Set<TextContent.TextDomain> allowedDomains, Language fileLanguage, PsiElement psi) {
        List<TextContent> result;
        CachedValue cv = (CachedValue)psi.getUserData(QUERY_CACHE);
        if (cv != null && !(result = ((Cache)cv.getValue()).getCached(allowedDomains)).isEmpty()) {
            return result;
        }
        RecursionGuard.StackStamp stamp = RecursionManager.markStack();
        Language psiLanguage = psi.getLanguage();
        List<TextContent> contents = TextExtractor.doExtract(psi, allowedDomains, psiLanguage);
        if (contents.isEmpty() && fileLanguage != psiLanguage) {
            contents = TextExtractor.doExtract(psi, allowedDomains, fileLanguage);
        }
        for (TextContent content2 : contents) {
            if (!TextExtractor.shouldIgnore(content2)) continue;
            content2.putUserData(IGNORED, true);
        }
        if (!contents.isEmpty() && stamp.mayCacheNow()) {
            TextExtractor.obtainCache(psi, QUERY_CACHE).register(allowedDomains, contents);
        }
        return contents;
    }

    private static boolean shouldIgnore(TextContent content2) {
        return TextExtractor.hasIntersectingInjection(content2, content2.getContainingFile()) || TextExtractor.isSuppressionComment(content2) || TextExtractor.isCopyrightComment(content2);
    }

    private static boolean isCopyrightComment(TextContent content2) {
        return (content2.getDomain() == TextContent.TextDomain.COMMENTS || content2.getDomain() == TextContent.TextDomain.DOCUMENTATION) && StringUtil.containsIgnoreCase((String)content2.toString(), (String)"Copyright") && TextExtractor.isAtFileStart(content2);
    }

    private static boolean isAtFileStart(TextContent content2) {
        PsiFile file2 = content2.getContainingFile();
        int textStart = content2.textOffsetToFile(0);
        return file2.getViewProvider().getContents().subSequence(0, textStart).chars().noneMatch(Character::isLetterOrDigit);
    }

    private static boolean isSuppressionComment(TextContent content2) {
        return content2.getDomain() == TextContent.TextDomain.COMMENTS && SUPPRESSION.matcher(content2).matches();
    }

    @Deprecated
    @Nullable
    public static TextContent findUniqueTextAt(@NotNull PsiElement psi, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (psi == null) {
            TextExtractor.$$$reportNull$$$0(14);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(15);
        }
        return (TextContent)ContainerUtil.getFirstItem(TextExtractor.findUniqueTextsAt(psi, allowedDomains));
    }

    @NotNull
    public static List<TextContent> findUniqueTextsAt(@NotNull PsiElement psi, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        if (psi == null) {
            TextExtractor.$$$reportNull$$$0(16);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(17);
        }
        if (psi.getFirstChild() != null) {
            List<TextContent> list = Collections.emptyList();
            if (list == null) {
                TextExtractor.$$$reportNull$$$0(18);
            }
            return list;
        }
        TextRange psiRange = psi.getTextRange();
        List list = ContainerUtil.filter(TextExtractor.findTextsAt(psi, allowedDomains), c -> psiRange.contains(c.textOffsetToFile(0)));
        if (list == null) {
            TextExtractor.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static boolean hasIntersectingInjection(TextContent content2, PsiFile file2) {
        return InjectedLanguageManager.getInstance((Project)file2.getProject()).findInjectedElementAt(file2, content2.textOffsetToFile(0)) != null;
    }

    @NotNull
    private static List<TextContent> doExtract(@NotNull PsiElement anyRoot, @NotNull Set<TextContent.TextDomain> allowedDomains, @NotNull Language language) {
        TextExtractor extractor;
        if (anyRoot == null) {
            TextExtractor.$$$reportNull$$$0(20);
        }
        if (allowedDomains == null) {
            TextExtractor.$$$reportNull$$$0(21);
        }
        if (language == null) {
            TextExtractor.$$$reportNull$$$0(22);
        }
        if ((extractor = (TextExtractor)EP.forLanguage(language)) != null) {
            List<TextContent> contents = extractor.buildTextContents(anyRoot, allowedDomains);
            for (TextContent content2 : contents) {
                if (content2.getCommonParent().getTextRange().contains(content2.textRangeToFile(TextRange.from((int)0, (int)content2.length())))) continue;
                PluginException.logPluginError((Logger)LOG, (String)"Inconsistent text content", null, extractor.getClass());
                List<TextContent> list = List.of();
                if (list == null) {
                    TextExtractor.$$$reportNull$$$0(23);
                }
                return list;
            }
            List<TextContent> list = contents;
            if (list == null) {
                TextExtractor.$$$reportNull$$$0(24);
            }
            return list;
        }
        for (GrammarCheckingStrategy strategy : LanguageGrammarChecking.INSTANCE.allForLanguage(language)) {
            GrammarCheckingStrategy.TextDomain oldDomain;
            TextContent.TextDomain domain;
            if (!strategy.isMyContextRoot(anyRoot) || (domain = StrategyTextExtractor.convertDomain(oldDomain = strategy.getContextRootTextDomain(anyRoot))) == null || !allowedDomains.contains((Object)domain)) continue;
            List list = ContainerUtil.createMaybeSingletonList((Object)new StrategyTextExtractor(strategy).extractText(strategy.getRootsChain(anyRoot)));
            if (list == null) {
                TextExtractor.$$$reportNull$$$0(25);
            }
            return list;
        }
        List<TextContent> list = Collections.emptyList();
        if (list == null) {
            TextExtractor.$$$reportNull$$$0(26);
        }
        return list;
    }

    public static Set<Language> getSupportedLanguages() {
        HashSet<Language> result = new HashSet<Language>();
        ExtensionPoint ep = ApplicationManager.getApplication().getExtensionArea().getExtensionPoint(EP.getName());
        for (LanguageExtensionPoint point : ep.getExtensionList()) {
            ContainerUtil.addIfNotNull(result, (Object)Language.findLanguageByID((String)point.language));
        }
        for (LanguageExtensionPoint point : LanguageGrammarChecking.EP_NAME.getExtensionList()) {
            ContainerUtil.addIfNotNull(result, (Object)Language.findLanguageByID((String)point.language));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedDomains";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grazie/text/TextExtractor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 9: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anyRoot";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grazie/text/TextExtractor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTextContents";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findTextsAt";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findUniqueTextsAt";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "doExtract";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTextContent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildTextContents";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findTextAt";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findTextsAt";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findUniqueTextAt";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findUniqueTextsAt";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doExtract";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Cache {
        final EnumSet<TextContent.TextDomain> checkedDomains = EnumSet.noneOf(TextContent.TextDomain.class);
        final LinkedHashSet<TextContent> foundContents = new LinkedHashSet();

        private Cache() {
        }

        synchronized void register(Set<TextContent.TextDomain> allowedDomains, List<TextContent> contents) {
            this.checkedDomains.addAll(allowedDomains);
            this.foundContents.addAll(contents);
        }

        synchronized List<TextContent> getCached(Set<TextContent.TextDomain> allowedDomains) {
            return this.checkedDomains.containsAll(allowedDomains) ? ContainerUtil.filter(this.foundContents, c -> allowedDomains.contains((Object)c.getDomain())) : Collections.emptyList();
        }
    }
}

