/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.loomchild.segment.srx.SrxDocument;
import net.loomchild.segment.util.IORuntimeException;
import net.loomchild.segment.util.IgnoreDTDEntityResolver;
import net.loomchild.segment.util.ResourceNotFoundException;
import net.loomchild.segment.util.TransformationErrorListener;
import net.loomchild.segment.util.XmlException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final int READ_BUFFER_SIZE = 1024;
    public static final String MANIFEST_PATH = "/META-INF/MANIFEST.MF";
    private static final Pattern STAR_PATTERN = Pattern.compile("(?<=(?<!\\\\)(?:\\\\\\\\){0,100})\\*");
    private static final Pattern PLUS_PATTERN = Pattern.compile("(?<=(?<!\\\\)(?:\\\\\\\\){0,100})(?<![\\?\\*\\+]|\\{[0-9],?[0-9]?\\}?\\})\\+");
    private static final Pattern RANGE_PATTERN = Pattern.compile("(?<=(?<!\\\\)(?:\\\\\\\\){0,100})\\{\\s*([0-9]+)\\s*,\\s*\\}");
    private static final Pattern CAPTURING_GROUP_PATTERN = Pattern.compile("(?<=(?<!\\\\)(?:\\\\\\\\){0,100})\\((?!\\?)");

    public static Reader getReader(InputStream inputStream) {
        try {
            InputStreamReader reader = new InputStreamReader(inputStream, "utf-8");
            return reader;
        }
        catch (UnsupportedEncodingException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Writer getWriter(OutputStream outputStream) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, "utf-8");
            return writer;
        }
        catch (UnsupportedEncodingException e) {
            throw new IORuntimeException(e);
        }
    }

    public static FileInputStream getFileInputStream(String fileName2) {
        try {
            return new FileInputStream(fileName2);
        }
        catch (FileNotFoundException e) {
            throw new IORuntimeException(e);
        }
    }

    public static FileOutputStream getFileOutputStream(String fileName2) {
        try {
            return new FileOutputStream(fileName2);
        }
        catch (FileNotFoundException e) {
            throw new IORuntimeException(e);
        }
    }

    public static InputStream getResourceStream(String name) {
        InputStream inputStream = Util.class.getClassLoader().getResourceAsStream(name);
        if (inputStream == null) {
            throw new ResourceNotFoundException(name);
        }
        return inputStream;
    }

    public static String readAll(Reader reader) {
        StringWriter writer = new StringWriter();
        Util.copyAll(reader, writer);
        return writer.toString();
    }

    public static void copyAll(Reader reader, Writer writer) {
        try {
            int count;
            char[] readBuffer = new char[1024];
            while ((count = reader.read(readBuffer)) != -1) {
                writer.write(readBuffer, 0, count);
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Manifest getJarManifest(Class<?> klass) {
        URL classUrl = klass.getResource(klass.getSimpleName() + ".class");
        if (classUrl == null) {
            throw new IllegalArgumentException("Class not found: " + klass.getName() + ".");
        }
        String classPath = classUrl.toString();
        int jarIndex = classPath.indexOf(33);
        if (jarIndex != -1) {
            String manifestPath = classPath.substring(0, jarIndex + 1) + MANIFEST_PATH;
            try {
                URL manifestUrl = new URL(manifestPath);
                InputStream manifestStream = manifestUrl.openStream();
                Manifest manifest = new Manifest(manifestStream);
                return manifest;
            }
            catch (IOException e) {
                throw new ResourceNotFoundException("IO Error retrieving manifest.", e);
            }
        }
        throw new ResourceNotFoundException("Class is not in a JAR archive " + klass.getName() + ".");
    }

    public static XMLReader getXmlReader(Schema schema) {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setValidating(false);
            parserFactory.setNamespaceAware(true);
            if (schema != null) {
                parserFactory.setSchema(schema);
            }
            SAXParser saxParser = parserFactory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setEntityResolver(new IgnoreDTDEntityResolver());
            return xmlReader;
        }
        catch (ParserConfigurationException e) {
            throw new XmlException("SAX Parser configuration error.", e);
        }
        catch (SAXException e) {
            throw new XmlException("Error creating XMLReader.", e);
        }
    }

    public static XMLReader getXmlReader() {
        return Util.getXmlReader(null);
    }

    public static Schema getSchema(Reader reader) {
        return Util.getSchema(new Reader[]{reader});
    }

    public static Schema getSchema(Reader[] readerArray) {
        try {
            Source[] sourceArray = new Source[readerArray.length];
            for (int i2 = 0; i2 < readerArray.length; ++i2) {
                Reader reader = readerArray[i2];
                StreamSource source2 = new StreamSource(reader);
                sourceArray[i2] = source2;
            }
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(sourceArray);
            return schema;
        }
        catch (SAXException e) {
            throw new XmlException("Error creating XML Schema.", e);
        }
    }

    public static Source getSource(Reader reader, Schema schema) {
        SAXSource source2 = new SAXSource(Util.getXmlReader(schema), new InputSource(reader));
        return source2;
    }

    public static JAXBContext getContext(String context) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)context);
            return jaxbContext;
        }
        catch (JAXBException e) {
            throw new XmlException("Error creating JAXB context", e);
        }
    }

    public static JAXBContext getContext(String context, ClassLoader classLoader) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)context, (ClassLoader)classLoader);
            return jaxbContext;
        }
        catch (JAXBException e) {
            throw new XmlException("Error creating JAXB context", e);
        }
    }

    public static JAXBContext getContext(Class<?> ... classesToBeBound) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])classesToBeBound);
            return jaxbContext;
        }
        catch (JAXBException e) {
            throw new XmlException("Error creating JAXB context", e);
        }
    }

    public static Templates getTemplates(Reader reader) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            StreamSource source2 = new StreamSource(reader);
            Templates templates = factory.newTemplates(source2);
            return templates;
        }
        catch (TransformerConfigurationException e) {
            throw new XmlException("Error creating XSLT templates.", e);
        }
    }

    public static void transform(Templates templates, Schema schema, Reader reader, Writer writer, Map<String, Object> parameterMap) {
        try {
            Source source2 = Util.getSource(reader, schema);
            StreamResult result = new StreamResult(writer);
            Transformer transformer = templates.newTransformer();
            transformer.setErrorListener(new TransformationErrorListener());
            for (Map.Entry<String, Object> entry : parameterMap.entrySet()) {
                transformer.setParameter(entry.getKey(), entry.getValue());
            }
            transformer.transform(source2, result);
        }
        catch (TransformerConfigurationException e) {
            throw new XmlException("Error creating XSLT transformer.", e);
        }
        catch (TransformerException e) {
            throw new XmlException("XSLT transformer error.", e);
        }
    }

    public static void transform(Templates templates, Schema schema, Reader reader, Writer writer) {
        Map<String, Object> parameterMap = Collections.emptyMap();
        Util.transform(templates, schema, reader, writer, parameterMap);
    }

    public static void transform(Templates templates, Reader reader, Writer writer, Map<String, Object> parameterMap) {
        Util.transform(templates, null, reader, writer, parameterMap);
    }

    public static void transform(Templates templates, Reader reader, Writer writer) {
        Map<String, Object> parameterMap = Collections.emptyMap();
        Util.transform(templates, reader, writer, parameterMap);
    }

    public static String removeBlockQuotes(String pattern) {
        StringBuilder patternBuilder = new StringBuilder();
        boolean quote = false;
        int previousChar = 0;
        for (int i2 = 0; i2 < pattern.length(); ++i2) {
            char currentChar = pattern.charAt(i2);
            if (quote) {
                if (previousChar == 92 && currentChar == 'E') {
                    quote = false;
                    patternBuilder.delete(patternBuilder.length() - 2, patternBuilder.length());
                } else {
                    patternBuilder.append('\\');
                    patternBuilder.append(currentChar);
                }
            } else if (previousChar == 92 && currentChar == 'Q') {
                quote = true;
                patternBuilder.deleteCharAt(patternBuilder.length() - 1);
            } else {
                patternBuilder.append(currentChar);
            }
            previousChar = currentChar;
        }
        return patternBuilder.toString();
    }

    public static String finitize(String pattern, int infinity) {
        String finitePattern = Util.removeBlockQuotes(pattern);
        Matcher starMatcher = STAR_PATTERN.matcher(finitePattern);
        finitePattern = starMatcher.replaceAll("{0," + infinity + "}");
        Matcher plusMatcher = PLUS_PATTERN.matcher(finitePattern);
        finitePattern = plusMatcher.replaceAll("{1," + infinity + "}");
        Matcher rangeMatcher = RANGE_PATTERN.matcher(finitePattern);
        finitePattern = rangeMatcher.replaceAll("{$1," + infinity + "}");
        return finitePattern;
    }

    public static Pattern compile(SrxDocument document, String regex2) {
        String key = "PATTERN_" + regex2;
        Pattern pattern = (Pattern)document.getCache().get(key);
        if (pattern == null) {
            pattern = Pattern.compile(regex2);
            document.getCache().put(key, pattern);
        }
        return pattern;
    }

    public static String removeCapturingGroups(String pattern) {
        String newPattern = Util.removeBlockQuotes(pattern);
        Matcher capturingGroupMatcher = CAPTURING_GROUP_PATTERN.matcher(newPattern);
        newPattern = capturingGroupMatcher.replaceAll("(?:");
        return newPattern;
    }

    public static <T> T getParameter(Object value, T defaultValue) {
        Object result = value != null ? value : defaultValue;
        return (T)result;
    }

    public static Map<String, Object> getEmptyParameterMap() {
        return Collections.emptyMap();
    }
}

