/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.languagetool.DynamicLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.rules.Rule;
import org.languagetool.rules.spelling.hunspell.HunspellRule;

class DynamicHunspellLanguage
extends DynamicLanguage {
    DynamicHunspellLanguage(String name, String code2, File dictPath) {
        super(name, code2, dictPath);
    }

    @Override
    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        HunspellRule r = new HunspellRule(JLanguageTool.getMessageBundle(Languages.getLanguageForShortCode("en-US")), this, userConfig){

            @Override
            public String getId() {
                return DynamicHunspellLanguage.this.code.toUpperCase() + "_SPELLER_RULE";
            }

            @Override
            @NotNull
            protected String getDictFilenameInResources(String langCountry) {
                return DynamicHunspellLanguage.this.dictPath.getAbsolutePath().replaceAll(".dic$", "");
            }

            @Override
            public String getSpellingFileName() {
                return null;
            }
        };
        return Collections.singletonList(r);
    }
}

